/**
 * This file is part of VERA PDF UI, a module of the veraPDF project.
 * Copyright (c) 2015, veraPDF Consortium <info@verapdf.org>
 * All rights reserved.
 *
 * VERA PDF UI is free software: you can redistribute it and/or modify
 * it under the terms of either:
 *
 * The GNU General public license GPLv3+.
 * You should have received a copy of the GNU General Public License
 * along with VERA PDF UI as the LICENSE.GPL file in the root of the source
 * tree.  If not, see http://www.gnu.org/licenses/ or
 * https://www.gnu.org/licenses/gpl-3.0.en.html.
 *
 * The Mozilla Public License MPLv2+.
 * You should have received a copy of the Mozilla Public License along with
 * VERA PDF UI as the LICENSE.MPL file in the root of the source tree.
 * If a copy of the MPL was not distributed with this file, you can obtain one at
 * http://mozilla.org/MPL/2.0/.
 */
/*
 * generated by Xtext
 */
package org.verapdf.ui.contentassist.antlr;

import java.util.Collection;
import java.util.Map;
import java.util.HashMap;

import org.antlr.runtime.RecognitionException;
import org.eclipse.xtext.AbstractElement;
import org.eclipse.xtext.ui.editor.contentassist.antlr.AbstractContentAssistParser;
import org.eclipse.xtext.ui.editor.contentassist.antlr.FollowElement;
import org.eclipse.xtext.ui.editor.contentassist.antlr.internal.AbstractInternalContentAssistParser;

import com.google.inject.Inject;

import org.verapdf.services.ModelGrammarAccess;

public class ModelParser extends AbstractContentAssistParser {
	
	@Inject
	private ModelGrammarAccess grammarAccess;
	
	private Map<AbstractElement, String> nameMappings;
	
	@Override
	protected org.verapdf.ui.contentassist.antlr.internal.InternalModelParser createParser() {
		org.verapdf.ui.contentassist.antlr.internal.InternalModelParser result = new org.verapdf.ui.contentassist.antlr.internal.InternalModelParser(null);
		result.setGrammarAccess(grammarAccess);
		return result;
	}
	
	@Override
	protected String getRuleName(AbstractElement element) {
		if (nameMappings == null) {
			nameMappings = new HashMap<AbstractElement, String>() {
				private static final long serialVersionUID = 1L;
				{
					put(grammarAccess.getAttributeAccess().getAlternatives(), "rule__Attribute__Alternatives");
					put(grammarAccess.getPropertyAccess().getTypeAlternatives_4_0(), "rule__Property__TypeAlternatives_4_0");
					put(grammarAccess.getLinkAccess().getAlternatives_5(), "rule__Link__Alternatives_5");
					put(grammarAccess.getModelAccess().getGroup(), "rule__Model__Group__0");
					put(grammarAccess.getEntityAccess().getGroup(), "rule__Entity__Group__0");
					put(grammarAccess.getEntityAccess().getGroup_3(), "rule__Entity__Group_3__0");
					put(grammarAccess.getPropertyAccess().getGroup(), "rule__Property__Group__0");
					put(grammarAccess.getLinkAccess().getGroup(), "rule__Link__Group__0");
					put(grammarAccess.getImportAccess().getGroup(), "rule__Import__Group__0");
					put(grammarAccess.getQualifiedNameAccess().getGroup(), "rule__QualifiedName__Group__0");
					put(grammarAccess.getQualifiedNameAccess().getGroup_1(), "rule__QualifiedName__Group_1__0");
					put(grammarAccess.getQualifiedNameWithWildcardAccess().getGroup(), "rule__QualifiedNameWithWildcard__Group__0");
					put(grammarAccess.getModelAccess().getNameAssignment_1(), "rule__Model__NameAssignment_1");
					put(grammarAccess.getModelAccess().getImportsAssignment_3(), "rule__Model__ImportsAssignment_3");
					put(grammarAccess.getModelAccess().getElementsAssignment_4(), "rule__Model__ElementsAssignment_4");
					put(grammarAccess.getEntityAccess().getCommentAssignment_0(), "rule__Entity__CommentAssignment_0");
					put(grammarAccess.getEntityAccess().getNameAssignment_2(), "rule__Entity__NameAssignment_2");
					put(grammarAccess.getEntityAccess().getSuperTypeAssignment_3_1(), "rule__Entity__SuperTypeAssignment_3_1");
					put(grammarAccess.getEntityAccess().getAttributesAssignment_5(), "rule__Entity__AttributesAssignment_5");
					put(grammarAccess.getPropertyAccess().getCommentAssignment_0(), "rule__Property__CommentAssignment_0");
					put(grammarAccess.getPropertyAccess().getNameAssignment_2(), "rule__Property__NameAssignment_2");
					put(grammarAccess.getPropertyAccess().getTypeAssignment_4(), "rule__Property__TypeAssignment_4");
					put(grammarAccess.getLinkAccess().getCommentAssignment_0(), "rule__Link__CommentAssignment_0");
					put(grammarAccess.getLinkAccess().getNameAssignment_2(), "rule__Link__NameAssignment_2");
					put(grammarAccess.getLinkAccess().getTypeAssignment_4(), "rule__Link__TypeAssignment_4");
					put(grammarAccess.getLinkAccess().getAnyAssignment_5_0(), "rule__Link__AnyAssignment_5_0");
					put(grammarAccess.getLinkAccess().getOneOrMoreAssignment_5_1(), "rule__Link__OneOrMoreAssignment_5_1");
					put(grammarAccess.getLinkAccess().getZeroOrOneAssignment_5_2(), "rule__Link__ZeroOrOneAssignment_5_2");
					put(grammarAccess.getImportAccess().getImportedNamespaceAssignment_1(), "rule__Import__ImportedNamespaceAssignment_1");
				}
			};
		}
		return nameMappings.get(element);
	}
	
	@Override
	protected Collection<FollowElement> getFollowElements(AbstractInternalContentAssistParser parser) {
		try {
			org.verapdf.ui.contentassist.antlr.internal.InternalModelParser typedParser = (org.verapdf.ui.contentassist.antlr.internal.InternalModelParser) parser;
			typedParser.entryRuleModel();
			return typedParser.getFollowElements();
		} catch(RecognitionException ex) {
			throw new RuntimeException(ex);
		}		
	}
	
	@Override
	protected String[] getInitialHiddenTokens() {
		return new String[] { "RULE_WS", "RULE_ML_COMMENT", "RULE_SL_COMMENT" };
	}
	
	public ModelGrammarAccess getGrammarAccess() {
		return this.grammarAccess;
	}
	
	public void setGrammarAccess(ModelGrammarAccess grammarAccess) {
		this.grammarAccess = grammarAccess;
	}
}
