/**
 * This file is part of VERA PDF UI, a module of the veraPDF project.
 * Copyright (c) 2015, veraPDF Consortium <info@verapdf.org>
 * All rights reserved.
 *
 * VERA PDF UI is free software: you can redistribute it and/or modify
 * it under the terms of either:
 *
 * The GNU General public license GPLv3+.
 * You should have received a copy of the GNU General Public License
 * along with VERA PDF UI as the LICENSE.GPL file in the root of the source
 * tree.  If not, see http://www.gnu.org/licenses/ or
 * https://www.gnu.org/licenses/gpl-3.0.en.html.
 *
 * The Mozilla Public License MPLv2+.
 * You should have received a copy of the Mozilla Public License along with
 * VERA PDF UI as the LICENSE.MPL file in the root of the source tree.
 * If a copy of the MPL was not distributed with this file, you can obtain one at
 * http://mozilla.org/MPL/2.0/.
 */
package org.verapdf.ui.contentassist.antlr.internal; 

import java.io.InputStream;
import org.eclipse.xtext.*;
import org.eclipse.xtext.parser.*;
import org.eclipse.xtext.parser.impl.*;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.parser.antlr.XtextTokenStream;
import org.eclipse.xtext.parser.antlr.XtextTokenStream.HiddenTokens;
import org.eclipse.xtext.ui.editor.contentassist.antlr.internal.AbstractInternalContentAssistParser;
import org.eclipse.xtext.ui.editor.contentassist.antlr.internal.DFA;
import org.verapdf.services.ModelGrammarAccess;



import org.antlr.runtime.*;
import java.util.Stack;
import java.util.List;
import java.util.ArrayList;

@SuppressWarnings("all")
public class InternalModelParser extends AbstractInternalContentAssistParser {
    public static final String[] tokenNames = new String[] {
        "<invalid>", "<EOR>", "<DOWN>", "<UP>", "RULE_ID", "RULE_COMMENT", "RULE_INT", "RULE_STRING", "RULE_ML_COMMENT", "RULE_SL_COMMENT", "RULE_WS", "RULE_ANY_OTHER", "'String'", "'Integer'", "'Decimal'", "'Boolean'", "'Set<String>'", "'List<String>'", "'List<List<String>>'", "'package'", "';'", "'type'", "'{'", "'}'", "'extends'", "'property'", "':'", "'link'", "'import'", "'.'", "'.*'", "'*'", "'+'", "'?'"
    };
    public static final int RULE_STRING=7;
    public static final int RULE_SL_COMMENT=9;
    public static final int T__19=19;
    public static final int T__15=15;
    public static final int T__16=16;
    public static final int T__17=17;
    public static final int T__18=18;
    public static final int T__33=33;
    public static final int T__12=12;
    public static final int T__13=13;
    public static final int T__14=14;
    public static final int EOF=-1;
    public static final int T__30=30;
    public static final int T__31=31;
    public static final int T__32=32;
    public static final int RULE_ID=4;
    public static final int RULE_WS=10;
    public static final int RULE_COMMENT=5;
    public static final int RULE_ANY_OTHER=11;
    public static final int T__26=26;
    public static final int T__27=27;
    public static final int T__28=28;
    public static final int RULE_INT=6;
    public static final int T__29=29;
    public static final int T__22=22;
    public static final int RULE_ML_COMMENT=8;
    public static final int T__23=23;
    public static final int T__24=24;
    public static final int T__25=25;
    public static final int T__20=20;
    public static final int T__21=21;

    // delegates
    // delegators


        public InternalModelParser(TokenStream input) {
            this(input, new RecognizerSharedState());
        }
        public InternalModelParser(TokenStream input, RecognizerSharedState state) {
            super(input, state);
             
        }
        

    public String[] getTokenNames() { return InternalModelParser.tokenNames; }
    public String getGrammarFileName() { return "InternalModel.g"; }


     
     	private ModelGrammarAccess grammarAccess;
     	
        public void setGrammarAccess(ModelGrammarAccess grammarAccess) {
        	this.grammarAccess = grammarAccess;
        }
        
        @Override
        protected Grammar getGrammar() {
        	return grammarAccess.getGrammar();
        }
        
        @Override
        protected String getValueForTokenName(String tokenName) {
        	return tokenName;
        }




    // $ANTLR start "entryRuleModel"
    // InternalModel.g:60:1: entryRuleModel : ruleModel EOF ;
    public final void entryRuleModel() throws RecognitionException {
        try {
            // InternalModel.g:61:1: ( ruleModel EOF )
            // InternalModel.g:62:1: ruleModel EOF
            {
             before(grammarAccess.getModelRule()); 
            pushFollow(FOLLOW_1);
            ruleModel();

            state._fsp--;

             after(grammarAccess.getModelRule()); 
            match(input,EOF,FOLLOW_2); 

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    // $ANTLR end "entryRuleModel"


    // $ANTLR start "ruleModel"
    // InternalModel.g:69:1: ruleModel : ( ( rule__Model__Group__0 ) ) ;
    public final void ruleModel() throws RecognitionException {

        		int stackSize = keepStackSize();
            
        try {
            // InternalModel.g:73:2: ( ( ( rule__Model__Group__0 ) ) )
            // InternalModel.g:74:1: ( ( rule__Model__Group__0 ) )
            {
            // InternalModel.g:74:1: ( ( rule__Model__Group__0 ) )
            // InternalModel.g:75:1: ( rule__Model__Group__0 )
            {
             before(grammarAccess.getModelAccess().getGroup()); 
            // InternalModel.g:76:1: ( rule__Model__Group__0 )
            // InternalModel.g:76:2: rule__Model__Group__0
            {
            pushFollow(FOLLOW_2);
            rule__Model__Group__0();

            state._fsp--;


            }

             after(grammarAccess.getModelAccess().getGroup()); 

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "ruleModel"


    // $ANTLR start "entryRuleEntity"
    // InternalModel.g:88:1: entryRuleEntity : ruleEntity EOF ;
    public final void entryRuleEntity() throws RecognitionException {
        try {
            // InternalModel.g:89:1: ( ruleEntity EOF )
            // InternalModel.g:90:1: ruleEntity EOF
            {
             before(grammarAccess.getEntityRule()); 
            pushFollow(FOLLOW_1);
            ruleEntity();

            state._fsp--;

             after(grammarAccess.getEntityRule()); 
            match(input,EOF,FOLLOW_2); 

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    // $ANTLR end "entryRuleEntity"


    // $ANTLR start "ruleEntity"
    // InternalModel.g:97:1: ruleEntity : ( ( rule__Entity__Group__0 ) ) ;
    public final void ruleEntity() throws RecognitionException {

        		int stackSize = keepStackSize();
            
        try {
            // InternalModel.g:101:2: ( ( ( rule__Entity__Group__0 ) ) )
            // InternalModel.g:102:1: ( ( rule__Entity__Group__0 ) )
            {
            // InternalModel.g:102:1: ( ( rule__Entity__Group__0 ) )
            // InternalModel.g:103:1: ( rule__Entity__Group__0 )
            {
             before(grammarAccess.getEntityAccess().getGroup()); 
            // InternalModel.g:104:1: ( rule__Entity__Group__0 )
            // InternalModel.g:104:2: rule__Entity__Group__0
            {
            pushFollow(FOLLOW_2);
            rule__Entity__Group__0();

            state._fsp--;


            }

             after(grammarAccess.getEntityAccess().getGroup()); 

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "ruleEntity"


    // $ANTLR start "entryRuleAttribute"
    // InternalModel.g:116:1: entryRuleAttribute : ruleAttribute EOF ;
    public final void entryRuleAttribute() throws RecognitionException {
        try {
            // InternalModel.g:117:1: ( ruleAttribute EOF )
            // InternalModel.g:118:1: ruleAttribute EOF
            {
             before(grammarAccess.getAttributeRule()); 
            pushFollow(FOLLOW_1);
            ruleAttribute();

            state._fsp--;

             after(grammarAccess.getAttributeRule()); 
            match(input,EOF,FOLLOW_2); 

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    // $ANTLR end "entryRuleAttribute"


    // $ANTLR start "ruleAttribute"
    // InternalModel.g:125:1: ruleAttribute : ( ( rule__Attribute__Alternatives ) ) ;
    public final void ruleAttribute() throws RecognitionException {

        		int stackSize = keepStackSize();
            
        try {
            // InternalModel.g:129:2: ( ( ( rule__Attribute__Alternatives ) ) )
            // InternalModel.g:130:1: ( ( rule__Attribute__Alternatives ) )
            {
            // InternalModel.g:130:1: ( ( rule__Attribute__Alternatives ) )
            // InternalModel.g:131:1: ( rule__Attribute__Alternatives )
            {
             before(grammarAccess.getAttributeAccess().getAlternatives()); 
            // InternalModel.g:132:1: ( rule__Attribute__Alternatives )
            // InternalModel.g:132:2: rule__Attribute__Alternatives
            {
            pushFollow(FOLLOW_2);
            rule__Attribute__Alternatives();

            state._fsp--;


            }

             after(grammarAccess.getAttributeAccess().getAlternatives()); 

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "ruleAttribute"


    // $ANTLR start "entryRuleProperty"
    // InternalModel.g:144:1: entryRuleProperty : ruleProperty EOF ;
    public final void entryRuleProperty() throws RecognitionException {
        try {
            // InternalModel.g:145:1: ( ruleProperty EOF )
            // InternalModel.g:146:1: ruleProperty EOF
            {
             before(grammarAccess.getPropertyRule()); 
            pushFollow(FOLLOW_1);
            ruleProperty();

            state._fsp--;

             after(grammarAccess.getPropertyRule()); 
            match(input,EOF,FOLLOW_2); 

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    // $ANTLR end "entryRuleProperty"


    // $ANTLR start "ruleProperty"
    // InternalModel.g:153:1: ruleProperty : ( ( rule__Property__Group__0 ) ) ;
    public final void ruleProperty() throws RecognitionException {

        		int stackSize = keepStackSize();
            
        try {
            // InternalModel.g:157:2: ( ( ( rule__Property__Group__0 ) ) )
            // InternalModel.g:158:1: ( ( rule__Property__Group__0 ) )
            {
            // InternalModel.g:158:1: ( ( rule__Property__Group__0 ) )
            // InternalModel.g:159:1: ( rule__Property__Group__0 )
            {
             before(grammarAccess.getPropertyAccess().getGroup()); 
            // InternalModel.g:160:1: ( rule__Property__Group__0 )
            // InternalModel.g:160:2: rule__Property__Group__0
            {
            pushFollow(FOLLOW_2);
            rule__Property__Group__0();

            state._fsp--;


            }

             after(grammarAccess.getPropertyAccess().getGroup()); 

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "ruleProperty"


    // $ANTLR start "entryRuleLink"
    // InternalModel.g:172:1: entryRuleLink : ruleLink EOF ;
    public final void entryRuleLink() throws RecognitionException {
        try {
            // InternalModel.g:173:1: ( ruleLink EOF )
            // InternalModel.g:174:1: ruleLink EOF
            {
             before(grammarAccess.getLinkRule()); 
            pushFollow(FOLLOW_1);
            ruleLink();

            state._fsp--;

             after(grammarAccess.getLinkRule()); 
            match(input,EOF,FOLLOW_2); 

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    // $ANTLR end "entryRuleLink"


    // $ANTLR start "ruleLink"
    // InternalModel.g:181:1: ruleLink : ( ( rule__Link__Group__0 ) ) ;
    public final void ruleLink() throws RecognitionException {

        		int stackSize = keepStackSize();
            
        try {
            // InternalModel.g:185:2: ( ( ( rule__Link__Group__0 ) ) )
            // InternalModel.g:186:1: ( ( rule__Link__Group__0 ) )
            {
            // InternalModel.g:186:1: ( ( rule__Link__Group__0 ) )
            // InternalModel.g:187:1: ( rule__Link__Group__0 )
            {
             before(grammarAccess.getLinkAccess().getGroup()); 
            // InternalModel.g:188:1: ( rule__Link__Group__0 )
            // InternalModel.g:188:2: rule__Link__Group__0
            {
            pushFollow(FOLLOW_2);
            rule__Link__Group__0();

            state._fsp--;


            }

             after(grammarAccess.getLinkAccess().getGroup()); 

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "ruleLink"


    // $ANTLR start "entryRuleImport"
    // InternalModel.g:200:1: entryRuleImport : ruleImport EOF ;
    public final void entryRuleImport() throws RecognitionException {
        try {
            // InternalModel.g:201:1: ( ruleImport EOF )
            // InternalModel.g:202:1: ruleImport EOF
            {
             before(grammarAccess.getImportRule()); 
            pushFollow(FOLLOW_1);
            ruleImport();

            state._fsp--;

             after(grammarAccess.getImportRule()); 
            match(input,EOF,FOLLOW_2); 

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    // $ANTLR end "entryRuleImport"


    // $ANTLR start "ruleImport"
    // InternalModel.g:209:1: ruleImport : ( ( rule__Import__Group__0 ) ) ;
    public final void ruleImport() throws RecognitionException {

        		int stackSize = keepStackSize();
            
        try {
            // InternalModel.g:213:2: ( ( ( rule__Import__Group__0 ) ) )
            // InternalModel.g:214:1: ( ( rule__Import__Group__0 ) )
            {
            // InternalModel.g:214:1: ( ( rule__Import__Group__0 ) )
            // InternalModel.g:215:1: ( rule__Import__Group__0 )
            {
             before(grammarAccess.getImportAccess().getGroup()); 
            // InternalModel.g:216:1: ( rule__Import__Group__0 )
            // InternalModel.g:216:2: rule__Import__Group__0
            {
            pushFollow(FOLLOW_2);
            rule__Import__Group__0();

            state._fsp--;


            }

             after(grammarAccess.getImportAccess().getGroup()); 

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "ruleImport"


    // $ANTLR start "entryRuleQualifiedName"
    // InternalModel.g:228:1: entryRuleQualifiedName : ruleQualifiedName EOF ;
    public final void entryRuleQualifiedName() throws RecognitionException {
        try {
            // InternalModel.g:229:1: ( ruleQualifiedName EOF )
            // InternalModel.g:230:1: ruleQualifiedName EOF
            {
             before(grammarAccess.getQualifiedNameRule()); 
            pushFollow(FOLLOW_1);
            ruleQualifiedName();

            state._fsp--;

             after(grammarAccess.getQualifiedNameRule()); 
            match(input,EOF,FOLLOW_2); 

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    // $ANTLR end "entryRuleQualifiedName"


    // $ANTLR start "ruleQualifiedName"
    // InternalModel.g:237:1: ruleQualifiedName : ( ( rule__QualifiedName__Group__0 ) ) ;
    public final void ruleQualifiedName() throws RecognitionException {

        		int stackSize = keepStackSize();
            
        try {
            // InternalModel.g:241:2: ( ( ( rule__QualifiedName__Group__0 ) ) )
            // InternalModel.g:242:1: ( ( rule__QualifiedName__Group__0 ) )
            {
            // InternalModel.g:242:1: ( ( rule__QualifiedName__Group__0 ) )
            // InternalModel.g:243:1: ( rule__QualifiedName__Group__0 )
            {
             before(grammarAccess.getQualifiedNameAccess().getGroup()); 
            // InternalModel.g:244:1: ( rule__QualifiedName__Group__0 )
            // InternalModel.g:244:2: rule__QualifiedName__Group__0
            {
            pushFollow(FOLLOW_2);
            rule__QualifiedName__Group__0();

            state._fsp--;


            }

             after(grammarAccess.getQualifiedNameAccess().getGroup()); 

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "ruleQualifiedName"


    // $ANTLR start "entryRuleQualifiedNameWithWildcard"
    // InternalModel.g:256:1: entryRuleQualifiedNameWithWildcard : ruleQualifiedNameWithWildcard EOF ;
    public final void entryRuleQualifiedNameWithWildcard() throws RecognitionException {
        try {
            // InternalModel.g:257:1: ( ruleQualifiedNameWithWildcard EOF )
            // InternalModel.g:258:1: ruleQualifiedNameWithWildcard EOF
            {
             before(grammarAccess.getQualifiedNameWithWildcardRule()); 
            pushFollow(FOLLOW_1);
            ruleQualifiedNameWithWildcard();

            state._fsp--;

             after(grammarAccess.getQualifiedNameWithWildcardRule()); 
            match(input,EOF,FOLLOW_2); 

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    // $ANTLR end "entryRuleQualifiedNameWithWildcard"


    // $ANTLR start "ruleQualifiedNameWithWildcard"
    // InternalModel.g:265:1: ruleQualifiedNameWithWildcard : ( ( rule__QualifiedNameWithWildcard__Group__0 ) ) ;
    public final void ruleQualifiedNameWithWildcard() throws RecognitionException {

        		int stackSize = keepStackSize();
            
        try {
            // InternalModel.g:269:2: ( ( ( rule__QualifiedNameWithWildcard__Group__0 ) ) )
            // InternalModel.g:270:1: ( ( rule__QualifiedNameWithWildcard__Group__0 ) )
            {
            // InternalModel.g:270:1: ( ( rule__QualifiedNameWithWildcard__Group__0 ) )
            // InternalModel.g:271:1: ( rule__QualifiedNameWithWildcard__Group__0 )
            {
             before(grammarAccess.getQualifiedNameWithWildcardAccess().getGroup()); 
            // InternalModel.g:272:1: ( rule__QualifiedNameWithWildcard__Group__0 )
            // InternalModel.g:272:2: rule__QualifiedNameWithWildcard__Group__0
            {
            pushFollow(FOLLOW_2);
            rule__QualifiedNameWithWildcard__Group__0();

            state._fsp--;


            }

             after(grammarAccess.getQualifiedNameWithWildcardAccess().getGroup()); 

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "ruleQualifiedNameWithWildcard"


    // $ANTLR start "rule__Attribute__Alternatives"
    // InternalModel.g:284:1: rule__Attribute__Alternatives : ( ( ruleProperty ) | ( ruleLink ) );
    public final void rule__Attribute__Alternatives() throws RecognitionException {

        		int stackSize = keepStackSize();
            
        try {
            // InternalModel.g:288:1: ( ( ruleProperty ) | ( ruleLink ) )
            int alt1=2;
            alt1 = dfa1.predict(input);
            switch (alt1) {
                case 1 :
                    // InternalModel.g:289:1: ( ruleProperty )
                    {
                    // InternalModel.g:289:1: ( ruleProperty )
                    // InternalModel.g:290:1: ruleProperty
                    {
                     before(grammarAccess.getAttributeAccess().getPropertyParserRuleCall_0()); 
                    pushFollow(FOLLOW_2);
                    ruleProperty();

                    state._fsp--;

                     after(grammarAccess.getAttributeAccess().getPropertyParserRuleCall_0()); 

                    }


                    }
                    break;
                case 2 :
                    // InternalModel.g:295:6: ( ruleLink )
                    {
                    // InternalModel.g:295:6: ( ruleLink )
                    // InternalModel.g:296:1: ruleLink
                    {
                     before(grammarAccess.getAttributeAccess().getLinkParserRuleCall_1()); 
                    pushFollow(FOLLOW_2);
                    ruleLink();

                    state._fsp--;

                     after(grammarAccess.getAttributeAccess().getLinkParserRuleCall_1()); 

                    }


                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__Attribute__Alternatives"


    // $ANTLR start "rule__Property__TypeAlternatives_4_0"
    // InternalModel.g:306:1: rule__Property__TypeAlternatives_4_0 : ( ( 'String' ) | ( 'Integer' ) | ( 'Decimal' ) | ( 'Boolean' ) | ( 'Set<String>' ) | ( 'List<String>' ) | ( 'List<List<String>>' ) );
    public final void rule__Property__TypeAlternatives_4_0() throws RecognitionException {

        		int stackSize = keepStackSize();
            
        try {
            // InternalModel.g:310:1: ( ( 'String' ) | ( 'Integer' ) | ( 'Decimal' ) | ( 'Boolean' ) | ( 'Set<String>' ) | ( 'List<String>' ) | ( 'List<List<String>>' ) )
            int alt2=7;
            switch ( input.LA(1) ) {
            case 12:
                {
                alt2=1;
                }
                break;
            case 13:
                {
                alt2=2;
                }
                break;
            case 14:
                {
                alt2=3;
                }
                break;
            case 15:
                {
                alt2=4;
                }
                break;
            case 16:
                {
                alt2=5;
                }
                break;
            case 17:
                {
                alt2=6;
                }
                break;
            case 18:
                {
                alt2=7;
                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 2, 0, input);

                throw nvae;
            }

            switch (alt2) {
                case 1 :
                    // InternalModel.g:311:1: ( 'String' )
                    {
                    // InternalModel.g:311:1: ( 'String' )
                    // InternalModel.g:312:1: 'String'
                    {
                     before(grammarAccess.getPropertyAccess().getTypeStringKeyword_4_0_0()); 
                    match(input,12,FOLLOW_2); 
                     after(grammarAccess.getPropertyAccess().getTypeStringKeyword_4_0_0()); 

                    }


                    }
                    break;
                case 2 :
                    // InternalModel.g:319:6: ( 'Integer' )
                    {
                    // InternalModel.g:319:6: ( 'Integer' )
                    // InternalModel.g:320:1: 'Integer'
                    {
                     before(grammarAccess.getPropertyAccess().getTypeIntegerKeyword_4_0_1()); 
                    match(input,13,FOLLOW_2); 
                     after(grammarAccess.getPropertyAccess().getTypeIntegerKeyword_4_0_1()); 

                    }


                    }
                    break;
                case 3 :
                    // InternalModel.g:327:6: ( 'Decimal' )
                    {
                    // InternalModel.g:327:6: ( 'Decimal' )
                    // InternalModel.g:328:1: 'Decimal'
                    {
                     before(grammarAccess.getPropertyAccess().getTypeDecimalKeyword_4_0_2()); 
                    match(input,14,FOLLOW_2); 
                     after(grammarAccess.getPropertyAccess().getTypeDecimalKeyword_4_0_2()); 

                    }


                    }
                    break;
                case 4 :
                    // InternalModel.g:335:6: ( 'Boolean' )
                    {
                    // InternalModel.g:335:6: ( 'Boolean' )
                    // InternalModel.g:336:1: 'Boolean'
                    {
                     before(grammarAccess.getPropertyAccess().getTypeBooleanKeyword_4_0_3()); 
                    match(input,15,FOLLOW_2); 
                     after(grammarAccess.getPropertyAccess().getTypeBooleanKeyword_4_0_3()); 

                    }


                    }
                    break;
                case 5 :
                    // InternalModel.g:343:6: ( 'Set<String>' )
                    {
                    // InternalModel.g:343:6: ( 'Set<String>' )
                    // InternalModel.g:344:1: 'Set<String>'
                    {
                     before(grammarAccess.getPropertyAccess().getTypeSetStringKeyword_4_0_4()); 
                    match(input,16,FOLLOW_2); 
                     after(grammarAccess.getPropertyAccess().getTypeSetStringKeyword_4_0_4()); 

                    }


                    }
                    break;
                case 6 :
                    // InternalModel.g:351:6: ( 'List<String>' )
                    {
                    // InternalModel.g:351:6: ( 'List<String>' )
                    // InternalModel.g:352:1: 'List<String>'
                    {
                     before(grammarAccess.getPropertyAccess().getTypeListStringKeyword_4_0_5()); 
                    match(input,17,FOLLOW_2); 
                     after(grammarAccess.getPropertyAccess().getTypeListStringKeyword_4_0_5()); 

                    }


                    }
                    break;
                case 7 :
                    // InternalModel.g:359:6: ( 'List<List<String>>' )
                    {
                    // InternalModel.g:359:6: ( 'List<List<String>>' )
                    // InternalModel.g:360:1: 'List<List<String>>'
                    {
                     before(grammarAccess.getPropertyAccess().getTypeListListStringKeyword_4_0_6()); 
                    match(input,18,FOLLOW_2); 
                     after(grammarAccess.getPropertyAccess().getTypeListListStringKeyword_4_0_6()); 

                    }


                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__Property__TypeAlternatives_4_0"


    // $ANTLR start "rule__Link__Alternatives_5"
    // InternalModel.g:372:1: rule__Link__Alternatives_5 : ( ( ( rule__Link__AnyAssignment_5_0 ) ) | ( ( rule__Link__OneOrMoreAssignment_5_1 ) ) | ( ( rule__Link__ZeroOrOneAssignment_5_2 ) ) );
    public final void rule__Link__Alternatives_5() throws RecognitionException {

        		int stackSize = keepStackSize();
            
        try {
            // InternalModel.g:376:1: ( ( ( rule__Link__AnyAssignment_5_0 ) ) | ( ( rule__Link__OneOrMoreAssignment_5_1 ) ) | ( ( rule__Link__ZeroOrOneAssignment_5_2 ) ) )
            int alt3=3;
            switch ( input.LA(1) ) {
            case 31:
                {
                alt3=1;
                }
                break;
            case 32:
                {
                alt3=2;
                }
                break;
            case 33:
                {
                alt3=3;
                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 3, 0, input);

                throw nvae;
            }

            switch (alt3) {
                case 1 :
                    // InternalModel.g:377:1: ( ( rule__Link__AnyAssignment_5_0 ) )
                    {
                    // InternalModel.g:377:1: ( ( rule__Link__AnyAssignment_5_0 ) )
                    // InternalModel.g:378:1: ( rule__Link__AnyAssignment_5_0 )
                    {
                     before(grammarAccess.getLinkAccess().getAnyAssignment_5_0()); 
                    // InternalModel.g:379:1: ( rule__Link__AnyAssignment_5_0 )
                    // InternalModel.g:379:2: rule__Link__AnyAssignment_5_0
                    {
                    pushFollow(FOLLOW_2);
                    rule__Link__AnyAssignment_5_0();

                    state._fsp--;


                    }

                     after(grammarAccess.getLinkAccess().getAnyAssignment_5_0()); 

                    }


                    }
                    break;
                case 2 :
                    // InternalModel.g:383:6: ( ( rule__Link__OneOrMoreAssignment_5_1 ) )
                    {
                    // InternalModel.g:383:6: ( ( rule__Link__OneOrMoreAssignment_5_1 ) )
                    // InternalModel.g:384:1: ( rule__Link__OneOrMoreAssignment_5_1 )
                    {
                     before(grammarAccess.getLinkAccess().getOneOrMoreAssignment_5_1()); 
                    // InternalModel.g:385:1: ( rule__Link__OneOrMoreAssignment_5_1 )
                    // InternalModel.g:385:2: rule__Link__OneOrMoreAssignment_5_1
                    {
                    pushFollow(FOLLOW_2);
                    rule__Link__OneOrMoreAssignment_5_1();

                    state._fsp--;


                    }

                     after(grammarAccess.getLinkAccess().getOneOrMoreAssignment_5_1()); 

                    }


                    }
                    break;
                case 3 :
                    // InternalModel.g:389:6: ( ( rule__Link__ZeroOrOneAssignment_5_2 ) )
                    {
                    // InternalModel.g:389:6: ( ( rule__Link__ZeroOrOneAssignment_5_2 ) )
                    // InternalModel.g:390:1: ( rule__Link__ZeroOrOneAssignment_5_2 )
                    {
                     before(grammarAccess.getLinkAccess().getZeroOrOneAssignment_5_2()); 
                    // InternalModel.g:391:1: ( rule__Link__ZeroOrOneAssignment_5_2 )
                    // InternalModel.g:391:2: rule__Link__ZeroOrOneAssignment_5_2
                    {
                    pushFollow(FOLLOW_2);
                    rule__Link__ZeroOrOneAssignment_5_2();

                    state._fsp--;


                    }

                     after(grammarAccess.getLinkAccess().getZeroOrOneAssignment_5_2()); 

                    }


                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__Link__Alternatives_5"


    // $ANTLR start "rule__Model__Group__0"
    // InternalModel.g:402:1: rule__Model__Group__0 : rule__Model__Group__0__Impl rule__Model__Group__1 ;
    public final void rule__Model__Group__0() throws RecognitionException {

        		int stackSize = keepStackSize();
            
        try {
            // InternalModel.g:406:1: ( rule__Model__Group__0__Impl rule__Model__Group__1 )
            // InternalModel.g:407:2: rule__Model__Group__0__Impl rule__Model__Group__1
            {
            pushFollow(FOLLOW_3);
            rule__Model__Group__0__Impl();

            state._fsp--;

            pushFollow(FOLLOW_2);
            rule__Model__Group__1();

            state._fsp--;


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__Model__Group__0"


    // $ANTLR start "rule__Model__Group__0__Impl"
    // InternalModel.g:414:1: rule__Model__Group__0__Impl : ( 'package' ) ;
    public final void rule__Model__Group__0__Impl() throws RecognitionException {

        		int stackSize = keepStackSize();
            
        try {
            // InternalModel.g:418:1: ( ( 'package' ) )
            // InternalModel.g:419:1: ( 'package' )
            {
            // InternalModel.g:419:1: ( 'package' )
            // InternalModel.g:420:1: 'package'
            {
             before(grammarAccess.getModelAccess().getPackageKeyword_0()); 
            match(input,19,FOLLOW_2); 
             after(grammarAccess.getModelAccess().getPackageKeyword_0()); 

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__Model__Group__0__Impl"


    // $ANTLR start "rule__Model__Group__1"
    // InternalModel.g:433:1: rule__Model__Group__1 : rule__Model__Group__1__Impl rule__Model__Group__2 ;
    public final void rule__Model__Group__1() throws RecognitionException {

        		int stackSize = keepStackSize();
            
        try {
            // InternalModel.g:437:1: ( rule__Model__Group__1__Impl rule__Model__Group__2 )
            // InternalModel.g:438:2: rule__Model__Group__1__Impl rule__Model__Group__2
            {
            pushFollow(FOLLOW_4);
            rule__Model__Group__1__Impl();

            state._fsp--;

            pushFollow(FOLLOW_2);
            rule__Model__Group__2();

            state._fsp--;


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__Model__Group__1"


    // $ANTLR start "rule__Model__Group__1__Impl"
    // InternalModel.g:445:1: rule__Model__Group__1__Impl : ( ( rule__Model__NameAssignment_1 ) ) ;
    public final void rule__Model__Group__1__Impl() throws RecognitionException {

        		int stackSize = keepStackSize();
            
        try {
            // InternalModel.g:449:1: ( ( ( rule__Model__NameAssignment_1 ) ) )
            // InternalModel.g:450:1: ( ( rule__Model__NameAssignment_1 ) )
            {
            // InternalModel.g:450:1: ( ( rule__Model__NameAssignment_1 ) )
            // InternalModel.g:451:1: ( rule__Model__NameAssignment_1 )
            {
             before(grammarAccess.getModelAccess().getNameAssignment_1()); 
            // InternalModel.g:452:1: ( rule__Model__NameAssignment_1 )
            // InternalModel.g:452:2: rule__Model__NameAssignment_1
            {
            pushFollow(FOLLOW_2);
            rule__Model__NameAssignment_1();

            state._fsp--;


            }

             after(grammarAccess.getModelAccess().getNameAssignment_1()); 

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__Model__Group__1__Impl"


    // $ANTLR start "rule__Model__Group__2"
    // InternalModel.g:462:1: rule__Model__Group__2 : rule__Model__Group__2__Impl rule__Model__Group__3 ;
    public final void rule__Model__Group__2() throws RecognitionException {

        		int stackSize = keepStackSize();
            
        try {
            // InternalModel.g:466:1: ( rule__Model__Group__2__Impl rule__Model__Group__3 )
            // InternalModel.g:467:2: rule__Model__Group__2__Impl rule__Model__Group__3
            {
            pushFollow(FOLLOW_5);
            rule__Model__Group__2__Impl();

            state._fsp--;

            pushFollow(FOLLOW_2);
            rule__Model__Group__3();

            state._fsp--;


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__Model__Group__2"


    // $ANTLR start "rule__Model__Group__2__Impl"
    // InternalModel.g:474:1: rule__Model__Group__2__Impl : ( ';' ) ;
    public final void rule__Model__Group__2__Impl() throws RecognitionException {

        		int stackSize = keepStackSize();
            
        try {
            // InternalModel.g:478:1: ( ( ';' ) )
            // InternalModel.g:479:1: ( ';' )
            {
            // InternalModel.g:479:1: ( ';' )
            // InternalModel.g:480:1: ';'
            {
             before(grammarAccess.getModelAccess().getSemicolonKeyword_2()); 
            match(input,20,FOLLOW_2); 
             after(grammarAccess.getModelAccess().getSemicolonKeyword_2()); 

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__Model__Group__2__Impl"


    // $ANTLR start "rule__Model__Group__3"
    // InternalModel.g:493:1: rule__Model__Group__3 : rule__Model__Group__3__Impl rule__Model__Group__4 ;
    public final void rule__Model__Group__3() throws RecognitionException {

        		int stackSize = keepStackSize();
            
        try {
            // InternalModel.g:497:1: ( rule__Model__Group__3__Impl rule__Model__Group__4 )
            // InternalModel.g:498:2: rule__Model__Group__3__Impl rule__Model__Group__4
            {
            pushFollow(FOLLOW_5);
            rule__Model__Group__3__Impl();

            state._fsp--;

            pushFollow(FOLLOW_2);
            rule__Model__Group__4();

            state._fsp--;


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__Model__Group__3"


    // $ANTLR start "rule__Model__Group__3__Impl"
    // InternalModel.g:505:1: rule__Model__Group__3__Impl : ( ( rule__Model__ImportsAssignment_3 )* ) ;
    public final void rule__Model__Group__3__Impl() throws RecognitionException {

        		int stackSize = keepStackSize();
            
        try {
            // InternalModel.g:509:1: ( ( ( rule__Model__ImportsAssignment_3 )* ) )
            // InternalModel.g:510:1: ( ( rule__Model__ImportsAssignment_3 )* )
            {
            // InternalModel.g:510:1: ( ( rule__Model__ImportsAssignment_3 )* )
            // InternalModel.g:511:1: ( rule__Model__ImportsAssignment_3 )*
            {
             before(grammarAccess.getModelAccess().getImportsAssignment_3()); 
            // InternalModel.g:512:1: ( rule__Model__ImportsAssignment_3 )*
            loop4:
            do {
                int alt4=2;
                int LA4_0 = input.LA(1);

                if ( (LA4_0==28) ) {
                    alt4=1;
                }


                switch (alt4) {
            	case 1 :
            	    // InternalModel.g:512:2: rule__Model__ImportsAssignment_3
            	    {
            	    pushFollow(FOLLOW_6);
            	    rule__Model__ImportsAssignment_3();

            	    state._fsp--;


            	    }
            	    break;

            	default :
            	    break loop4;
                }
            } while (true);

             after(grammarAccess.getModelAccess().getImportsAssignment_3()); 

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__Model__Group__3__Impl"


    // $ANTLR start "rule__Model__Group__4"
    // InternalModel.g:522:1: rule__Model__Group__4 : rule__Model__Group__4__Impl ;
    public final void rule__Model__Group__4() throws RecognitionException {

        		int stackSize = keepStackSize();
            
        try {
            // InternalModel.g:526:1: ( rule__Model__Group__4__Impl )
            // InternalModel.g:527:2: rule__Model__Group__4__Impl
            {
            pushFollow(FOLLOW_2);
            rule__Model__Group__4__Impl();

            state._fsp--;


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__Model__Group__4"


    // $ANTLR start "rule__Model__Group__4__Impl"
    // InternalModel.g:533:1: rule__Model__Group__4__Impl : ( ( rule__Model__ElementsAssignment_4 )* ) ;
    public final void rule__Model__Group__4__Impl() throws RecognitionException {

        		int stackSize = keepStackSize();
            
        try {
            // InternalModel.g:537:1: ( ( ( rule__Model__ElementsAssignment_4 )* ) )
            // InternalModel.g:538:1: ( ( rule__Model__ElementsAssignment_4 )* )
            {
            // InternalModel.g:538:1: ( ( rule__Model__ElementsAssignment_4 )* )
            // InternalModel.g:539:1: ( rule__Model__ElementsAssignment_4 )*
            {
             before(grammarAccess.getModelAccess().getElementsAssignment_4()); 
            // InternalModel.g:540:1: ( rule__Model__ElementsAssignment_4 )*
            loop5:
            do {
                int alt5=2;
                int LA5_0 = input.LA(1);

                if ( (LA5_0==RULE_COMMENT||LA5_0==21) ) {
                    alt5=1;
                }


                switch (alt5) {
            	case 1 :
            	    // InternalModel.g:540:2: rule__Model__ElementsAssignment_4
            	    {
            	    pushFollow(FOLLOW_7);
            	    rule__Model__ElementsAssignment_4();

            	    state._fsp--;


            	    }
            	    break;

            	default :
            	    break loop5;
                }
            } while (true);

             after(grammarAccess.getModelAccess().getElementsAssignment_4()); 

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__Model__Group__4__Impl"


    // $ANTLR start "rule__Entity__Group__0"
    // InternalModel.g:560:1: rule__Entity__Group__0 : rule__Entity__Group__0__Impl rule__Entity__Group__1 ;
    public final void rule__Entity__Group__0() throws RecognitionException {

        		int stackSize = keepStackSize();
            
        try {
            // InternalModel.g:564:1: ( rule__Entity__Group__0__Impl rule__Entity__Group__1 )
            // InternalModel.g:565:2: rule__Entity__Group__0__Impl rule__Entity__Group__1
            {
            pushFollow(FOLLOW_8);
            rule__Entity__Group__0__Impl();

            state._fsp--;

            pushFollow(FOLLOW_2);
            rule__Entity__Group__1();

            state._fsp--;


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__Entity__Group__0"


    // $ANTLR start "rule__Entity__Group__0__Impl"
    // InternalModel.g:572:1: rule__Entity__Group__0__Impl : ( ( rule__Entity__CommentAssignment_0 )* ) ;
    public final void rule__Entity__Group__0__Impl() throws RecognitionException {

        		int stackSize = keepStackSize();
            
        try {
            // InternalModel.g:576:1: ( ( ( rule__Entity__CommentAssignment_0 )* ) )
            // InternalModel.g:577:1: ( ( rule__Entity__CommentAssignment_0 )* )
            {
            // InternalModel.g:577:1: ( ( rule__Entity__CommentAssignment_0 )* )
            // InternalModel.g:578:1: ( rule__Entity__CommentAssignment_0 )*
            {
             before(grammarAccess.getEntityAccess().getCommentAssignment_0()); 
            // InternalModel.g:579:1: ( rule__Entity__CommentAssignment_0 )*
            loop6:
            do {
                int alt6=2;
                int LA6_0 = input.LA(1);

                if ( (LA6_0==RULE_COMMENT) ) {
                    alt6=1;
                }


                switch (alt6) {
            	case 1 :
            	    // InternalModel.g:579:2: rule__Entity__CommentAssignment_0
            	    {
            	    pushFollow(FOLLOW_9);
            	    rule__Entity__CommentAssignment_0();

            	    state._fsp--;


            	    }
            	    break;

            	default :
            	    break loop6;
                }
            } while (true);

             after(grammarAccess.getEntityAccess().getCommentAssignment_0()); 

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__Entity__Group__0__Impl"


    // $ANTLR start "rule__Entity__Group__1"
    // InternalModel.g:589:1: rule__Entity__Group__1 : rule__Entity__Group__1__Impl rule__Entity__Group__2 ;
    public final void rule__Entity__Group__1() throws RecognitionException {

        		int stackSize = keepStackSize();
            
        try {
            // InternalModel.g:593:1: ( rule__Entity__Group__1__Impl rule__Entity__Group__2 )
            // InternalModel.g:594:2: rule__Entity__Group__1__Impl rule__Entity__Group__2
            {
            pushFollow(FOLLOW_3);
            rule__Entity__Group__1__Impl();

            state._fsp--;

            pushFollow(FOLLOW_2);
            rule__Entity__Group__2();

            state._fsp--;


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__Entity__Group__1"


    // $ANTLR start "rule__Entity__Group__1__Impl"
    // InternalModel.g:601:1: rule__Entity__Group__1__Impl : ( 'type' ) ;
    public final void rule__Entity__Group__1__Impl() throws RecognitionException {

        		int stackSize = keepStackSize();
            
        try {
            // InternalModel.g:605:1: ( ( 'type' ) )
            // InternalModel.g:606:1: ( 'type' )
            {
            // InternalModel.g:606:1: ( 'type' )
            // InternalModel.g:607:1: 'type'
            {
             before(grammarAccess.getEntityAccess().getTypeKeyword_1()); 
            match(input,21,FOLLOW_2); 
             after(grammarAccess.getEntityAccess().getTypeKeyword_1()); 

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__Entity__Group__1__Impl"


    // $ANTLR start "rule__Entity__Group__2"
    // InternalModel.g:620:1: rule__Entity__Group__2 : rule__Entity__Group__2__Impl rule__Entity__Group__3 ;
    public final void rule__Entity__Group__2() throws RecognitionException {

        		int stackSize = keepStackSize();
            
        try {
            // InternalModel.g:624:1: ( rule__Entity__Group__2__Impl rule__Entity__Group__3 )
            // InternalModel.g:625:2: rule__Entity__Group__2__Impl rule__Entity__Group__3
            {
            pushFollow(FOLLOW_10);
            rule__Entity__Group__2__Impl();

            state._fsp--;

            pushFollow(FOLLOW_2);
            rule__Entity__Group__3();

            state._fsp--;


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__Entity__Group__2"


    // $ANTLR start "rule__Entity__Group__2__Impl"
    // InternalModel.g:632:1: rule__Entity__Group__2__Impl : ( ( rule__Entity__NameAssignment_2 ) ) ;
    public final void rule__Entity__Group__2__Impl() throws RecognitionException {

        		int stackSize = keepStackSize();
            
        try {
            // InternalModel.g:636:1: ( ( ( rule__Entity__NameAssignment_2 ) ) )
            // InternalModel.g:637:1: ( ( rule__Entity__NameAssignment_2 ) )
            {
            // InternalModel.g:637:1: ( ( rule__Entity__NameAssignment_2 ) )
            // InternalModel.g:638:1: ( rule__Entity__NameAssignment_2 )
            {
             before(grammarAccess.getEntityAccess().getNameAssignment_2()); 
            // InternalModel.g:639:1: ( rule__Entity__NameAssignment_2 )
            // InternalModel.g:639:2: rule__Entity__NameAssignment_2
            {
            pushFollow(FOLLOW_2);
            rule__Entity__NameAssignment_2();

            state._fsp--;


            }

             after(grammarAccess.getEntityAccess().getNameAssignment_2()); 

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__Entity__Group__2__Impl"


    // $ANTLR start "rule__Entity__Group__3"
    // InternalModel.g:649:1: rule__Entity__Group__3 : rule__Entity__Group__3__Impl rule__Entity__Group__4 ;
    public final void rule__Entity__Group__3() throws RecognitionException {

        		int stackSize = keepStackSize();
            
        try {
            // InternalModel.g:653:1: ( rule__Entity__Group__3__Impl rule__Entity__Group__4 )
            // InternalModel.g:654:2: rule__Entity__Group__3__Impl rule__Entity__Group__4
            {
            pushFollow(FOLLOW_10);
            rule__Entity__Group__3__Impl();

            state._fsp--;

            pushFollow(FOLLOW_2);
            rule__Entity__Group__4();

            state._fsp--;


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__Entity__Group__3"


    // $ANTLR start "rule__Entity__Group__3__Impl"
    // InternalModel.g:661:1: rule__Entity__Group__3__Impl : ( ( rule__Entity__Group_3__0 )? ) ;
    public final void rule__Entity__Group__3__Impl() throws RecognitionException {

        		int stackSize = keepStackSize();
            
        try {
            // InternalModel.g:665:1: ( ( ( rule__Entity__Group_3__0 )? ) )
            // InternalModel.g:666:1: ( ( rule__Entity__Group_3__0 )? )
            {
            // InternalModel.g:666:1: ( ( rule__Entity__Group_3__0 )? )
            // InternalModel.g:667:1: ( rule__Entity__Group_3__0 )?
            {
             before(grammarAccess.getEntityAccess().getGroup_3()); 
            // InternalModel.g:668:1: ( rule__Entity__Group_3__0 )?
            int alt7=2;
            int LA7_0 = input.LA(1);

            if ( (LA7_0==24) ) {
                alt7=1;
            }
            switch (alt7) {
                case 1 :
                    // InternalModel.g:668:2: rule__Entity__Group_3__0
                    {
                    pushFollow(FOLLOW_2);
                    rule__Entity__Group_3__0();

                    state._fsp--;


                    }
                    break;

            }

             after(grammarAccess.getEntityAccess().getGroup_3()); 

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__Entity__Group__3__Impl"


    // $ANTLR start "rule__Entity__Group__4"
    // InternalModel.g:678:1: rule__Entity__Group__4 : rule__Entity__Group__4__Impl rule__Entity__Group__5 ;
    public final void rule__Entity__Group__4() throws RecognitionException {

        		int stackSize = keepStackSize();
            
        try {
            // InternalModel.g:682:1: ( rule__Entity__Group__4__Impl rule__Entity__Group__5 )
            // InternalModel.g:683:2: rule__Entity__Group__4__Impl rule__Entity__Group__5
            {
            pushFollow(FOLLOW_11);
            rule__Entity__Group__4__Impl();

            state._fsp--;

            pushFollow(FOLLOW_2);
            rule__Entity__Group__5();

            state._fsp--;


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__Entity__Group__4"


    // $ANTLR start "rule__Entity__Group__4__Impl"
    // InternalModel.g:690:1: rule__Entity__Group__4__Impl : ( '{' ) ;
    public final void rule__Entity__Group__4__Impl() throws RecognitionException {

        		int stackSize = keepStackSize();
            
        try {
            // InternalModel.g:694:1: ( ( '{' ) )
            // InternalModel.g:695:1: ( '{' )
            {
            // InternalModel.g:695:1: ( '{' )
            // InternalModel.g:696:1: '{'
            {
             before(grammarAccess.getEntityAccess().getLeftCurlyBracketKeyword_4()); 
            match(input,22,FOLLOW_2); 
             after(grammarAccess.getEntityAccess().getLeftCurlyBracketKeyword_4()); 

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__Entity__Group__4__Impl"


    // $ANTLR start "rule__Entity__Group__5"
    // InternalModel.g:709:1: rule__Entity__Group__5 : rule__Entity__Group__5__Impl rule__Entity__Group__6 ;
    public final void rule__Entity__Group__5() throws RecognitionException {

        		int stackSize = keepStackSize();
            
        try {
            // InternalModel.g:713:1: ( rule__Entity__Group__5__Impl rule__Entity__Group__6 )
            // InternalModel.g:714:2: rule__Entity__Group__5__Impl rule__Entity__Group__6
            {
            pushFollow(FOLLOW_11);
            rule__Entity__Group__5__Impl();

            state._fsp--;

            pushFollow(FOLLOW_2);
            rule__Entity__Group__6();

            state._fsp--;


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__Entity__Group__5"


    // $ANTLR start "rule__Entity__Group__5__Impl"
    // InternalModel.g:721:1: rule__Entity__Group__5__Impl : ( ( rule__Entity__AttributesAssignment_5 )* ) ;
    public final void rule__Entity__Group__5__Impl() throws RecognitionException {

        		int stackSize = keepStackSize();
            
        try {
            // InternalModel.g:725:1: ( ( ( rule__Entity__AttributesAssignment_5 )* ) )
            // InternalModel.g:726:1: ( ( rule__Entity__AttributesAssignment_5 )* )
            {
            // InternalModel.g:726:1: ( ( rule__Entity__AttributesAssignment_5 )* )
            // InternalModel.g:727:1: ( rule__Entity__AttributesAssignment_5 )*
            {
             before(grammarAccess.getEntityAccess().getAttributesAssignment_5()); 
            // InternalModel.g:728:1: ( rule__Entity__AttributesAssignment_5 )*
            loop8:
            do {
                int alt8=2;
                int LA8_0 = input.LA(1);

                if ( (LA8_0==RULE_COMMENT||LA8_0==25||LA8_0==27) ) {
                    alt8=1;
                }


                switch (alt8) {
            	case 1 :
            	    // InternalModel.g:728:2: rule__Entity__AttributesAssignment_5
            	    {
            	    pushFollow(FOLLOW_12);
            	    rule__Entity__AttributesAssignment_5();

            	    state._fsp--;


            	    }
            	    break;

            	default :
            	    break loop8;
                }
            } while (true);

             after(grammarAccess.getEntityAccess().getAttributesAssignment_5()); 

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__Entity__Group__5__Impl"


    // $ANTLR start "rule__Entity__Group__6"
    // InternalModel.g:738:1: rule__Entity__Group__6 : rule__Entity__Group__6__Impl ;
    public final void rule__Entity__Group__6() throws RecognitionException {

        		int stackSize = keepStackSize();
            
        try {
            // InternalModel.g:742:1: ( rule__Entity__Group__6__Impl )
            // InternalModel.g:743:2: rule__Entity__Group__6__Impl
            {
            pushFollow(FOLLOW_2);
            rule__Entity__Group__6__Impl();

            state._fsp--;


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__Entity__Group__6"


    // $ANTLR start "rule__Entity__Group__6__Impl"
    // InternalModel.g:749:1: rule__Entity__Group__6__Impl : ( '}' ) ;
    public final void rule__Entity__Group__6__Impl() throws RecognitionException {

        		int stackSize = keepStackSize();
            
        try {
            // InternalModel.g:753:1: ( ( '}' ) )
            // InternalModel.g:754:1: ( '}' )
            {
            // InternalModel.g:754:1: ( '}' )
            // InternalModel.g:755:1: '}'
            {
             before(grammarAccess.getEntityAccess().getRightCurlyBracketKeyword_6()); 
            match(input,23,FOLLOW_2); 
             after(grammarAccess.getEntityAccess().getRightCurlyBracketKeyword_6()); 

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__Entity__Group__6__Impl"


    // $ANTLR start "rule__Entity__Group_3__0"
    // InternalModel.g:782:1: rule__Entity__Group_3__0 : rule__Entity__Group_3__0__Impl rule__Entity__Group_3__1 ;
    public final void rule__Entity__Group_3__0() throws RecognitionException {

        		int stackSize = keepStackSize();
            
        try {
            // InternalModel.g:786:1: ( rule__Entity__Group_3__0__Impl rule__Entity__Group_3__1 )
            // InternalModel.g:787:2: rule__Entity__Group_3__0__Impl rule__Entity__Group_3__1
            {
            pushFollow(FOLLOW_3);
            rule__Entity__Group_3__0__Impl();

            state._fsp--;

            pushFollow(FOLLOW_2);
            rule__Entity__Group_3__1();

            state._fsp--;


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__Entity__Group_3__0"


    // $ANTLR start "rule__Entity__Group_3__0__Impl"
    // InternalModel.g:794:1: rule__Entity__Group_3__0__Impl : ( 'extends' ) ;
    public final void rule__Entity__Group_3__0__Impl() throws RecognitionException {

        		int stackSize = keepStackSize();
            
        try {
            // InternalModel.g:798:1: ( ( 'extends' ) )
            // InternalModel.g:799:1: ( 'extends' )
            {
            // InternalModel.g:799:1: ( 'extends' )
            // InternalModel.g:800:1: 'extends'
            {
             before(grammarAccess.getEntityAccess().getExtendsKeyword_3_0()); 
            match(input,24,FOLLOW_2); 
             after(grammarAccess.getEntityAccess().getExtendsKeyword_3_0()); 

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__Entity__Group_3__0__Impl"


    // $ANTLR start "rule__Entity__Group_3__1"
    // InternalModel.g:813:1: rule__Entity__Group_3__1 : rule__Entity__Group_3__1__Impl ;
    public final void rule__Entity__Group_3__1() throws RecognitionException {

        		int stackSize = keepStackSize();
            
        try {
            // InternalModel.g:817:1: ( rule__Entity__Group_3__1__Impl )
            // InternalModel.g:818:2: rule__Entity__Group_3__1__Impl
            {
            pushFollow(FOLLOW_2);
            rule__Entity__Group_3__1__Impl();

            state._fsp--;


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__Entity__Group_3__1"


    // $ANTLR start "rule__Entity__Group_3__1__Impl"
    // InternalModel.g:824:1: rule__Entity__Group_3__1__Impl : ( ( rule__Entity__SuperTypeAssignment_3_1 ) ) ;
    public final void rule__Entity__Group_3__1__Impl() throws RecognitionException {

        		int stackSize = keepStackSize();
            
        try {
            // InternalModel.g:828:1: ( ( ( rule__Entity__SuperTypeAssignment_3_1 ) ) )
            // InternalModel.g:829:1: ( ( rule__Entity__SuperTypeAssignment_3_1 ) )
            {
            // InternalModel.g:829:1: ( ( rule__Entity__SuperTypeAssignment_3_1 ) )
            // InternalModel.g:830:1: ( rule__Entity__SuperTypeAssignment_3_1 )
            {
             before(grammarAccess.getEntityAccess().getSuperTypeAssignment_3_1()); 
            // InternalModel.g:831:1: ( rule__Entity__SuperTypeAssignment_3_1 )
            // InternalModel.g:831:2: rule__Entity__SuperTypeAssignment_3_1
            {
            pushFollow(FOLLOW_2);
            rule__Entity__SuperTypeAssignment_3_1();

            state._fsp--;


            }

             after(grammarAccess.getEntityAccess().getSuperTypeAssignment_3_1()); 

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__Entity__Group_3__1__Impl"


    // $ANTLR start "rule__Property__Group__0"
    // InternalModel.g:845:1: rule__Property__Group__0 : rule__Property__Group__0__Impl rule__Property__Group__1 ;
    public final void rule__Property__Group__0() throws RecognitionException {

        		int stackSize = keepStackSize();
            
        try {
            // InternalModel.g:849:1: ( rule__Property__Group__0__Impl rule__Property__Group__1 )
            // InternalModel.g:850:2: rule__Property__Group__0__Impl rule__Property__Group__1
            {
            pushFollow(FOLLOW_13);
            rule__Property__Group__0__Impl();

            state._fsp--;

            pushFollow(FOLLOW_2);
            rule__Property__Group__1();

            state._fsp--;


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__Property__Group__0"


    // $ANTLR start "rule__Property__Group__0__Impl"
    // InternalModel.g:857:1: rule__Property__Group__0__Impl : ( ( rule__Property__CommentAssignment_0 )* ) ;
    public final void rule__Property__Group__0__Impl() throws RecognitionException {

        		int stackSize = keepStackSize();
            
        try {
            // InternalModel.g:861:1: ( ( ( rule__Property__CommentAssignment_0 )* ) )
            // InternalModel.g:862:1: ( ( rule__Property__CommentAssignment_0 )* )
            {
            // InternalModel.g:862:1: ( ( rule__Property__CommentAssignment_0 )* )
            // InternalModel.g:863:1: ( rule__Property__CommentAssignment_0 )*
            {
             before(grammarAccess.getPropertyAccess().getCommentAssignment_0()); 
            // InternalModel.g:864:1: ( rule__Property__CommentAssignment_0 )*
            loop9:
            do {
                int alt9=2;
                int LA9_0 = input.LA(1);

                if ( (LA9_0==RULE_COMMENT) ) {
                    alt9=1;
                }


                switch (alt9) {
            	case 1 :
            	    // InternalModel.g:864:2: rule__Property__CommentAssignment_0
            	    {
            	    pushFollow(FOLLOW_9);
            	    rule__Property__CommentAssignment_0();

            	    state._fsp--;


            	    }
            	    break;

            	default :
            	    break loop9;
                }
            } while (true);

             after(grammarAccess.getPropertyAccess().getCommentAssignment_0()); 

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__Property__Group__0__Impl"


    // $ANTLR start "rule__Property__Group__1"
    // InternalModel.g:874:1: rule__Property__Group__1 : rule__Property__Group__1__Impl rule__Property__Group__2 ;
    public final void rule__Property__Group__1() throws RecognitionException {

        		int stackSize = keepStackSize();
            
        try {
            // InternalModel.g:878:1: ( rule__Property__Group__1__Impl rule__Property__Group__2 )
            // InternalModel.g:879:2: rule__Property__Group__1__Impl rule__Property__Group__2
            {
            pushFollow(FOLLOW_3);
            rule__Property__Group__1__Impl();

            state._fsp--;

            pushFollow(FOLLOW_2);
            rule__Property__Group__2();

            state._fsp--;


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__Property__Group__1"


    // $ANTLR start "rule__Property__Group__1__Impl"
    // InternalModel.g:886:1: rule__Property__Group__1__Impl : ( 'property' ) ;
    public final void rule__Property__Group__1__Impl() throws RecognitionException {

        		int stackSize = keepStackSize();
            
        try {
            // InternalModel.g:890:1: ( ( 'property' ) )
            // InternalModel.g:891:1: ( 'property' )
            {
            // InternalModel.g:891:1: ( 'property' )
            // InternalModel.g:892:1: 'property'
            {
             before(grammarAccess.getPropertyAccess().getPropertyKeyword_1()); 
            match(input,25,FOLLOW_2); 
             after(grammarAccess.getPropertyAccess().getPropertyKeyword_1()); 

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__Property__Group__1__Impl"


    // $ANTLR start "rule__Property__Group__2"
    // InternalModel.g:905:1: rule__Property__Group__2 : rule__Property__Group__2__Impl rule__Property__Group__3 ;
    public final void rule__Property__Group__2() throws RecognitionException {

        		int stackSize = keepStackSize();
            
        try {
            // InternalModel.g:909:1: ( rule__Property__Group__2__Impl rule__Property__Group__3 )
            // InternalModel.g:910:2: rule__Property__Group__2__Impl rule__Property__Group__3
            {
            pushFollow(FOLLOW_14);
            rule__Property__Group__2__Impl();

            state._fsp--;

            pushFollow(FOLLOW_2);
            rule__Property__Group__3();

            state._fsp--;


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__Property__Group__2"


    // $ANTLR start "rule__Property__Group__2__Impl"
    // InternalModel.g:917:1: rule__Property__Group__2__Impl : ( ( rule__Property__NameAssignment_2 ) ) ;
    public final void rule__Property__Group__2__Impl() throws RecognitionException {

        		int stackSize = keepStackSize();
            
        try {
            // InternalModel.g:921:1: ( ( ( rule__Property__NameAssignment_2 ) ) )
            // InternalModel.g:922:1: ( ( rule__Property__NameAssignment_2 ) )
            {
            // InternalModel.g:922:1: ( ( rule__Property__NameAssignment_2 ) )
            // InternalModel.g:923:1: ( rule__Property__NameAssignment_2 )
            {
             before(grammarAccess.getPropertyAccess().getNameAssignment_2()); 
            // InternalModel.g:924:1: ( rule__Property__NameAssignment_2 )
            // InternalModel.g:924:2: rule__Property__NameAssignment_2
            {
            pushFollow(FOLLOW_2);
            rule__Property__NameAssignment_2();

            state._fsp--;


            }

             after(grammarAccess.getPropertyAccess().getNameAssignment_2()); 

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__Property__Group__2__Impl"


    // $ANTLR start "rule__Property__Group__3"
    // InternalModel.g:934:1: rule__Property__Group__3 : rule__Property__Group__3__Impl rule__Property__Group__4 ;
    public final void rule__Property__Group__3() throws RecognitionException {

        		int stackSize = keepStackSize();
            
        try {
            // InternalModel.g:938:1: ( rule__Property__Group__3__Impl rule__Property__Group__4 )
            // InternalModel.g:939:2: rule__Property__Group__3__Impl rule__Property__Group__4
            {
            pushFollow(FOLLOW_15);
            rule__Property__Group__3__Impl();

            state._fsp--;

            pushFollow(FOLLOW_2);
            rule__Property__Group__4();

            state._fsp--;


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__Property__Group__3"


    // $ANTLR start "rule__Property__Group__3__Impl"
    // InternalModel.g:946:1: rule__Property__Group__3__Impl : ( ':' ) ;
    public final void rule__Property__Group__3__Impl() throws RecognitionException {

        		int stackSize = keepStackSize();
            
        try {
            // InternalModel.g:950:1: ( ( ':' ) )
            // InternalModel.g:951:1: ( ':' )
            {
            // InternalModel.g:951:1: ( ':' )
            // InternalModel.g:952:1: ':'
            {
             before(grammarAccess.getPropertyAccess().getColonKeyword_3()); 
            match(input,26,FOLLOW_2); 
             after(grammarAccess.getPropertyAccess().getColonKeyword_3()); 

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__Property__Group__3__Impl"


    // $ANTLR start "rule__Property__Group__4"
    // InternalModel.g:965:1: rule__Property__Group__4 : rule__Property__Group__4__Impl rule__Property__Group__5 ;
    public final void rule__Property__Group__4() throws RecognitionException {

        		int stackSize = keepStackSize();
            
        try {
            // InternalModel.g:969:1: ( rule__Property__Group__4__Impl rule__Property__Group__5 )
            // InternalModel.g:970:2: rule__Property__Group__4__Impl rule__Property__Group__5
            {
            pushFollow(FOLLOW_4);
            rule__Property__Group__4__Impl();

            state._fsp--;

            pushFollow(FOLLOW_2);
            rule__Property__Group__5();

            state._fsp--;


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__Property__Group__4"


    // $ANTLR start "rule__Property__Group__4__Impl"
    // InternalModel.g:977:1: rule__Property__Group__4__Impl : ( ( rule__Property__TypeAssignment_4 ) ) ;
    public final void rule__Property__Group__4__Impl() throws RecognitionException {

        		int stackSize = keepStackSize();
            
        try {
            // InternalModel.g:981:1: ( ( ( rule__Property__TypeAssignment_4 ) ) )
            // InternalModel.g:982:1: ( ( rule__Property__TypeAssignment_4 ) )
            {
            // InternalModel.g:982:1: ( ( rule__Property__TypeAssignment_4 ) )
            // InternalModel.g:983:1: ( rule__Property__TypeAssignment_4 )
            {
             before(grammarAccess.getPropertyAccess().getTypeAssignment_4()); 
            // InternalModel.g:984:1: ( rule__Property__TypeAssignment_4 )
            // InternalModel.g:984:2: rule__Property__TypeAssignment_4
            {
            pushFollow(FOLLOW_2);
            rule__Property__TypeAssignment_4();

            state._fsp--;


            }

             after(grammarAccess.getPropertyAccess().getTypeAssignment_4()); 

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__Property__Group__4__Impl"


    // $ANTLR start "rule__Property__Group__5"
    // InternalModel.g:994:1: rule__Property__Group__5 : rule__Property__Group__5__Impl ;
    public final void rule__Property__Group__5() throws RecognitionException {

        		int stackSize = keepStackSize();
            
        try {
            // InternalModel.g:998:1: ( rule__Property__Group__5__Impl )
            // InternalModel.g:999:2: rule__Property__Group__5__Impl
            {
            pushFollow(FOLLOW_2);
            rule__Property__Group__5__Impl();

            state._fsp--;


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__Property__Group__5"


    // $ANTLR start "rule__Property__Group__5__Impl"
    // InternalModel.g:1005:1: rule__Property__Group__5__Impl : ( ';' ) ;
    public final void rule__Property__Group__5__Impl() throws RecognitionException {

        		int stackSize = keepStackSize();
            
        try {
            // InternalModel.g:1009:1: ( ( ';' ) )
            // InternalModel.g:1010:1: ( ';' )
            {
            // InternalModel.g:1010:1: ( ';' )
            // InternalModel.g:1011:1: ';'
            {
             before(grammarAccess.getPropertyAccess().getSemicolonKeyword_5()); 
            match(input,20,FOLLOW_2); 
             after(grammarAccess.getPropertyAccess().getSemicolonKeyword_5()); 

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__Property__Group__5__Impl"


    // $ANTLR start "rule__Link__Group__0"
    // InternalModel.g:1036:1: rule__Link__Group__0 : rule__Link__Group__0__Impl rule__Link__Group__1 ;
    public final void rule__Link__Group__0() throws RecognitionException {

        		int stackSize = keepStackSize();
            
        try {
            // InternalModel.g:1040:1: ( rule__Link__Group__0__Impl rule__Link__Group__1 )
            // InternalModel.g:1041:2: rule__Link__Group__0__Impl rule__Link__Group__1
            {
            pushFollow(FOLLOW_16);
            rule__Link__Group__0__Impl();

            state._fsp--;

            pushFollow(FOLLOW_2);
            rule__Link__Group__1();

            state._fsp--;


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__Link__Group__0"


    // $ANTLR start "rule__Link__Group__0__Impl"
    // InternalModel.g:1048:1: rule__Link__Group__0__Impl : ( ( rule__Link__CommentAssignment_0 )* ) ;
    public final void rule__Link__Group__0__Impl() throws RecognitionException {

        		int stackSize = keepStackSize();
            
        try {
            // InternalModel.g:1052:1: ( ( ( rule__Link__CommentAssignment_0 )* ) )
            // InternalModel.g:1053:1: ( ( rule__Link__CommentAssignment_0 )* )
            {
            // InternalModel.g:1053:1: ( ( rule__Link__CommentAssignment_0 )* )
            // InternalModel.g:1054:1: ( rule__Link__CommentAssignment_0 )*
            {
             before(grammarAccess.getLinkAccess().getCommentAssignment_0()); 
            // InternalModel.g:1055:1: ( rule__Link__CommentAssignment_0 )*
            loop10:
            do {
                int alt10=2;
                int LA10_0 = input.LA(1);

                if ( (LA10_0==RULE_COMMENT) ) {
                    alt10=1;
                }


                switch (alt10) {
            	case 1 :
            	    // InternalModel.g:1055:2: rule__Link__CommentAssignment_0
            	    {
            	    pushFollow(FOLLOW_9);
            	    rule__Link__CommentAssignment_0();

            	    state._fsp--;


            	    }
            	    break;

            	default :
            	    break loop10;
                }
            } while (true);

             after(grammarAccess.getLinkAccess().getCommentAssignment_0()); 

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__Link__Group__0__Impl"


    // $ANTLR start "rule__Link__Group__1"
    // InternalModel.g:1065:1: rule__Link__Group__1 : rule__Link__Group__1__Impl rule__Link__Group__2 ;
    public final void rule__Link__Group__1() throws RecognitionException {

        		int stackSize = keepStackSize();
            
        try {
            // InternalModel.g:1069:1: ( rule__Link__Group__1__Impl rule__Link__Group__2 )
            // InternalModel.g:1070:2: rule__Link__Group__1__Impl rule__Link__Group__2
            {
            pushFollow(FOLLOW_3);
            rule__Link__Group__1__Impl();

            state._fsp--;

            pushFollow(FOLLOW_2);
            rule__Link__Group__2();

            state._fsp--;


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__Link__Group__1"


    // $ANTLR start "rule__Link__Group__1__Impl"
    // InternalModel.g:1077:1: rule__Link__Group__1__Impl : ( 'link' ) ;
    public final void rule__Link__Group__1__Impl() throws RecognitionException {

        		int stackSize = keepStackSize();
            
        try {
            // InternalModel.g:1081:1: ( ( 'link' ) )
            // InternalModel.g:1082:1: ( 'link' )
            {
            // InternalModel.g:1082:1: ( 'link' )
            // InternalModel.g:1083:1: 'link'
            {
             before(grammarAccess.getLinkAccess().getLinkKeyword_1()); 
            match(input,27,FOLLOW_2); 
             after(grammarAccess.getLinkAccess().getLinkKeyword_1()); 

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__Link__Group__1__Impl"


    // $ANTLR start "rule__Link__Group__2"
    // InternalModel.g:1096:1: rule__Link__Group__2 : rule__Link__Group__2__Impl rule__Link__Group__3 ;
    public final void rule__Link__Group__2() throws RecognitionException {

        		int stackSize = keepStackSize();
            
        try {
            // InternalModel.g:1100:1: ( rule__Link__Group__2__Impl rule__Link__Group__3 )
            // InternalModel.g:1101:2: rule__Link__Group__2__Impl rule__Link__Group__3
            {
            pushFollow(FOLLOW_14);
            rule__Link__Group__2__Impl();

            state._fsp--;

            pushFollow(FOLLOW_2);
            rule__Link__Group__3();

            state._fsp--;


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__Link__Group__2"


    // $ANTLR start "rule__Link__Group__2__Impl"
    // InternalModel.g:1108:1: rule__Link__Group__2__Impl : ( ( rule__Link__NameAssignment_2 ) ) ;
    public final void rule__Link__Group__2__Impl() throws RecognitionException {

        		int stackSize = keepStackSize();
            
        try {
            // InternalModel.g:1112:1: ( ( ( rule__Link__NameAssignment_2 ) ) )
            // InternalModel.g:1113:1: ( ( rule__Link__NameAssignment_2 ) )
            {
            // InternalModel.g:1113:1: ( ( rule__Link__NameAssignment_2 ) )
            // InternalModel.g:1114:1: ( rule__Link__NameAssignment_2 )
            {
             before(grammarAccess.getLinkAccess().getNameAssignment_2()); 
            // InternalModel.g:1115:1: ( rule__Link__NameAssignment_2 )
            // InternalModel.g:1115:2: rule__Link__NameAssignment_2
            {
            pushFollow(FOLLOW_2);
            rule__Link__NameAssignment_2();

            state._fsp--;


            }

             after(grammarAccess.getLinkAccess().getNameAssignment_2()); 

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__Link__Group__2__Impl"


    // $ANTLR start "rule__Link__Group__3"
    // InternalModel.g:1125:1: rule__Link__Group__3 : rule__Link__Group__3__Impl rule__Link__Group__4 ;
    public final void rule__Link__Group__3() throws RecognitionException {

        		int stackSize = keepStackSize();
            
        try {
            // InternalModel.g:1129:1: ( rule__Link__Group__3__Impl rule__Link__Group__4 )
            // InternalModel.g:1130:2: rule__Link__Group__3__Impl rule__Link__Group__4
            {
            pushFollow(FOLLOW_3);
            rule__Link__Group__3__Impl();

            state._fsp--;

            pushFollow(FOLLOW_2);
            rule__Link__Group__4();

            state._fsp--;


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__Link__Group__3"


    // $ANTLR start "rule__Link__Group__3__Impl"
    // InternalModel.g:1137:1: rule__Link__Group__3__Impl : ( ':' ) ;
    public final void rule__Link__Group__3__Impl() throws RecognitionException {

        		int stackSize = keepStackSize();
            
        try {
            // InternalModel.g:1141:1: ( ( ':' ) )
            // InternalModel.g:1142:1: ( ':' )
            {
            // InternalModel.g:1142:1: ( ':' )
            // InternalModel.g:1143:1: ':'
            {
             before(grammarAccess.getLinkAccess().getColonKeyword_3()); 
            match(input,26,FOLLOW_2); 
             after(grammarAccess.getLinkAccess().getColonKeyword_3()); 

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__Link__Group__3__Impl"


    // $ANTLR start "rule__Link__Group__4"
    // InternalModel.g:1156:1: rule__Link__Group__4 : rule__Link__Group__4__Impl rule__Link__Group__5 ;
    public final void rule__Link__Group__4() throws RecognitionException {

        		int stackSize = keepStackSize();
            
        try {
            // InternalModel.g:1160:1: ( rule__Link__Group__4__Impl rule__Link__Group__5 )
            // InternalModel.g:1161:2: rule__Link__Group__4__Impl rule__Link__Group__5
            {
            pushFollow(FOLLOW_17);
            rule__Link__Group__4__Impl();

            state._fsp--;

            pushFollow(FOLLOW_2);
            rule__Link__Group__5();

            state._fsp--;


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__Link__Group__4"


    // $ANTLR start "rule__Link__Group__4__Impl"
    // InternalModel.g:1168:1: rule__Link__Group__4__Impl : ( ( rule__Link__TypeAssignment_4 ) ) ;
    public final void rule__Link__Group__4__Impl() throws RecognitionException {

        		int stackSize = keepStackSize();
            
        try {
            // InternalModel.g:1172:1: ( ( ( rule__Link__TypeAssignment_4 ) ) )
            // InternalModel.g:1173:1: ( ( rule__Link__TypeAssignment_4 ) )
            {
            // InternalModel.g:1173:1: ( ( rule__Link__TypeAssignment_4 ) )
            // InternalModel.g:1174:1: ( rule__Link__TypeAssignment_4 )
            {
             before(grammarAccess.getLinkAccess().getTypeAssignment_4()); 
            // InternalModel.g:1175:1: ( rule__Link__TypeAssignment_4 )
            // InternalModel.g:1175:2: rule__Link__TypeAssignment_4
            {
            pushFollow(FOLLOW_2);
            rule__Link__TypeAssignment_4();

            state._fsp--;


            }

             after(grammarAccess.getLinkAccess().getTypeAssignment_4()); 

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__Link__Group__4__Impl"


    // $ANTLR start "rule__Link__Group__5"
    // InternalModel.g:1185:1: rule__Link__Group__5 : rule__Link__Group__5__Impl rule__Link__Group__6 ;
    public final void rule__Link__Group__5() throws RecognitionException {

        		int stackSize = keepStackSize();
            
        try {
            // InternalModel.g:1189:1: ( rule__Link__Group__5__Impl rule__Link__Group__6 )
            // InternalModel.g:1190:2: rule__Link__Group__5__Impl rule__Link__Group__6
            {
            pushFollow(FOLLOW_17);
            rule__Link__Group__5__Impl();

            state._fsp--;

            pushFollow(FOLLOW_2);
            rule__Link__Group__6();

            state._fsp--;


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__Link__Group__5"


    // $ANTLR start "rule__Link__Group__5__Impl"
    // InternalModel.g:1197:1: rule__Link__Group__5__Impl : ( ( rule__Link__Alternatives_5 )? ) ;
    public final void rule__Link__Group__5__Impl() throws RecognitionException {

        		int stackSize = keepStackSize();
            
        try {
            // InternalModel.g:1201:1: ( ( ( rule__Link__Alternatives_5 )? ) )
            // InternalModel.g:1202:1: ( ( rule__Link__Alternatives_5 )? )
            {
            // InternalModel.g:1202:1: ( ( rule__Link__Alternatives_5 )? )
            // InternalModel.g:1203:1: ( rule__Link__Alternatives_5 )?
            {
             before(grammarAccess.getLinkAccess().getAlternatives_5()); 
            // InternalModel.g:1204:1: ( rule__Link__Alternatives_5 )?
            int alt11=2;
            int LA11_0 = input.LA(1);

            if ( ((LA11_0>=31 && LA11_0<=33)) ) {
                alt11=1;
            }
            switch (alt11) {
                case 1 :
                    // InternalModel.g:1204:2: rule__Link__Alternatives_5
                    {
                    pushFollow(FOLLOW_2);
                    rule__Link__Alternatives_5();

                    state._fsp--;


                    }
                    break;

            }

             after(grammarAccess.getLinkAccess().getAlternatives_5()); 

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__Link__Group__5__Impl"


    // $ANTLR start "rule__Link__Group__6"
    // InternalModel.g:1214:1: rule__Link__Group__6 : rule__Link__Group__6__Impl ;
    public final void rule__Link__Group__6() throws RecognitionException {

        		int stackSize = keepStackSize();
            
        try {
            // InternalModel.g:1218:1: ( rule__Link__Group__6__Impl )
            // InternalModel.g:1219:2: rule__Link__Group__6__Impl
            {
            pushFollow(FOLLOW_2);
            rule__Link__Group__6__Impl();

            state._fsp--;


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__Link__Group__6"


    // $ANTLR start "rule__Link__Group__6__Impl"
    // InternalModel.g:1225:1: rule__Link__Group__6__Impl : ( ';' ) ;
    public final void rule__Link__Group__6__Impl() throws RecognitionException {

        		int stackSize = keepStackSize();
            
        try {
            // InternalModel.g:1229:1: ( ( ';' ) )
            // InternalModel.g:1230:1: ( ';' )
            {
            // InternalModel.g:1230:1: ( ';' )
            // InternalModel.g:1231:1: ';'
            {
             before(grammarAccess.getLinkAccess().getSemicolonKeyword_6()); 
            match(input,20,FOLLOW_2); 
             after(grammarAccess.getLinkAccess().getSemicolonKeyword_6()); 

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__Link__Group__6__Impl"


    // $ANTLR start "rule__Import__Group__0"
    // InternalModel.g:1258:1: rule__Import__Group__0 : rule__Import__Group__0__Impl rule__Import__Group__1 ;
    public final void rule__Import__Group__0() throws RecognitionException {

        		int stackSize = keepStackSize();
            
        try {
            // InternalModel.g:1262:1: ( rule__Import__Group__0__Impl rule__Import__Group__1 )
            // InternalModel.g:1263:2: rule__Import__Group__0__Impl rule__Import__Group__1
            {
            pushFollow(FOLLOW_3);
            rule__Import__Group__0__Impl();

            state._fsp--;

            pushFollow(FOLLOW_2);
            rule__Import__Group__1();

            state._fsp--;


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__Import__Group__0"


    // $ANTLR start "rule__Import__Group__0__Impl"
    // InternalModel.g:1270:1: rule__Import__Group__0__Impl : ( 'import' ) ;
    public final void rule__Import__Group__0__Impl() throws RecognitionException {

        		int stackSize = keepStackSize();
            
        try {
            // InternalModel.g:1274:1: ( ( 'import' ) )
            // InternalModel.g:1275:1: ( 'import' )
            {
            // InternalModel.g:1275:1: ( 'import' )
            // InternalModel.g:1276:1: 'import'
            {
             before(grammarAccess.getImportAccess().getImportKeyword_0()); 
            match(input,28,FOLLOW_2); 
             after(grammarAccess.getImportAccess().getImportKeyword_0()); 

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__Import__Group__0__Impl"


    // $ANTLR start "rule__Import__Group__1"
    // InternalModel.g:1289:1: rule__Import__Group__1 : rule__Import__Group__1__Impl rule__Import__Group__2 ;
    public final void rule__Import__Group__1() throws RecognitionException {

        		int stackSize = keepStackSize();
            
        try {
            // InternalModel.g:1293:1: ( rule__Import__Group__1__Impl rule__Import__Group__2 )
            // InternalModel.g:1294:2: rule__Import__Group__1__Impl rule__Import__Group__2
            {
            pushFollow(FOLLOW_4);
            rule__Import__Group__1__Impl();

            state._fsp--;

            pushFollow(FOLLOW_2);
            rule__Import__Group__2();

            state._fsp--;


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__Import__Group__1"


    // $ANTLR start "rule__Import__Group__1__Impl"
    // InternalModel.g:1301:1: rule__Import__Group__1__Impl : ( ( rule__Import__ImportedNamespaceAssignment_1 ) ) ;
    public final void rule__Import__Group__1__Impl() throws RecognitionException {

        		int stackSize = keepStackSize();
            
        try {
            // InternalModel.g:1305:1: ( ( ( rule__Import__ImportedNamespaceAssignment_1 ) ) )
            // InternalModel.g:1306:1: ( ( rule__Import__ImportedNamespaceAssignment_1 ) )
            {
            // InternalModel.g:1306:1: ( ( rule__Import__ImportedNamespaceAssignment_1 ) )
            // InternalModel.g:1307:1: ( rule__Import__ImportedNamespaceAssignment_1 )
            {
             before(grammarAccess.getImportAccess().getImportedNamespaceAssignment_1()); 
            // InternalModel.g:1308:1: ( rule__Import__ImportedNamespaceAssignment_1 )
            // InternalModel.g:1308:2: rule__Import__ImportedNamespaceAssignment_1
            {
            pushFollow(FOLLOW_2);
            rule__Import__ImportedNamespaceAssignment_1();

            state._fsp--;


            }

             after(grammarAccess.getImportAccess().getImportedNamespaceAssignment_1()); 

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__Import__Group__1__Impl"


    // $ANTLR start "rule__Import__Group__2"
    // InternalModel.g:1318:1: rule__Import__Group__2 : rule__Import__Group__2__Impl ;
    public final void rule__Import__Group__2() throws RecognitionException {

        		int stackSize = keepStackSize();
            
        try {
            // InternalModel.g:1322:1: ( rule__Import__Group__2__Impl )
            // InternalModel.g:1323:2: rule__Import__Group__2__Impl
            {
            pushFollow(FOLLOW_2);
            rule__Import__Group__2__Impl();

            state._fsp--;


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__Import__Group__2"


    // $ANTLR start "rule__Import__Group__2__Impl"
    // InternalModel.g:1329:1: rule__Import__Group__2__Impl : ( ';' ) ;
    public final void rule__Import__Group__2__Impl() throws RecognitionException {

        		int stackSize = keepStackSize();
            
        try {
            // InternalModel.g:1333:1: ( ( ';' ) )
            // InternalModel.g:1334:1: ( ';' )
            {
            // InternalModel.g:1334:1: ( ';' )
            // InternalModel.g:1335:1: ';'
            {
             before(grammarAccess.getImportAccess().getSemicolonKeyword_2()); 
            match(input,20,FOLLOW_2); 
             after(grammarAccess.getImportAccess().getSemicolonKeyword_2()); 

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__Import__Group__2__Impl"


    // $ANTLR start "rule__QualifiedName__Group__0"
    // InternalModel.g:1354:1: rule__QualifiedName__Group__0 : rule__QualifiedName__Group__0__Impl rule__QualifiedName__Group__1 ;
    public final void rule__QualifiedName__Group__0() throws RecognitionException {

        		int stackSize = keepStackSize();
            
        try {
            // InternalModel.g:1358:1: ( rule__QualifiedName__Group__0__Impl rule__QualifiedName__Group__1 )
            // InternalModel.g:1359:2: rule__QualifiedName__Group__0__Impl rule__QualifiedName__Group__1
            {
            pushFollow(FOLLOW_18);
            rule__QualifiedName__Group__0__Impl();

            state._fsp--;

            pushFollow(FOLLOW_2);
            rule__QualifiedName__Group__1();

            state._fsp--;


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__QualifiedName__Group__0"


    // $ANTLR start "rule__QualifiedName__Group__0__Impl"
    // InternalModel.g:1366:1: rule__QualifiedName__Group__0__Impl : ( RULE_ID ) ;
    public final void rule__QualifiedName__Group__0__Impl() throws RecognitionException {

        		int stackSize = keepStackSize();
            
        try {
            // InternalModel.g:1370:1: ( ( RULE_ID ) )
            // InternalModel.g:1371:1: ( RULE_ID )
            {
            // InternalModel.g:1371:1: ( RULE_ID )
            // InternalModel.g:1372:1: RULE_ID
            {
             before(grammarAccess.getQualifiedNameAccess().getIDTerminalRuleCall_0()); 
            match(input,RULE_ID,FOLLOW_2); 
             after(grammarAccess.getQualifiedNameAccess().getIDTerminalRuleCall_0()); 

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__QualifiedName__Group__0__Impl"


    // $ANTLR start "rule__QualifiedName__Group__1"
    // InternalModel.g:1383:1: rule__QualifiedName__Group__1 : rule__QualifiedName__Group__1__Impl ;
    public final void rule__QualifiedName__Group__1() throws RecognitionException {

        		int stackSize = keepStackSize();
            
        try {
            // InternalModel.g:1387:1: ( rule__QualifiedName__Group__1__Impl )
            // InternalModel.g:1388:2: rule__QualifiedName__Group__1__Impl
            {
            pushFollow(FOLLOW_2);
            rule__QualifiedName__Group__1__Impl();

            state._fsp--;


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__QualifiedName__Group__1"


    // $ANTLR start "rule__QualifiedName__Group__1__Impl"
    // InternalModel.g:1394:1: rule__QualifiedName__Group__1__Impl : ( ( rule__QualifiedName__Group_1__0 )* ) ;
    public final void rule__QualifiedName__Group__1__Impl() throws RecognitionException {

        		int stackSize = keepStackSize();
            
        try {
            // InternalModel.g:1398:1: ( ( ( rule__QualifiedName__Group_1__0 )* ) )
            // InternalModel.g:1399:1: ( ( rule__QualifiedName__Group_1__0 )* )
            {
            // InternalModel.g:1399:1: ( ( rule__QualifiedName__Group_1__0 )* )
            // InternalModel.g:1400:1: ( rule__QualifiedName__Group_1__0 )*
            {
             before(grammarAccess.getQualifiedNameAccess().getGroup_1()); 
            // InternalModel.g:1401:1: ( rule__QualifiedName__Group_1__0 )*
            loop12:
            do {
                int alt12=2;
                int LA12_0 = input.LA(1);

                if ( (LA12_0==29) ) {
                    alt12=1;
                }


                switch (alt12) {
            	case 1 :
            	    // InternalModel.g:1401:2: rule__QualifiedName__Group_1__0
            	    {
            	    pushFollow(FOLLOW_19);
            	    rule__QualifiedName__Group_1__0();

            	    state._fsp--;


            	    }
            	    break;

            	default :
            	    break loop12;
                }
            } while (true);

             after(grammarAccess.getQualifiedNameAccess().getGroup_1()); 

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__QualifiedName__Group__1__Impl"


    // $ANTLR start "rule__QualifiedName__Group_1__0"
    // InternalModel.g:1415:1: rule__QualifiedName__Group_1__0 : rule__QualifiedName__Group_1__0__Impl rule__QualifiedName__Group_1__1 ;
    public final void rule__QualifiedName__Group_1__0() throws RecognitionException {

        		int stackSize = keepStackSize();
            
        try {
            // InternalModel.g:1419:1: ( rule__QualifiedName__Group_1__0__Impl rule__QualifiedName__Group_1__1 )
            // InternalModel.g:1420:2: rule__QualifiedName__Group_1__0__Impl rule__QualifiedName__Group_1__1
            {
            pushFollow(FOLLOW_3);
            rule__QualifiedName__Group_1__0__Impl();

            state._fsp--;

            pushFollow(FOLLOW_2);
            rule__QualifiedName__Group_1__1();

            state._fsp--;


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__QualifiedName__Group_1__0"


    // $ANTLR start "rule__QualifiedName__Group_1__0__Impl"
    // InternalModel.g:1427:1: rule__QualifiedName__Group_1__0__Impl : ( '.' ) ;
    public final void rule__QualifiedName__Group_1__0__Impl() throws RecognitionException {

        		int stackSize = keepStackSize();
            
        try {
            // InternalModel.g:1431:1: ( ( '.' ) )
            // InternalModel.g:1432:1: ( '.' )
            {
            // InternalModel.g:1432:1: ( '.' )
            // InternalModel.g:1433:1: '.'
            {
             before(grammarAccess.getQualifiedNameAccess().getFullStopKeyword_1_0()); 
            match(input,29,FOLLOW_2); 
             after(grammarAccess.getQualifiedNameAccess().getFullStopKeyword_1_0()); 

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__QualifiedName__Group_1__0__Impl"


    // $ANTLR start "rule__QualifiedName__Group_1__1"
    // InternalModel.g:1446:1: rule__QualifiedName__Group_1__1 : rule__QualifiedName__Group_1__1__Impl ;
    public final void rule__QualifiedName__Group_1__1() throws RecognitionException {

        		int stackSize = keepStackSize();
            
        try {
            // InternalModel.g:1450:1: ( rule__QualifiedName__Group_1__1__Impl )
            // InternalModel.g:1451:2: rule__QualifiedName__Group_1__1__Impl
            {
            pushFollow(FOLLOW_2);
            rule__QualifiedName__Group_1__1__Impl();

            state._fsp--;


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__QualifiedName__Group_1__1"


    // $ANTLR start "rule__QualifiedName__Group_1__1__Impl"
    // InternalModel.g:1457:1: rule__QualifiedName__Group_1__1__Impl : ( RULE_ID ) ;
    public final void rule__QualifiedName__Group_1__1__Impl() throws RecognitionException {

        		int stackSize = keepStackSize();
            
        try {
            // InternalModel.g:1461:1: ( ( RULE_ID ) )
            // InternalModel.g:1462:1: ( RULE_ID )
            {
            // InternalModel.g:1462:1: ( RULE_ID )
            // InternalModel.g:1463:1: RULE_ID
            {
             before(grammarAccess.getQualifiedNameAccess().getIDTerminalRuleCall_1_1()); 
            match(input,RULE_ID,FOLLOW_2); 
             after(grammarAccess.getQualifiedNameAccess().getIDTerminalRuleCall_1_1()); 

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__QualifiedName__Group_1__1__Impl"


    // $ANTLR start "rule__QualifiedNameWithWildcard__Group__0"
    // InternalModel.g:1478:1: rule__QualifiedNameWithWildcard__Group__0 : rule__QualifiedNameWithWildcard__Group__0__Impl rule__QualifiedNameWithWildcard__Group__1 ;
    public final void rule__QualifiedNameWithWildcard__Group__0() throws RecognitionException {

        		int stackSize = keepStackSize();
            
        try {
            // InternalModel.g:1482:1: ( rule__QualifiedNameWithWildcard__Group__0__Impl rule__QualifiedNameWithWildcard__Group__1 )
            // InternalModel.g:1483:2: rule__QualifiedNameWithWildcard__Group__0__Impl rule__QualifiedNameWithWildcard__Group__1
            {
            pushFollow(FOLLOW_20);
            rule__QualifiedNameWithWildcard__Group__0__Impl();

            state._fsp--;

            pushFollow(FOLLOW_2);
            rule__QualifiedNameWithWildcard__Group__1();

            state._fsp--;


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__QualifiedNameWithWildcard__Group__0"


    // $ANTLR start "rule__QualifiedNameWithWildcard__Group__0__Impl"
    // InternalModel.g:1490:1: rule__QualifiedNameWithWildcard__Group__0__Impl : ( ruleQualifiedName ) ;
    public final void rule__QualifiedNameWithWildcard__Group__0__Impl() throws RecognitionException {

        		int stackSize = keepStackSize();
            
        try {
            // InternalModel.g:1494:1: ( ( ruleQualifiedName ) )
            // InternalModel.g:1495:1: ( ruleQualifiedName )
            {
            // InternalModel.g:1495:1: ( ruleQualifiedName )
            // InternalModel.g:1496:1: ruleQualifiedName
            {
             before(grammarAccess.getQualifiedNameWithWildcardAccess().getQualifiedNameParserRuleCall_0()); 
            pushFollow(FOLLOW_2);
            ruleQualifiedName();

            state._fsp--;

             after(grammarAccess.getQualifiedNameWithWildcardAccess().getQualifiedNameParserRuleCall_0()); 

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__QualifiedNameWithWildcard__Group__0__Impl"


    // $ANTLR start "rule__QualifiedNameWithWildcard__Group__1"
    // InternalModel.g:1507:1: rule__QualifiedNameWithWildcard__Group__1 : rule__QualifiedNameWithWildcard__Group__1__Impl ;
    public final void rule__QualifiedNameWithWildcard__Group__1() throws RecognitionException {

        		int stackSize = keepStackSize();
            
        try {
            // InternalModel.g:1511:1: ( rule__QualifiedNameWithWildcard__Group__1__Impl )
            // InternalModel.g:1512:2: rule__QualifiedNameWithWildcard__Group__1__Impl
            {
            pushFollow(FOLLOW_2);
            rule__QualifiedNameWithWildcard__Group__1__Impl();

            state._fsp--;


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__QualifiedNameWithWildcard__Group__1"


    // $ANTLR start "rule__QualifiedNameWithWildcard__Group__1__Impl"
    // InternalModel.g:1518:1: rule__QualifiedNameWithWildcard__Group__1__Impl : ( ( '.*' )? ) ;
    public final void rule__QualifiedNameWithWildcard__Group__1__Impl() throws RecognitionException {

        		int stackSize = keepStackSize();
            
        try {
            // InternalModel.g:1522:1: ( ( ( '.*' )? ) )
            // InternalModel.g:1523:1: ( ( '.*' )? )
            {
            // InternalModel.g:1523:1: ( ( '.*' )? )
            // InternalModel.g:1524:1: ( '.*' )?
            {
             before(grammarAccess.getQualifiedNameWithWildcardAccess().getFullStopAsteriskKeyword_1()); 
            // InternalModel.g:1525:1: ( '.*' )?
            int alt13=2;
            int LA13_0 = input.LA(1);

            if ( (LA13_0==30) ) {
                alt13=1;
            }
            switch (alt13) {
                case 1 :
                    // InternalModel.g:1526:2: '.*'
                    {
                    match(input,30,FOLLOW_2); 

                    }
                    break;

            }

             after(grammarAccess.getQualifiedNameWithWildcardAccess().getFullStopAsteriskKeyword_1()); 

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__QualifiedNameWithWildcard__Group__1__Impl"


    // $ANTLR start "rule__Model__NameAssignment_1"
    // InternalModel.g:1542:1: rule__Model__NameAssignment_1 : ( ruleQualifiedName ) ;
    public final void rule__Model__NameAssignment_1() throws RecognitionException {

        		int stackSize = keepStackSize();
            
        try {
            // InternalModel.g:1546:1: ( ( ruleQualifiedName ) )
            // InternalModel.g:1547:1: ( ruleQualifiedName )
            {
            // InternalModel.g:1547:1: ( ruleQualifiedName )
            // InternalModel.g:1548:1: ruleQualifiedName
            {
             before(grammarAccess.getModelAccess().getNameQualifiedNameParserRuleCall_1_0()); 
            pushFollow(FOLLOW_2);
            ruleQualifiedName();

            state._fsp--;

             after(grammarAccess.getModelAccess().getNameQualifiedNameParserRuleCall_1_0()); 

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__Model__NameAssignment_1"


    // $ANTLR start "rule__Model__ImportsAssignment_3"
    // InternalModel.g:1557:1: rule__Model__ImportsAssignment_3 : ( ruleImport ) ;
    public final void rule__Model__ImportsAssignment_3() throws RecognitionException {

        		int stackSize = keepStackSize();
            
        try {
            // InternalModel.g:1561:1: ( ( ruleImport ) )
            // InternalModel.g:1562:1: ( ruleImport )
            {
            // InternalModel.g:1562:1: ( ruleImport )
            // InternalModel.g:1563:1: ruleImport
            {
             before(grammarAccess.getModelAccess().getImportsImportParserRuleCall_3_0()); 
            pushFollow(FOLLOW_2);
            ruleImport();

            state._fsp--;

             after(grammarAccess.getModelAccess().getImportsImportParserRuleCall_3_0()); 

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__Model__ImportsAssignment_3"


    // $ANTLR start "rule__Model__ElementsAssignment_4"
    // InternalModel.g:1572:1: rule__Model__ElementsAssignment_4 : ( ruleEntity ) ;
    public final void rule__Model__ElementsAssignment_4() throws RecognitionException {

        		int stackSize = keepStackSize();
            
        try {
            // InternalModel.g:1576:1: ( ( ruleEntity ) )
            // InternalModel.g:1577:1: ( ruleEntity )
            {
            // InternalModel.g:1577:1: ( ruleEntity )
            // InternalModel.g:1578:1: ruleEntity
            {
             before(grammarAccess.getModelAccess().getElementsEntityParserRuleCall_4_0()); 
            pushFollow(FOLLOW_2);
            ruleEntity();

            state._fsp--;

             after(grammarAccess.getModelAccess().getElementsEntityParserRuleCall_4_0()); 

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__Model__ElementsAssignment_4"


    // $ANTLR start "rule__Entity__CommentAssignment_0"
    // InternalModel.g:1587:1: rule__Entity__CommentAssignment_0 : ( RULE_COMMENT ) ;
    public final void rule__Entity__CommentAssignment_0() throws RecognitionException {

        		int stackSize = keepStackSize();
            
        try {
            // InternalModel.g:1591:1: ( ( RULE_COMMENT ) )
            // InternalModel.g:1592:1: ( RULE_COMMENT )
            {
            // InternalModel.g:1592:1: ( RULE_COMMENT )
            // InternalModel.g:1593:1: RULE_COMMENT
            {
             before(grammarAccess.getEntityAccess().getCommentCOMMENTTerminalRuleCall_0_0()); 
            match(input,RULE_COMMENT,FOLLOW_2); 
             after(grammarAccess.getEntityAccess().getCommentCOMMENTTerminalRuleCall_0_0()); 

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__Entity__CommentAssignment_0"


    // $ANTLR start "rule__Entity__NameAssignment_2"
    // InternalModel.g:1602:1: rule__Entity__NameAssignment_2 : ( RULE_ID ) ;
    public final void rule__Entity__NameAssignment_2() throws RecognitionException {

        		int stackSize = keepStackSize();
            
        try {
            // InternalModel.g:1606:1: ( ( RULE_ID ) )
            // InternalModel.g:1607:1: ( RULE_ID )
            {
            // InternalModel.g:1607:1: ( RULE_ID )
            // InternalModel.g:1608:1: RULE_ID
            {
             before(grammarAccess.getEntityAccess().getNameIDTerminalRuleCall_2_0()); 
            match(input,RULE_ID,FOLLOW_2); 
             after(grammarAccess.getEntityAccess().getNameIDTerminalRuleCall_2_0()); 

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__Entity__NameAssignment_2"


    // $ANTLR start "rule__Entity__SuperTypeAssignment_3_1"
    // InternalModel.g:1617:1: rule__Entity__SuperTypeAssignment_3_1 : ( ( ruleQualifiedName ) ) ;
    public final void rule__Entity__SuperTypeAssignment_3_1() throws RecognitionException {

        		int stackSize = keepStackSize();
            
        try {
            // InternalModel.g:1621:1: ( ( ( ruleQualifiedName ) ) )
            // InternalModel.g:1622:1: ( ( ruleQualifiedName ) )
            {
            // InternalModel.g:1622:1: ( ( ruleQualifiedName ) )
            // InternalModel.g:1623:1: ( ruleQualifiedName )
            {
             before(grammarAccess.getEntityAccess().getSuperTypeEntityCrossReference_3_1_0()); 
            // InternalModel.g:1624:1: ( ruleQualifiedName )
            // InternalModel.g:1625:1: ruleQualifiedName
            {
             before(grammarAccess.getEntityAccess().getSuperTypeEntityQualifiedNameParserRuleCall_3_1_0_1()); 
            pushFollow(FOLLOW_2);
            ruleQualifiedName();

            state._fsp--;

             after(grammarAccess.getEntityAccess().getSuperTypeEntityQualifiedNameParserRuleCall_3_1_0_1()); 

            }

             after(grammarAccess.getEntityAccess().getSuperTypeEntityCrossReference_3_1_0()); 

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__Entity__SuperTypeAssignment_3_1"


    // $ANTLR start "rule__Entity__AttributesAssignment_5"
    // InternalModel.g:1636:1: rule__Entity__AttributesAssignment_5 : ( ruleAttribute ) ;
    public final void rule__Entity__AttributesAssignment_5() throws RecognitionException {

        		int stackSize = keepStackSize();
            
        try {
            // InternalModel.g:1640:1: ( ( ruleAttribute ) )
            // InternalModel.g:1641:1: ( ruleAttribute )
            {
            // InternalModel.g:1641:1: ( ruleAttribute )
            // InternalModel.g:1642:1: ruleAttribute
            {
             before(grammarAccess.getEntityAccess().getAttributesAttributeParserRuleCall_5_0()); 
            pushFollow(FOLLOW_2);
            ruleAttribute();

            state._fsp--;

             after(grammarAccess.getEntityAccess().getAttributesAttributeParserRuleCall_5_0()); 

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__Entity__AttributesAssignment_5"


    // $ANTLR start "rule__Property__CommentAssignment_0"
    // InternalModel.g:1651:1: rule__Property__CommentAssignment_0 : ( RULE_COMMENT ) ;
    public final void rule__Property__CommentAssignment_0() throws RecognitionException {

        		int stackSize = keepStackSize();
            
        try {
            // InternalModel.g:1655:1: ( ( RULE_COMMENT ) )
            // InternalModel.g:1656:1: ( RULE_COMMENT )
            {
            // InternalModel.g:1656:1: ( RULE_COMMENT )
            // InternalModel.g:1657:1: RULE_COMMENT
            {
             before(grammarAccess.getPropertyAccess().getCommentCOMMENTTerminalRuleCall_0_0()); 
            match(input,RULE_COMMENT,FOLLOW_2); 
             after(grammarAccess.getPropertyAccess().getCommentCOMMENTTerminalRuleCall_0_0()); 

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__Property__CommentAssignment_0"


    // $ANTLR start "rule__Property__NameAssignment_2"
    // InternalModel.g:1666:1: rule__Property__NameAssignment_2 : ( RULE_ID ) ;
    public final void rule__Property__NameAssignment_2() throws RecognitionException {

        		int stackSize = keepStackSize();
            
        try {
            // InternalModel.g:1670:1: ( ( RULE_ID ) )
            // InternalModel.g:1671:1: ( RULE_ID )
            {
            // InternalModel.g:1671:1: ( RULE_ID )
            // InternalModel.g:1672:1: RULE_ID
            {
             before(grammarAccess.getPropertyAccess().getNameIDTerminalRuleCall_2_0()); 
            match(input,RULE_ID,FOLLOW_2); 
             after(grammarAccess.getPropertyAccess().getNameIDTerminalRuleCall_2_0()); 

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__Property__NameAssignment_2"


    // $ANTLR start "rule__Property__TypeAssignment_4"
    // InternalModel.g:1681:1: rule__Property__TypeAssignment_4 : ( ( rule__Property__TypeAlternatives_4_0 ) ) ;
    public final void rule__Property__TypeAssignment_4() throws RecognitionException {

        		int stackSize = keepStackSize();
            
        try {
            // InternalModel.g:1685:1: ( ( ( rule__Property__TypeAlternatives_4_0 ) ) )
            // InternalModel.g:1686:1: ( ( rule__Property__TypeAlternatives_4_0 ) )
            {
            // InternalModel.g:1686:1: ( ( rule__Property__TypeAlternatives_4_0 ) )
            // InternalModel.g:1687:1: ( rule__Property__TypeAlternatives_4_0 )
            {
             before(grammarAccess.getPropertyAccess().getTypeAlternatives_4_0()); 
            // InternalModel.g:1688:1: ( rule__Property__TypeAlternatives_4_0 )
            // InternalModel.g:1688:2: rule__Property__TypeAlternatives_4_0
            {
            pushFollow(FOLLOW_2);
            rule__Property__TypeAlternatives_4_0();

            state._fsp--;


            }

             after(grammarAccess.getPropertyAccess().getTypeAlternatives_4_0()); 

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__Property__TypeAssignment_4"


    // $ANTLR start "rule__Link__CommentAssignment_0"
    // InternalModel.g:1697:1: rule__Link__CommentAssignment_0 : ( RULE_COMMENT ) ;
    public final void rule__Link__CommentAssignment_0() throws RecognitionException {

        		int stackSize = keepStackSize();
            
        try {
            // InternalModel.g:1701:1: ( ( RULE_COMMENT ) )
            // InternalModel.g:1702:1: ( RULE_COMMENT )
            {
            // InternalModel.g:1702:1: ( RULE_COMMENT )
            // InternalModel.g:1703:1: RULE_COMMENT
            {
             before(grammarAccess.getLinkAccess().getCommentCOMMENTTerminalRuleCall_0_0()); 
            match(input,RULE_COMMENT,FOLLOW_2); 
             after(grammarAccess.getLinkAccess().getCommentCOMMENTTerminalRuleCall_0_0()); 

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__Link__CommentAssignment_0"


    // $ANTLR start "rule__Link__NameAssignment_2"
    // InternalModel.g:1712:1: rule__Link__NameAssignment_2 : ( RULE_ID ) ;
    public final void rule__Link__NameAssignment_2() throws RecognitionException {

        		int stackSize = keepStackSize();
            
        try {
            // InternalModel.g:1716:1: ( ( RULE_ID ) )
            // InternalModel.g:1717:1: ( RULE_ID )
            {
            // InternalModel.g:1717:1: ( RULE_ID )
            // InternalModel.g:1718:1: RULE_ID
            {
             before(grammarAccess.getLinkAccess().getNameIDTerminalRuleCall_2_0()); 
            match(input,RULE_ID,FOLLOW_2); 
             after(grammarAccess.getLinkAccess().getNameIDTerminalRuleCall_2_0()); 

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__Link__NameAssignment_2"


    // $ANTLR start "rule__Link__TypeAssignment_4"
    // InternalModel.g:1727:1: rule__Link__TypeAssignment_4 : ( ( ruleQualifiedName ) ) ;
    public final void rule__Link__TypeAssignment_4() throws RecognitionException {

        		int stackSize = keepStackSize();
            
        try {
            // InternalModel.g:1731:1: ( ( ( ruleQualifiedName ) ) )
            // InternalModel.g:1732:1: ( ( ruleQualifiedName ) )
            {
            // InternalModel.g:1732:1: ( ( ruleQualifiedName ) )
            // InternalModel.g:1733:1: ( ruleQualifiedName )
            {
             before(grammarAccess.getLinkAccess().getTypeEntityCrossReference_4_0()); 
            // InternalModel.g:1734:1: ( ruleQualifiedName )
            // InternalModel.g:1735:1: ruleQualifiedName
            {
             before(grammarAccess.getLinkAccess().getTypeEntityQualifiedNameParserRuleCall_4_0_1()); 
            pushFollow(FOLLOW_2);
            ruleQualifiedName();

            state._fsp--;

             after(grammarAccess.getLinkAccess().getTypeEntityQualifiedNameParserRuleCall_4_0_1()); 

            }

             after(grammarAccess.getLinkAccess().getTypeEntityCrossReference_4_0()); 

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__Link__TypeAssignment_4"


    // $ANTLR start "rule__Link__AnyAssignment_5_0"
    // InternalModel.g:1746:1: rule__Link__AnyAssignment_5_0 : ( ( '*' ) ) ;
    public final void rule__Link__AnyAssignment_5_0() throws RecognitionException {

        		int stackSize = keepStackSize();
            
        try {
            // InternalModel.g:1750:1: ( ( ( '*' ) ) )
            // InternalModel.g:1751:1: ( ( '*' ) )
            {
            // InternalModel.g:1751:1: ( ( '*' ) )
            // InternalModel.g:1752:1: ( '*' )
            {
             before(grammarAccess.getLinkAccess().getAnyAsteriskKeyword_5_0_0()); 
            // InternalModel.g:1753:1: ( '*' )
            // InternalModel.g:1754:1: '*'
            {
             before(grammarAccess.getLinkAccess().getAnyAsteriskKeyword_5_0_0()); 
            match(input,31,FOLLOW_2); 
             after(grammarAccess.getLinkAccess().getAnyAsteriskKeyword_5_0_0()); 

            }

             after(grammarAccess.getLinkAccess().getAnyAsteriskKeyword_5_0_0()); 

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__Link__AnyAssignment_5_0"


    // $ANTLR start "rule__Link__OneOrMoreAssignment_5_1"
    // InternalModel.g:1769:1: rule__Link__OneOrMoreAssignment_5_1 : ( ( '+' ) ) ;
    public final void rule__Link__OneOrMoreAssignment_5_1() throws RecognitionException {

        		int stackSize = keepStackSize();
            
        try {
            // InternalModel.g:1773:1: ( ( ( '+' ) ) )
            // InternalModel.g:1774:1: ( ( '+' ) )
            {
            // InternalModel.g:1774:1: ( ( '+' ) )
            // InternalModel.g:1775:1: ( '+' )
            {
             before(grammarAccess.getLinkAccess().getOneOrMorePlusSignKeyword_5_1_0()); 
            // InternalModel.g:1776:1: ( '+' )
            // InternalModel.g:1777:1: '+'
            {
             before(grammarAccess.getLinkAccess().getOneOrMorePlusSignKeyword_5_1_0()); 
            match(input,32,FOLLOW_2); 
             after(grammarAccess.getLinkAccess().getOneOrMorePlusSignKeyword_5_1_0()); 

            }

             after(grammarAccess.getLinkAccess().getOneOrMorePlusSignKeyword_5_1_0()); 

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__Link__OneOrMoreAssignment_5_1"


    // $ANTLR start "rule__Link__ZeroOrOneAssignment_5_2"
    // InternalModel.g:1792:1: rule__Link__ZeroOrOneAssignment_5_2 : ( ( '?' ) ) ;
    public final void rule__Link__ZeroOrOneAssignment_5_2() throws RecognitionException {

        		int stackSize = keepStackSize();
            
        try {
            // InternalModel.g:1796:1: ( ( ( '?' ) ) )
            // InternalModel.g:1797:1: ( ( '?' ) )
            {
            // InternalModel.g:1797:1: ( ( '?' ) )
            // InternalModel.g:1798:1: ( '?' )
            {
             before(grammarAccess.getLinkAccess().getZeroOrOneQuestionMarkKeyword_5_2_0()); 
            // InternalModel.g:1799:1: ( '?' )
            // InternalModel.g:1800:1: '?'
            {
             before(grammarAccess.getLinkAccess().getZeroOrOneQuestionMarkKeyword_5_2_0()); 
            match(input,33,FOLLOW_2); 
             after(grammarAccess.getLinkAccess().getZeroOrOneQuestionMarkKeyword_5_2_0()); 

            }

             after(grammarAccess.getLinkAccess().getZeroOrOneQuestionMarkKeyword_5_2_0()); 

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__Link__ZeroOrOneAssignment_5_2"


    // $ANTLR start "rule__Import__ImportedNamespaceAssignment_1"
    // InternalModel.g:1815:1: rule__Import__ImportedNamespaceAssignment_1 : ( ruleQualifiedNameWithWildcard ) ;
    public final void rule__Import__ImportedNamespaceAssignment_1() throws RecognitionException {

        		int stackSize = keepStackSize();
            
        try {
            // InternalModel.g:1819:1: ( ( ruleQualifiedNameWithWildcard ) )
            // InternalModel.g:1820:1: ( ruleQualifiedNameWithWildcard )
            {
            // InternalModel.g:1820:1: ( ruleQualifiedNameWithWildcard )
            // InternalModel.g:1821:1: ruleQualifiedNameWithWildcard
            {
             before(grammarAccess.getImportAccess().getImportedNamespaceQualifiedNameWithWildcardParserRuleCall_1_0()); 
            pushFollow(FOLLOW_2);
            ruleQualifiedNameWithWildcard();

            state._fsp--;

             after(grammarAccess.getImportAccess().getImportedNamespaceQualifiedNameWithWildcardParserRuleCall_1_0()); 

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__Import__ImportedNamespaceAssignment_1"

    // Delegated rules


    protected DFA1 dfa1 = new DFA1(this);
    static final String dfa_1s = "\4\uffff";
    static final String dfa_2s = "\2\5\2\uffff";
    static final String dfa_3s = "\2\33\2\uffff";
    static final String dfa_4s = "\2\uffff\1\1\1\2";
    static final String dfa_5s = "\4\uffff}>";
    static final String[] dfa_6s = {
            "\1\1\23\uffff\1\2\1\uffff\1\3",
            "\1\1\23\uffff\1\2\1\uffff\1\3",
            "",
            ""
    };

    static final short[] dfa_1 = DFA.unpackEncodedString(dfa_1s);
    static final char[] dfa_2 = DFA.unpackEncodedStringToUnsignedChars(dfa_2s);
    static final char[] dfa_3 = DFA.unpackEncodedStringToUnsignedChars(dfa_3s);
    static final short[] dfa_4 = DFA.unpackEncodedString(dfa_4s);
    static final short[] dfa_5 = DFA.unpackEncodedString(dfa_5s);
    static final short[][] dfa_6 = unpackEncodedStringArray(dfa_6s);

    class DFA1 extends DFA {

        public DFA1(BaseRecognizer recognizer) {
            this.recognizer = recognizer;
            this.decisionNumber = 1;
            this.eot = dfa_1;
            this.eof = dfa_1;
            this.min = dfa_2;
            this.max = dfa_3;
            this.accept = dfa_4;
            this.special = dfa_5;
            this.transition = dfa_6;
        }
        public String getDescription() {
            return "284:1: rule__Attribute__Alternatives : ( ( ruleProperty ) | ( ruleLink ) );";
        }
    }
 

    public static final BitSet FOLLOW_1 = new BitSet(new long[]{0x0000000000000000L});
    public static final BitSet FOLLOW_2 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_3 = new BitSet(new long[]{0x0000000000000010L});
    public static final BitSet FOLLOW_4 = new BitSet(new long[]{0x0000000000100000L});
    public static final BitSet FOLLOW_5 = new BitSet(new long[]{0x0000000010200020L});
    public static final BitSet FOLLOW_6 = new BitSet(new long[]{0x0000000010000002L});
    public static final BitSet FOLLOW_7 = new BitSet(new long[]{0x0000000000200022L});
    public static final BitSet FOLLOW_8 = new BitSet(new long[]{0x0000000000200020L});
    public static final BitSet FOLLOW_9 = new BitSet(new long[]{0x0000000000000022L});
    public static final BitSet FOLLOW_10 = new BitSet(new long[]{0x0000000001400000L});
    public static final BitSet FOLLOW_11 = new BitSet(new long[]{0x000000000A800020L});
    public static final BitSet FOLLOW_12 = new BitSet(new long[]{0x000000000A000022L});
    public static final BitSet FOLLOW_13 = new BitSet(new long[]{0x0000000002000020L});
    public static final BitSet FOLLOW_14 = new BitSet(new long[]{0x0000000004000000L});
    public static final BitSet FOLLOW_15 = new BitSet(new long[]{0x000000000007F000L});
    public static final BitSet FOLLOW_16 = new BitSet(new long[]{0x000000000A000020L});
    public static final BitSet FOLLOW_17 = new BitSet(new long[]{0x0000000380100000L});
    public static final BitSet FOLLOW_18 = new BitSet(new long[]{0x0000000020000000L});
    public static final BitSet FOLLOW_19 = new BitSet(new long[]{0x0000000020000002L});
    public static final BitSet FOLLOW_20 = new BitSet(new long[]{0x0000000040000000L});

}