package org.verapdf.generator;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.generator.IFileSystemAccess;
import org.eclipse.xtext.generator.IGenerator;
import org.eclipse.xtext.generator.JavaIoFileSystemAccess;
import org.eclipse.xtext.naming.IQualifiedNameProvider;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.IteratorExtensions;
import org.verapdf.model.Attribute;
import org.verapdf.model.Entity;
import org.verapdf.model.Import;
import org.verapdf.model.Link;
import org.verapdf.model.Property;

/**
 * Generates code from your model files on save.4
 * 
 * see http://www.eclipse.org/Xtext/documentation.html#TutorialCodeGeneration
 */
@SuppressWarnings("all")
public class ModelGenerator implements IGenerator {
  private final String HELP_CLASSES_PASS = "org/verapdf/model/";
  
  private final String HELP_CLASSES_PACKAGE = "org.verapdf.model";
  
  private final String MODEL_HELPER_NAME = "ModelHelper";
  
  private final String GENERICMODELOBJECT_NAME = "GenericModelObject";
  
  @Inject
  @Extension
  private IQualifiedNameProvider _iQualifiedNameProvider;
  
  @Override
  public void doGenerate(final Resource resource, final IFileSystemAccess fsa) {
    final JavaIoFileSystemAccess fsa1 = ((JavaIoFileSystemAccess) fsa);
    try {
      final CharSequence is = fsa1.readTextFile(((this.HELP_CLASSES_PASS + this.MODEL_HELPER_NAME) + ".java"));
      int index = is.toString().lastIndexOf("}");
      index = is.toString().substring(0, index).lastIndexOf("}");
      String result = is.toString().substring(0, index);
      Iterable<Entity> _filter = Iterables.<Entity>filter(IteratorExtensions.<EObject>toIterable(resource.getAllContents()), Entity.class);
      for (final Entity e : _filter) {
        String _name = e.getName();
        String _plus = ("fillMapOfSuperNames" + _name);
        boolean _contains = result.contains(_plus);
        if (_contains) {
          return;
        }
      }
      String _result = result;
      CharSequence _appendDependenceClass = this.appendDependenceClass(resource);
      result = (_result + _appendDependenceClass);
      fsa.generateFile(
        ((this.HELP_CLASSES_PASS + this.MODEL_HELPER_NAME) + ".java"), result);
    } catch (final Throwable _t) {
      if (_t instanceof Exception) {
        fsa.generateFile(
          ((this.HELP_CLASSES_PASS + this.MODEL_HELPER_NAME) + ".java"), 
          this.getDependenceClass(resource));
      } else {
        throw Exceptions.sneakyThrow(_t);
      }
    }
    Iterable<Entity> _filter = Iterables.<Entity>filter(IteratorExtensions.<EObject>toIterable(resource.getAllContents()), Entity.class);
    for (final Entity e : _filter) {
      {
        final List<Import> imports = IterableExtensions.<Import>toList(Iterables.<Import>filter(IteratorExtensions.<EObject>toIterable(resource.getAllContents()), Import.class));
        String _string = this._iQualifiedNameProvider.getFullyQualifiedName(e).toString("/");
        String _plus = (_string + ".java");
        fsa.generateFile(_plus, 
          this.compile(e, imports));
        boolean _equals = e.getName().equals("Object");
        if (_equals) {
          fsa.generateFile(
            ((this.HELP_CLASSES_PASS + this.GENERICMODELOBJECT_NAME) + ".java"), 
            this.generateGenericModelObject(e));
        }
      }
    }
  }
  
  public CharSequence compile(final Entity entity, final List<Import> imports) {
    StringConcatenation _builder = new StringConcatenation();
    {
      QualifiedName _fullyQualifiedName = this._iQualifiedNameProvider.getFullyQualifiedName(entity.eContainer());
      boolean _notEquals = (!Objects.equal(_fullyQualifiedName, null));
      if (_notEquals) {
        _builder.append("package ");
        QualifiedName _fullyQualifiedName_1 = this._iQualifiedNameProvider.getFullyQualifiedName(entity.eContainer());
        _builder.append(_fullyQualifiedName_1);
        _builder.append(";");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.newLine();
      }
    }
    {
      for(final Import imp : imports) {
        _builder.append("import ");
        String _importedNamespace = imp.getImportedNamespace();
        _builder.append(_importedNamespace);
        _builder.append(";");
        _builder.newLineIfNotEmpty();
      }
    }
    _builder.newLine();
    {
      Entity _superType = entity.getSuperType();
      boolean _equals = Objects.equal(_superType, null);
      if (_equals) {
        _builder.append("import java.util.List;");
      }
    }
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    _builder.newLine();
    {
      String _comment = entity.getComment();
      boolean _notEquals_1 = (!Objects.equal(_comment, null));
      if (_notEquals_1) {
        CharSequence _javaDocComment = this.toJavaDocComment(entity.getComment());
        _builder.append(_javaDocComment);
        _builder.newLineIfNotEmpty();
      }
    }
    _builder.append("public interface ");
    String _name = entity.getName();
    _builder.append(_name);
    {
      Entity _superType_1 = entity.getSuperType();
      boolean _notEquals_2 = (!Objects.equal(_superType_1, null));
      if (_notEquals_2) {
        _builder.append(" extends ");
        String _name_1 = entity.getSuperType().getName();
        _builder.append(_name_1);
      }
    }
    _builder.append(" {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.newLine();
    {
      Entity _superType_2 = entity.getSuperType();
      boolean _equals_1 = Objects.equal(_superType_2, null);
      if (_equals_1) {
        _builder.append("\t");
        _builder.append("public List<String> getLinks();");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("public List<? extends ");
        String _name_2 = entity.getName();
        _builder.append(_name_2, "\t");
        _builder.append("> getLinkedObjects(String linkName);");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("public List<String> getSuperTypes();");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("public List<String> getProperties();");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("public String getObjectType();");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("public String getID();");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("public Boolean isContextDependent();");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("public String getExtraContext();");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("public String getContext();");
        _builder.newLine();
      }
    }
    {
      EList<Attribute> _attributes = entity.getAttributes();
      for(final Attribute attribute : _attributes) {
        _builder.newLine();
        _builder.append("\t");
        CharSequence _generateGetter = this.generateGetter(attribute);
        _builder.append(_generateGetter, "\t");
        _builder.newLineIfNotEmpty();
      }
    }
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence generateGetter(final Attribute attribute) {
    StringConcatenation _builder = new StringConcatenation();
    {
      if ((attribute instanceof Property)) {
        {
          String _comment = ((Property)attribute).getComment();
          boolean _notEquals = (!Objects.equal(_comment, null));
          if (_notEquals) {
            CharSequence _javaDocComment = this.toJavaDocComment(((Property)attribute).getComment());
            _builder.append(_javaDocComment);
            _builder.newLineIfNotEmpty();
          }
        }
        _builder.append("public ");
        String _javaType = this.toJavaType(((Property)attribute).getType());
        _builder.append(_javaType);
        _builder.append(" get");
        String _name = ((Property)attribute).getName();
        _builder.append(_name);
        _builder.append("();");
        _builder.newLineIfNotEmpty();
      }
    }
    return _builder;
  }
  
  public String toJavaType(final String type) {
    if (type != null) {
      switch (type) {
        case "Integer":
          return "Long";
        case "Decimal":
          return "Double";
        case "String":
          return "String";
        case "Boolean":
          return "Boolean";
      }
    }
    return null;
  }
  
  public CharSequence toJavaDocComment(final String comment) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("/** ");
    String _substring = comment.substring(1);
    _builder.append(_substring);
    _builder.append(" */");
    _builder.newLineIfNotEmpty();
    return _builder;
  }
  
  public CharSequence toInterfaceName(final String name) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("I");
    _builder.append(name);
    return _builder;
  }
  
  /**
   * «IF (attribute.any)»
   * public List<«attribute.type.name.toInterfaceName»> get«attribute.name»();
   * «ENDIF»
   * «IF (attribute.zeroOrOne)»
   * @Max(1)
   * public List<«attribute.type.name.toInterfaceName»> get«attribute.name»();
   * «ENDIF»
   */
  public CharSequence getDependenceClass(final Resource resource) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("package ");
    _builder.append(this.HELP_CLASSES_PACKAGE);
    _builder.append(";");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("import java.util.*;");
    _builder.newLine();
    _builder.newLine();
    _builder.append("/**");
    _builder.newLine();
    _builder.append("* This class represents names of superinterfaces and names of all properties for all generated interfaces.");
    _builder.newLine();
    _builder.append("*/");
    _builder.newLine();
    _builder.append("public final class ");
    _builder.append(this.MODEL_HELPER_NAME);
    _builder.append(" {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("private final static Map<String, String> mapOfSuperNames = new HashMap<String, String>();");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("private final static Map<String, List<String>> mapOfProperties = new HashMap<String, List<String>>();");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("private final static Map<String, List<String>> mapOfLinks = new HashMap<String, List<String>>();");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("private static List<String> properties;");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("private static List<String> links;");
    _builder.newLine();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("private ModelHelper(){");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("/**");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("* @param objectName - the name of the object");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("* @return List of supernames for the given object");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("*/");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("public static List<String> getListOfSuperNames(String objectName){");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("List<String> res = new ArrayList<String>();");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("String currentObject = mapOfSuperNames.get(objectName);");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("while(currentObject != null){");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("res.add(currentObject);");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("currentObject = mapOfSuperNames.get(currentObject);");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("return res;");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("/**");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("* @return Set of all type names");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("*/");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("public static Set<String> getTypes(){");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("return mapOfSuperNames.keySet();");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("/**");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("* @param objectName - the name of the object");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("* @return List of names of properties for the given object");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("*/");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("public static List<String> getListOfProperties(String objectName){");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("List<String> res = new ArrayList<String>();");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("String currentObject = objectName;");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("while(currentObject != null){");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("for(String prop : mapOfProperties.get(currentObject)){");
    _builder.newLine();
    _builder.append("\t\t\t\t");
    _builder.append("res.add(prop);");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("currentObject = mapOfSuperNames.get(currentObject);");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("return res;");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("/**");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("* @param objectName - the name of the object");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("* @return List of names of links for the given object");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("*/");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("public static List<String> getListOfLinks(String objectName){");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("List<String> res = new ArrayList<String>();");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("String currentObject = objectName;");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("while(currentObject != null){");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("for(String link : mapOfLinks.get(currentObject)){");
    _builder.newLine();
    _builder.append("\t\t\t\t");
    _builder.append("res.add(link);");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("currentObject = mapOfSuperNames.get(currentObject);");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("return res;");
    _builder.newLine();
    CharSequence _appendDependenceClass = this.appendDependenceClass(resource);
    _builder.append(_appendDependenceClass);
    _builder.newLineIfNotEmpty();
    return _builder;
  }
  
  public CharSequence appendDependenceClass(final Resource resource) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    {
      Iterable<Entity> _filter = Iterables.<Entity>filter(IteratorExtensions.<EObject>toIterable(resource.getAllContents()), Entity.class);
      for(final Entity e : _filter) {
        _builder.newLine();
        _builder.append("\t");
        _builder.append("private static void fillMapOfSuperNames");
        String _name = e.getName();
        _builder.append(_name, "\t");
        _builder.append("() {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("\t");
        _builder.append("mapOfSuperNames.put(\"");
        String _name_1 = e.getName();
        _builder.append(_name_1, "\t\t");
        _builder.append("\",");
        {
          Entity _superType = e.getSuperType();
          boolean _equals = Objects.equal(_superType, null);
          if (_equals) {
            _builder.append("null");
          } else {
            _builder.append("\"");
            String _name_2 = e.getSuperType().getName();
            _builder.append(_name_2, "\t\t");
            _builder.append("\"");
          }
        }
        _builder.append(");");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("private static void fillMapOfProperties");
        String _name_3 = e.getName();
        _builder.append(_name_3, "\t");
        _builder.append("() {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("\t");
        _builder.append("properties = new ArrayList<String>();");
        _builder.newLine();
        {
          EList<Attribute> _attributes = e.getAttributes();
          for(final Attribute prop : _attributes) {
            {
              if ((prop instanceof Property)) {
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("properties.add(\"");
                String _name_4 = ((Property)prop).getName();
                _builder.append(_name_4, "\t\t");
                _builder.append("\");");
                _builder.newLineIfNotEmpty();
              }
            }
          }
        }
        _builder.append("\t");
        _builder.append("\t");
        _builder.append("mapOfProperties.put(\"");
        String _name_5 = e.getName();
        _builder.append(_name_5, "\t\t");
        _builder.append("\",properties);");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("private static void fillMapOfLinks");
        String _name_6 = e.getName();
        _builder.append(_name_6, "\t");
        _builder.append("() {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("\t");
        _builder.append("links = new ArrayList<String>();");
        _builder.newLine();
        {
          EList<Attribute> _attributes_1 = e.getAttributes();
          for(final Attribute link : _attributes_1) {
            {
              if ((link instanceof Link)) {
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("links.add(\"");
                String _name_7 = ((Link)link).getName();
                _builder.append(_name_7, "\t\t");
                _builder.append("\");");
                _builder.newLineIfNotEmpty();
              }
            }
          }
        }
        _builder.append("\t");
        _builder.append("\t");
        _builder.append("mapOfLinks.put(\"");
        String _name_8 = e.getName();
        _builder.append(_name_8, "\t\t");
        _builder.append("\",links);");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("static {");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("\t");
        _builder.append("fillMapOfSuperNames");
        String _name_9 = e.getName();
        _builder.append(_name_9, "\t\t");
        _builder.append("();");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("\t");
        _builder.append("fillMapOfProperties");
        String _name_10 = e.getName();
        _builder.append(_name_10, "\t\t");
        _builder.append("();");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("\t");
        _builder.append("fillMapOfLinks");
        String _name_11 = e.getName();
        _builder.append(_name_11, "\t\t");
        _builder.append("();");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
      }
    }
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence generateGenericModelObject(final Entity e) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("package ");
    _builder.append(this.HELP_CLASSES_PACKAGE);
    _builder.append(";");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("import ");
    QualifiedName _fullyQualifiedName = this._iQualifiedNameProvider.getFullyQualifiedName(e.eContainer());
    _builder.append(_fullyQualifiedName);
    _builder.append(".");
    String _name = e.getName();
    _builder.append(_name);
    _builder.append(";");
    _builder.newLineIfNotEmpty();
    _builder.append("import java.util.*;");
    _builder.newLine();
    _builder.append("import java.util.stream.Collectors;");
    _builder.newLine();
    _builder.newLine();
    _builder.append("public abstract class ");
    _builder.append(this.GENERICMODELOBJECT_NAME);
    _builder.append(" implements ");
    String _name_1 = e.getName();
    _builder.append(_name_1);
    _builder.append(" {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("protected Boolean contextDependent = false;");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("private final String objectType;");
    _builder.newLine();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("protected ");
    _builder.append(this.GENERICMODELOBJECT_NAME, "\t");
    _builder.append("(String objectType) {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    _builder.append("this.objectType = objectType;");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("/**");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("* @return type of the current object");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("*/");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("public final String getObjectType() {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("return this.objectType;");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("/**");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("* @return id of the current object");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("*/");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("public String getID() {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("return null;");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t");
    _builder.append("/**");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("* @return extra context of the current object");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("*/");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("public String getExtraContext() {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("return null;");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t");
    _builder.append("/**");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("* @return context of the current object");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("*/");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("public String getContext() {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("return null;");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("/**");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("* @param link - the name of a link");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("* @return List of objects with the given link");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("*/");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("@Override");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("public List<? extends Object> getLinkedObjects(String link) {");
    _builder.newLine();
    _builder.append("        ");
    _builder.append("throw new IllegalAccessError(this.getObjectType() + \" has not access to this method or has not \" + link + \" link.\");");
    _builder.newLine();
    _builder.append("    ");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t");
    _builder.append("/**");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("* @return List of names of links for {@code this} object");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("*/");
    _builder.newLine();
    _builder.append("    ");
    _builder.append("@Override");
    _builder.newLine();
    _builder.append("    ");
    _builder.append("public List<String> getLinks() {");
    _builder.newLine();
    _builder.append("        ");
    _builder.append("return ModelHelper.getListOfLinks(this.getObjectType());");
    _builder.newLine();
    _builder.append("    ");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t");
    _builder.append("/**");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("* @return List of names of properties for {@code this} object");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("*/");
    _builder.newLine();
    _builder.append("    ");
    _builder.append("@Override");
    _builder.newLine();
    _builder.append("    ");
    _builder.append("public List<String> getProperties() {");
    _builder.newLine();
    _builder.append("        ");
    _builder.append("return ModelHelper.getListOfProperties(this.getObjectType());");
    _builder.newLine();
    _builder.append("    ");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t");
    _builder.append("/**");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("* @return null, if we have not know yet is this object context dependet of not. true, if this object is context dependent. false, if this object is not context dependent.");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("*/");
    _builder.newLine();
    _builder.append("    ");
    _builder.append("@Override");
    _builder.newLine();
    _builder.append("    ");
    _builder.append("public Boolean isContextDependent() {");
    _builder.newLine();
    _builder.append("        ");
    _builder.append("return contextDependent;");
    _builder.newLine();
    _builder.append("    ");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t");
    _builder.append("/**");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("* @return List of supernames for {@code this} object");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("*/");
    _builder.newLine();
    _builder.append("    ");
    _builder.append("@Override");
    _builder.newLine();
    _builder.append("    ");
    _builder.append("public List<String> getSuperTypes() {");
    _builder.newLine();
    _builder.append("        ");
    _builder.append("return ModelHelper.getListOfSuperNames(this.getObjectType());");
    _builder.newLine();
    _builder.append("    ");
    _builder.append("}");
    _builder.newLine();
    {
      EList<Attribute> _attributes = e.getAttributes();
      for(final Attribute attribute : _attributes) {
        _builder.newLine();
        _builder.append("\t");
        CharSequence _generateGetterForGenericModelObject = this.generateGetterForGenericModelObject(attribute);
        _builder.append(_generateGetterForGenericModelObject, "\t");
        _builder.newLineIfNotEmpty();
      }
    }
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence generateGetterForGenericModelObject(final Attribute attribute) {
    StringConcatenation _builder = new StringConcatenation();
    {
      if ((attribute instanceof Property)) {
        {
          String _comment = ((Property)attribute).getComment();
          boolean _notEquals = (!Objects.equal(_comment, null));
          if (_notEquals) {
            CharSequence _javaDocComment = this.toJavaDocComment(((Property)attribute).getComment());
            _builder.append(_javaDocComment);
            _builder.newLineIfNotEmpty();
          }
        }
        _builder.append("@Override");
        _builder.newLine();
        _builder.append("public abstract ");
        String _type = ((Property)attribute).getType();
        _builder.append(_type);
        _builder.append(" get");
        String _name = ((Property)attribute).getName();
        _builder.append(_name);
        _builder.append("();");
        _builder.newLineIfNotEmpty();
      }
    }
    return _builder;
  }
}
