/*
 * generated by Xtext
 */
package org.verapdf.serializer;

import com.google.inject.Inject;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.xtext.Action;
import org.eclipse.xtext.Parameter;
import org.eclipse.xtext.ParserRule;
import org.eclipse.xtext.serializer.ISerializationContext;
import org.eclipse.xtext.serializer.acceptor.SequenceFeeder;
import org.eclipse.xtext.serializer.sequencer.AbstractDelegatingSemanticSequencer;
import org.eclipse.xtext.serializer.sequencer.ITransientValueService.ValueTransient;
import org.verapdf.model.Entity;
import org.verapdf.model.Import;
import org.verapdf.model.Link;
import org.verapdf.model.Model;
import org.verapdf.model.ModelPackage;
import org.verapdf.model.Property;
import org.verapdf.services.ModelGrammarAccess;

@SuppressWarnings("all")
public class ModelSemanticSequencer extends AbstractDelegatingSemanticSequencer {

	@Inject
	private ModelGrammarAccess grammarAccess;
	
	@Override
	public void sequence(ISerializationContext context, EObject semanticObject) {
		EPackage epackage = semanticObject.eClass().getEPackage();
		ParserRule rule = context.getParserRule();
		Action action = context.getAssignedAction();
		Set<Parameter> parameters = context.getEnabledBooleanParameters();
		if (epackage == ModelPackage.eINSTANCE)
			switch (semanticObject.eClass().getClassifierID()) {
			case ModelPackage.ENTITY:
				sequence_Entity(context, (Entity) semanticObject); 
				return; 
			case ModelPackage.IMPORT:
				sequence_Import(context, (Import) semanticObject); 
				return; 
			case ModelPackage.LINK:
				sequence_Link(context, (Link) semanticObject); 
				return; 
			case ModelPackage.MODEL:
				sequence_Model(context, (Model) semanticObject); 
				return; 
			case ModelPackage.PROPERTY:
				sequence_Property(context, (Property) semanticObject); 
				return; 
			}
		if (errorAcceptor != null)
			errorAcceptor.accept(diagnosticProvider.createInvalidContextOrTypeDiagnostic(semanticObject, context));
	}
	
	/**
	 * <pre>
	 * Contexts:
	 *     Entity returns Entity
	 *
	 * Constraint:
	 *     (comment+=COMMENT* name=ID superType=[Entity|QualifiedName]? attributes+=Attribute*)
	 * </pre>
	 */
	protected void sequence_Entity(ISerializationContext context, Entity semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * <pre>
	 * Contexts:
	 *     Import returns Import
	 *
	 * Constraint:
	 *     importedNamespace=QualifiedNameWithWildcard
	 * </pre>
	 */
	protected void sequence_Import(ISerializationContext context, Import semanticObject) {
		if (errorAcceptor != null) {
			if (transientValues.isValueTransient(semanticObject, ModelPackage.Literals.IMPORT__IMPORTED_NAMESPACE) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, ModelPackage.Literals.IMPORT__IMPORTED_NAMESPACE));
		}
		SequenceFeeder feeder = createSequencerFeeder(context, semanticObject);
		feeder.accept(grammarAccess.getImportAccess().getImportedNamespaceQualifiedNameWithWildcardParserRuleCall_1_0(), semanticObject.getImportedNamespace());
		feeder.finish();
	}
	
	
	/**
	 * <pre>
	 * Contexts:
	 *     Attribute returns Link
	 *     Link returns Link
	 *
	 * Constraint:
	 *     (comment+=COMMENT* name=ID type=[Entity|QualifiedName] (any?='*' | oneOrMore?='+' | zeroOrOne?='?')?)
	 * </pre>
	 */
	protected void sequence_Link(ISerializationContext context, Link semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * <pre>
	 * Contexts:
	 *     Model returns Model
	 *
	 * Constraint:
	 *     (name=QualifiedName imports+=Import* elements+=Entity*)
	 * </pre>
	 */
	protected void sequence_Model(ISerializationContext context, Model semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * <pre>
	 * Contexts:
	 *     Attribute returns Property
	 *     Property returns Property
	 *
	 * Constraint:
	 *     (
	 *         comment+=COMMENT* 
	 *         name=ID 
	 *         (
	 *             type='String' | 
	 *             type='Integer' | 
	 *             type='Decimal' | 
	 *             type='Boolean' | 
	 *             type='Set&lt;String&gt;' | 
	 *             type='List&lt;String&gt;' | 
	 *             type='List&lt;List&lt;String&gt;&gt;'
	 *         )
	 *     )
	 * </pre>
	 */
	protected void sequence_Property(ISerializationContext context, Property semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
}
