/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.cos.filters;

import java.io.IOException;
import org.verapdf.as.filters.io.ASBufferingInFilter;
import org.verapdf.as.filters.io.COSFilterASCIIReader;
import org.verapdf.as.io.ASInputStream;

public class COSFilterASCII85Decode
extends ASBufferingInFilter {
    private COSFilterASCIIReader reader;

    public COSFilterASCII85Decode(ASInputStream stream) throws IOException {
        super(stream);
        this.reader = new COSFilterASCIIReader(stream, false);
    }

    @Override
    public int read(byte[] buffer, int size) throws IOException {
        int pointer = 0;
        byte[] fiveBytes = this.reader.getNextBytes();
        byte[] fourBytes = new byte[4];
        while (pointer + 4 <= size && fiveBytes != null) {
            int decoded = this.decodeFiveBytes(fiveBytes, fourBytes);
            System.arraycopy(fourBytes, 0, buffer, pointer, decoded);
            pointer += decoded;
            fiveBytes = this.reader.getNextBytes();
        }
        return pointer == 0 ? -1 : pointer;
    }

    private int decodeFiveBytes(byte[] fiveBytes, byte[] fourBytes) {
        int i;
        long value = 0L;
        for (i = 0; i < fiveBytes.length; ++i) {
            value += (long)(fiveBytes[i] - 33);
            value *= 85L;
        }
        for (i = 0; i < 5 - fiveBytes.length; ++i) {
            value += 84L;
            value *= 85L;
        }
        value /= 85L;
        for (i = 3; i >= 0; --i) {
            fourBytes[i] = (byte)(value % 256L);
            value >>= 8;
        }
        return fiveBytes.length - 1;
    }
}

