/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.cos.filters;

import java.io.EOFException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.stream.MemoryCacheImageInputStream;
import org.verapdf.as.ASAtom;
import org.verapdf.as.filters.io.ASBufferingInFilter;
import org.verapdf.as.io.ASInputStream;
import org.verapdf.cos.COSDictionary;

public class COSFilterLZWDecode
extends ASBufferingInFilter {
    private Logger LOGGER = Logger.getLogger(COSFilterLZWDecode.class.getCanonicalName());
    private static final int CLEAR_TABLE_MARKER = 256;
    private static final int EOD = 257;
    private static final int INITIAL_LZW_TABLE_SIZE = 4096;
    private static final int MAX_LZW_TABLE_SIZE = 4096;
    private static final int BITS_12 = 12;
    private static final int BITS_11 = 11;
    private static final int BITS_10 = 10;
    private static final int BITS_9 = 9;
    private static final int SIZE_THRESHOLD_10_BITS = 512;
    private static final int SIZE_THRESHOLD_11_BITS = 1024;
    private static final int SIZE_THRESHOLD_12_BITS = 2048;
    private MemoryCacheImageInputStream bitStream;
    private List<byte[]> lzwTable;
    private byte[] leftoverData;
    private int codeLengthBits = 9;
    private int earlyChange;
    private long thisWord = -1L;
    private long previousWord = -1L;

    public COSFilterLZWDecode(ASInputStream stream, COSDictionary decodeParams) throws IOException {
        super(stream);
        Long earlyChangeFromDecodeParams = decodeParams.getIntegerKey(ASAtom.EARLY_CHANGE);
        this.earlyChange = earlyChangeFromDecodeParams == null || earlyChangeFromDecodeParams.intValue() != 0 ? 1 : 0;
        this.bitStream = new MemoryCacheImageInputStream(stream);
        this.initLZWTable();
    }

    @Override
    public int read(byte[] buffer, int size) throws IOException {
        int position = 0;
        int actualSize = Math.min(buffer.length, size);
        byte[] nextChunk;
        while ((nextChunk = this.getNextChunk()) != null) {
            if (position + nextChunk.length > actualSize) {
                int toWrite = actualSize - position;
                byte[] newLeftover = new byte[nextChunk.length - toWrite];
                System.arraycopy(nextChunk, 0, buffer, position, toWrite);
                System.arraycopy(nextChunk, toWrite, newLeftover, 0, nextChunk.length - toWrite);
                this.leftoverData = newLeftover;
                return position += toWrite;
            }
            System.arraycopy(nextChunk, 0, buffer, position, nextChunk.length);
            position += nextChunk.length;
        }
        return position == 0 ? -1 : position;
    }

    @Override
    public int skip(int size) throws IOException {
        int read;
        byte[] buf = new byte[2048];
        for (read = this.read(buf, size); read != size; read += this.read(buf, size - read)) {
        }
        return read;
    }

    @Override
    public void reset() throws IOException {
        super.reset();
        this.bitStream = new MemoryCacheImageInputStream(this.getInputStream());
        this.codeLengthBits = 9;
        this.leftoverData = null;
        this.previousWord = -1L;
        this.initLZWTable();
    }

    private byte[] getNextChunk() throws IOException {
        if (this.leftoverData != null) {
            byte[] res = Arrays.copyOf(this.leftoverData, this.leftoverData.length);
            this.leftoverData = null;
            return res;
        }
        try {
            this.thisWord = this.bitStream.readBits(this.codeLengthBits);
            if (this.thisWord == 256L) {
                this.codeLengthBits = 9;
                this.initLZWTable();
                return this.getNextChunk();
            }
            if (this.thisWord == 257L) {
                return null;
            }
            byte[] res = this.getChunkFromLZWTable();
            this.codeLengthBits = this.calculateCodeLength();
            this.previousWord = this.thisWord;
            return res;
        }
        catch (EOFException e) {
            this.LOGGER.log(Level.FINE, "Unexpected end of LZW data.");
            return null;
        }
    }

    private byte[] getChunkFromLZWTable() throws IOException {
        if (this.thisWord < (long)this.lzwTable.size()) {
            byte[] res = this.lzwTable.get((int)this.thisWord);
            if (this.previousWord != -1L) {
                byte[] previous = this.lzwTable.get((int)this.previousWord);
                byte[] newWord = Arrays.copyOf(previous, previous.length + 1);
                newWord[previous.length] = res[0];
                if (this.lzwTable.size() < 4096) {
                    this.lzwTable.add(newWord);
                }
            }
            return res;
        }
        if (this.previousWord == -1L) {
            throw new IOException("Error in decoding LZW: first symbol in message can't be decoded.");
        }
        byte[] previous = this.lzwTable.get((int)this.previousWord);
        byte[] res = Arrays.copyOf(previous, previous.length + 1);
        res[previous.length] = previous[0];
        if (this.lzwTable.size() < 4096) {
            this.lzwTable.add(res);
        }
        return res;
    }

    private int calculateCodeLength() {
        int size = this.lzwTable.size() + this.earlyChange;
        if (size >= 2048) {
            return 12;
        }
        if (size >= 1024) {
            return 11;
        }
        if (size >= 512) {
            return 10;
        }
        return 9;
    }

    private void initLZWTable() {
        this.lzwTable = new ArrayList<byte[]>(4096);
        for (int i = 0; i < 256; ++i) {
            this.lzwTable.add(new byte[]{(byte)i});
        }
        this.lzwTable.add(null);
        this.lzwTable.add(null);
    }
}

