/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.external;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.verapdf.as.ASAtom;
import org.verapdf.as.io.ASInputStream;
import org.verapdf.cos.COSObjType;
import org.verapdf.cos.COSObject;
import org.verapdf.cos.COSStream;
import org.verapdf.factory.colors.ColorSpaceFactory;
import org.verapdf.pd.PDMetadata;
import org.verapdf.pd.PDObject;
import org.verapdf.pd.colors.PDColorSpace;

public class ICCProfile
extends PDObject {
    private static final Logger LOGGER = Logger.getLogger(ICCProfile.class.getCanonicalName());
    public static final int HEADER_LENGTH = 128;
    public static final int TAGINFO_LENGTH = 12;
    public static final int CMM_TYPE_OFFSET = 4;
    public static final int DEVICE_CLASS_OFFSET = 12;
    public static final int COLOR_SPACE_OFFSET = 16;
    public static final int DEVICE_MANUFACTURER_OFFSET = 48;
    public static final int DEVICE_MODEL_OFFSET = 52;
    public static final int RENDERING_INTENT_OFFSET = 64;
    public static final int CREATOR_OFFSET = 80;
    public static final int PROFILE_ID_OFFSET = 84;
    public static final int REQUIRED_LENGTH = 4;
    public static final int PROFILE_ID_LENGTH = 16;
    public static final int VERSION_LENGTH = 3;
    public static final int VERSION_BYTE = 8;
    public static final int SUBVERSION_BYTE = 9;
    private static final int CREATION_YEAR_OFFSET = 24;
    private static final int CREATION_MONTH_OFFSET = 26;
    private static final int CREATION_DAY_OFFSET = 28;
    private static final int CREATION_HOUR_OFFSET = 30;
    private static final int CREATION_MIN_OFFSET = 32;
    private static final int CREATION_SEC_OFFSET = 34;
    private byte[] profileHeader = new byte[0];
    private Calendar creationDate;
    private boolean isLooksValid = true;
    private String description = null;
    private String copyright = null;

    public ICCProfile(COSObject profileStream) {
        super(profileStream);
        this.initializeProfileHeader();
    }

    private void initializeProfileHeader() {
        try (ASInputStream data = this.getObject().getData(COSStream.FilterFlags.DECODE);){
            byte[] temp = new byte[128];
            int count = Math.max(data.read(temp, 128), 0);
            this.profileHeader = count == 128 ? temp : Arrays.copyOf(temp, count);
            this.creationDate = ICCProfile.parseCreationDate(this.profileHeader);
            if (this.profileHeader.length != 128) {
                this.isLooksValid = false;
            }
            this.parseTags(data);
        }
        catch (IOException e) {
            this.isLooksValid = false;
            LOGGER.log(Level.FINE, "Exception during obtaining ICCProfile header", e);
        }
    }

    public boolean isLooksValid() {
        return this.isLooksValid;
    }

    public String getDeviceClass() {
        return this.getSubArrayFromHeader(12, 4);
    }

    public String getColorSpace() {
        return this.getSubArrayFromHeader(16, 4);
    }

    public String getCMMType() {
        return this.getSubArrayFromHeader(4, 4);
    }

    public String getCreator() {
        return this.getSubArrayFromHeader(80, 4);
    }

    public Calendar getCreationDate() {
        return this.creationDate;
    }

    public String getRenderingIntent() {
        String str = this.getSubArrayFromHeader(64, 4);
        if (str == null) {
            return null;
        }
        switch (str) {
            case "\u0000\u0000\u0000\u0000": {
                return "Perceptual";
            }
            case "\u0000\u0000\u0000\u0001": {
                return "Media-Relative Colorimetric";
            }
            case "\u0000\u0000\u0000\u0002": {
                return "Saturation";
            }
            case "\u0000\u0000\u0000\u0003": {
                return "ICC-Absolute Colorimetric";
            }
        }
        return str;
    }

    public String getProfileID() {
        return this.getSubArrayFromHeader(84, 16);
    }

    public String getDeviceModel() {
        return this.getSubArrayFromHeader(52, 4);
    }

    public String getDeviceManufacturer() {
        return this.getSubArrayFromHeader(48, 4);
    }

    private String getSubArrayFromHeader(int start, int length) {
        return ICCProfile.getSubArray(this.profileHeader, start, length);
    }

    private static String getSubArray(byte[] bytes, int start, int length) {
        if (start + length <= bytes.length) {
            byte[] buffer = Arrays.copyOfRange(bytes, start, start + length);
            return new String(buffer);
        }
        LOGGER.log(Level.FINE, "Length of given byte array less than " + (start + length));
        return null;
    }

    public Double getVersion() {
        if (this.profileHeader.length > 9) {
            StringBuilder version = new StringBuilder(3);
            version.append(this.profileHeader[8] & 0xFF).append('.');
            version.append(this.profileHeader[9] >>> 4 & 0xFF);
            return Double.valueOf(version.toString());
        }
        LOGGER.log(Level.FINE, "ICC profile contain less than 10 bytes of data.");
        return null;
    }

    public String getCopyright() {
        return this.copyright;
    }

    public String getDescription() {
        return this.description;
    }

    private static Calendar parseCreationDate(byte[] header) {
        int year = ICCProfile.getCreationPart(header, 24);
        int month = ICCProfile.getCreationPart(header, 26);
        int day = ICCProfile.getCreationPart(header, 28);
        int hour = ICCProfile.getCreationPart(header, 30);
        int min = ICCProfile.getCreationPart(header, 32);
        int sec = ICCProfile.getCreationPart(header, 34);
        if (year != 0 || month != 0 || day != 0 || hour != 0 || min != 0 || sec != 0) {
            GregorianCalendar cal = new GregorianCalendar(TimeZone.getTimeZone("UTC"), Locale.US);
            cal.set(year, month - 1, day, hour, min, sec);
            cal.set(14, 0);
            return cal;
        }
        return null;
    }

    private static int getCreationPart(byte[] header, int off) {
        if (header.length < off + 2) {
            return 0;
        }
        int part = header[off] & 0xFF;
        part <<= 8;
        return part += header[off + 1] & 0xFF;
    }

    private void parseTags(ASInputStream data) throws IOException {
        data.reset();
        int currentOffset = data.skip(128);
        if (currentOffset != 128) {
            return;
        }
        int descOffset = 0;
        int descLength = 0;
        int cprtOffset = 0;
        int cprtLength = 0;
        byte[] temp = new byte[4];
        if ((currentOffset += Math.max(data.read(temp, 4), 0)) != 132) {
            return;
        }
        int tagsNumberRemained = ICCProfile.byteArrayToInt(temp);
        while (tagsNumberRemained-- > 0) {
            int prevOffset = currentOffset;
            currentOffset += Math.max(data.read(temp, 4), 0);
            String tag = new String(temp);
            if (tag.equals("desc")) {
                currentOffset += Math.max(data.read(temp, 4), 0);
                descOffset = ICCProfile.byteArrayToInt(temp);
                currentOffset += Math.max(data.read(temp, 4), 0);
                descLength = ICCProfile.byteArrayToInt(temp);
            } else if (tag.equals("cprt")) {
                currentOffset += Math.max(data.read(temp, 4), 0);
                cprtOffset = ICCProfile.byteArrayToInt(temp);
                currentOffset += Math.max(data.read(temp, 4), 0);
                cprtLength = ICCProfile.byteArrayToInt(temp);
            } else {
                currentOffset += data.skip(8);
            }
            if (currentOffset == prevOffset + 12) continue;
            return;
        }
        if (descLength != 0) {
            this.description = ICCProfile.getTagValue(data, descOffset, descLength, false);
        }
        if (cprtLength != 0) {
            this.copyright = ICCProfile.getTagValue(data, cprtOffset, cprtLength, true);
        }
    }

    private static String getTagValue(ASInputStream data, int tagOffset, int tagLength, boolean isCprt) throws IOException {
        data.reset();
        int currOffset = data.skip(tagOffset);
        if (currOffset != tagOffset) {
            return null;
        }
        byte[] temp = new byte[4];
        if ((currOffset += Math.max(data.read(temp, 4), 0)) != tagOffset + 4) {
            return null;
        }
        String type = new String(temp);
        if ("mluc".equals(type)) {
            int prevOffset = currOffset;
            currOffset += data.skip(4);
            currOffset += Math.max(data.read(temp, 4), 0);
            if ((currOffset += data.skip(4)) != prevOffset + 12) {
                return null;
            }
            int number = ICCProfile.byteArrayToInt(temp);
            for (int i = 0; i < number; ++i) {
                prevOffset = currOffset;
                currOffset += Math.max(data.read(temp, 4), 0);
                String local = ICCProfile.getSubArray(temp, 0, 4);
                if ("enUS".equals(local)) {
                    currOffset += Math.max(data.read(temp, 4), 0);
                    int length = ICCProfile.byteArrayToInt(temp);
                    int offset = ICCProfile.byteArrayToInt(temp);
                    if ((currOffset += Math.max(data.read(temp, 4), 0)) != prevOffset + 12) {
                        return null;
                    }
                    data.reset();
                    currOffset = data.skip(offset);
                    byte[] temporary = new byte[length];
                    if ((currOffset += Math.max(data.read(temporary, length), 0)) == offset + length) {
                        return new String(temporary, StandardCharsets.UTF_16BE).trim();
                    }
                    return null;
                }
                if ((currOffset += data.skip(8)) == prevOffset + 12) continue;
                return null;
            }
        } else if ("desc".equals(type)) {
            int prevOffset = currOffset;
            currOffset += data.skip(4);
            if ((currOffset += Math.max(data.read(temp, 4), 0)) != prevOffset + 8) {
                return null;
            }
            int length = ICCProfile.byteArrayToInt(temp);
            byte[] temporary = new byte[length];
            if ((currOffset += Math.max(data.read(temporary, length), 0)) == prevOffset + 8 + length) {
                return new String(temporary, StandardCharsets.US_ASCII).trim();
            }
        } else if (isCprt) {
            int prevOffset = currOffset;
            int length = tagLength - 4;
            byte[] temporary = new byte[length];
            if ((currOffset += Math.max(data.read(temporary, length), 0)) == prevOffset + length) {
                return new String(temporary, StandardCharsets.US_ASCII).trim();
            }
        }
        return null;
    }

    private static int byteArrayToInt(byte[] b) {
        int value = 0;
        for (int i = 0; i < 4; ++i) {
            int shift = (3 - i) * 8;
            value += (b[i] & 0xFF) << shift;
        }
        return value;
    }

    public Long getNumberOfColorants() {
        return this.getObject().getIntegerKey(ASAtom.N);
    }

    public double[] getRange() {
        COSObject rangeObject = this.getObject().getKey(ASAtom.RANGE);
        if (rangeObject != null && rangeObject.getType() == COSObjType.COS_ARRAY) {
            int size = rangeObject.size();
            Long estimatedSize = this.getNumberOfColorants();
            if (estimatedSize != null && size != estimatedSize.intValue() * 2) {
                LOGGER.log(Level.FINE, "Range array doesn't consist of " + estimatedSize.intValue() * 2 + " elements");
            }
            double[] res = new double[size];
            for (int i = 0; i < size; ++i) {
                COSObject number = rangeObject.at(i);
                if (number == null || number.getReal() == null) {
                    LOGGER.log(Level.FINE, "Range array contains non number value");
                    return null;
                }
                res[i] = number.getReal();
            }
            return res;
        }
        return null;
    }

    public PDColorSpace getAlternate() {
        return ColorSpaceFactory.getColorSpace(this.getKey(ASAtom.ALTERNATE));
    }

    public PDMetadata getMetadata() {
        COSObject metadata = this.getKey(ASAtom.METADATA);
        if (metadata != null && metadata.getType() == COSObjType.COS_STREAM) {
            return new PDMetadata(metadata);
        }
        return null;
    }
}

