/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.io;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import org.verapdf.as.io.ASFileInStream;
import org.verapdf.as.io.ASInputStream;
import org.verapdf.io.SeekableInputStream;

public class InternalInputStream
extends SeekableInputStream {
    private static final String READ_ONLY_MODE = "r";
    private String fileName;
    private RandomAccessFile source;

    public InternalInputStream(File file) throws FileNotFoundException {
        this.source = new RandomAccessFile(file, READ_ONLY_MODE);
    }

    public InternalInputStream(String fileName) throws FileNotFoundException {
        this.fileName = fileName;
        this.source = new RandomAccessFile(fileName, READ_ONLY_MODE);
    }

    public InternalInputStream(InputStream fileStream) throws IOException {
        File tempFile = this.createTempFile(fileStream);
        this.fileName = tempFile.getAbsolutePath();
        this.source = new RandomAccessFile(tempFile, READ_ONLY_MODE);
    }

    public InternalInputStream(byte[] alreadyRead, InputStream stream) throws IOException {
        this.source = new RandomAccessFile(this.createTempFile(alreadyRead, stream), READ_ONLY_MODE);
    }

    @Override
    public int read() throws IOException {
        return this.source.read();
    }

    @Override
    public int read(byte[] buffer, int size) throws IOException {
        return this.source.read(buffer, 0, size);
    }

    @Override
    public int skip(int size) throws IOException {
        return this.source.skipBytes(size);
    }

    @Override
    public void close() throws IOException {
        this.source.close();
    }

    @Override
    public void reset() throws IOException {
        this.source.seek(0L);
    }

    public boolean isCloneable() {
        return false;
    }

    @Override
    public long getOffset() throws IOException {
        return this.source.getFilePointer();
    }

    @Override
    public void seek(long pos) throws IOException {
        this.source.seek(pos);
    }

    @Override
    public int peek() throws IOException {
        if (!this.isEOF()) {
            byte result = this.source.readByte();
            this.unread();
            return result;
        }
        return -1;
    }

    @Override
    public long getStreamLength() throws IOException {
        return this.source.length();
    }

    public String getFileName() {
        return this.fileName;
    }

    public RandomAccessFile getStream() {
        return this.source;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File createTempFile(InputStream input) throws IOException {
        FileOutputStream output = null;
        try {
            int n;
            File tmpFile = File.createTempFile("tmp_pdf_file", ".pdf");
            tmpFile.deleteOnExit();
            output = new FileOutputStream(tmpFile);
            byte[] buffer = new byte[4096];
            while ((n = input.read(buffer)) != -1) {
                output.write(buffer, 0, n);
            }
            File file = tmpFile;
            return file;
        }
        finally {
            input.close();
            if (output != null) {
                output.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File createTempFile(byte[] alreadyRead, InputStream input) throws IOException {
        FileOutputStream output = null;
        try {
            int n;
            File tmpFile = File.createTempFile("tmp_pdf_file", ".pdf");
            tmpFile.deleteOnExit();
            output = new FileOutputStream(tmpFile);
            output.write(alreadyRead);
            byte[] buffer = new byte[2048];
            while ((n = input.read(buffer)) != -1) {
                output.write(buffer, 0, n);
            }
            File file = tmpFile;
            return file;
        }
        finally {
            input.close();
            if (output != null) {
                output.close();
            }
        }
    }

    @Override
    public ASInputStream getStream(long startOffset, long length) {
        return new ASFileInStream(this.source, startOffset, length);
    }
}

