/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.parser;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.verapdf.as.ASAtom;
import org.verapdf.as.filters.io.ASBufferingInFilter;
import org.verapdf.as.io.ASInputStream;
import org.verapdf.cos.COSArray;
import org.verapdf.cos.COSInteger;
import org.verapdf.cos.COSKey;
import org.verapdf.cos.COSObject;
import org.verapdf.cos.COSStream;
import org.verapdf.cos.COSTrailer;
import org.verapdf.cos.xref.COSXRefEntry;
import org.verapdf.cos.xref.COSXRefInfo;

class XrefStreamParser {
    private COSArray index;
    private ASInputStream xrefInputStream;
    private COSArray fieldSizes;
    private List<Long> objIDs;
    private COSXRefInfo section;
    private COSStream xrefCOSStream;

    XrefStreamParser(COSXRefInfo section, COSStream xrefCOSStream) {
        this.section = section;
        this.xrefCOSStream = xrefCOSStream;
    }

    void parseStreamAndTrailer() throws IOException {
        this.xrefInputStream = this.xrefCOSStream.getData(COSStream.FilterFlags.DECODE);
        this.fieldSizes = (COSArray)this.xrefCOSStream.getKey(ASAtom.W).getDirectBase();
        if (this.fieldSizes.size() != 3) {
            throw new IOException("W array in xref should have 3 elements.");
        }
        this.initializeIndex();
        this.initializeObjIDs();
        this.parseStream();
        this.setTrailer();
    }

    private void initializeIndex() throws IOException {
        this.index = (COSArray)this.xrefCOSStream.getKey(ASAtom.INDEX).getDirectBase();
        if (this.index == null) {
            COSObject[] defaultIndex = new COSObject[]{COSInteger.construct(0L), this.xrefCOSStream.getKey(ASAtom.SIZE)};
            this.index = (COSArray)COSArray.construct(2, defaultIndex).getDirectBase();
        } else if (this.index.size() % 2 != 0) {
            throw new IOException("Index array in xref stream has odd amount of elements.");
        }
    }

    private void initializeObjIDs() {
        this.objIDs = new ArrayList<Long>();
        for (int i = 0; i < this.index.size() / 2; ++i) {
            COSInteger firstID = (COSInteger)this.index.at(2 * i).getDirectBase();
            COSInteger lengthOfSubsection = (COSInteger)this.index.at(2 * i + 1).getDirectBase();
            int j = 0;
            while ((long)j < lengthOfSubsection.get()) {
                this.objIDs.add(firstID.get() + (long)j);
                ++j;
            }
        }
    }

    private void parseStream() throws IOException {
        byte[] buffer;
        long read;
        byte[] field0 = new byte[this.fieldSizes.at(0).getInteger().intValue()];
        byte[] field1 = new byte[this.fieldSizes.at(1).getInteger().intValue()];
        byte[] field2 = new byte[this.fieldSizes.at(2).getInteger().intValue()];
        byte[] remainedBytes = new byte[]{};
        int objIdIndex = 0;
        block5: while ((read = (long)this.xrefInputStream.read(buffer = new byte[2048], 2048)) != -1L) {
            buffer = ASBufferingInFilter.concatenate(remainedBytes, remainedBytes.length, buffer, (int)read);
            int pointer = 0;
            while (objIdIndex < this.objIDs.size()) {
                if (pointer + field0.length + field1.length + field2.length > buffer.length) {
                    remainedBytes = Arrays.copyOfRange(buffer, pointer, (int)read);
                    continue block5;
                }
                Long id = this.objIDs.get(objIdIndex);
                System.arraycopy(buffer, pointer, field0, 0, field0.length);
                System.arraycopy(buffer, pointer += field0.length, field1, 0, field1.length);
                System.arraycopy(buffer, pointer += field1.length, field2, 0, field2.length);
                pointer += field2.length;
                int type = 1;
                if (field0.length > 0) {
                    type = (int)this.numberFromBytes(field0);
                }
                switch (type) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        COSXRefEntry xref = new COSXRefEntry();
                        xref.offset = this.numberFromBytes(field1);
                        xref.generation = field2.length > 0 ? (int)this.numberFromBytes(field2) : 0;
                        this.section.getXRefSection().add(new COSKey(id.intValue(), xref.generation), xref.offset);
                        break;
                    }
                    case 2: {
                        COSXRefEntry xref = new COSXRefEntry();
                        xref.offset = -this.numberFromBytes(field1);
                        if (field2.length > 0) {
                            xref.generation = 0;
                        }
                        this.section.getXRefSection().add(new COSKey(id.intValue(), xref.generation), xref.offset);
                        break;
                    }
                    default: {
                        throw new IOException("Error in parsing xref stream");
                    }
                }
                ++objIdIndex;
            }
        }
    }

    private void setTrailer() {
        COSTrailer trailer = this.section.getTrailer();
        if (this.xrefCOSStream.getKey(ASAtom.SIZE).get() != null) {
            trailer.setSize(((COSInteger)this.xrefCOSStream.getKey(ASAtom.SIZE).get()).get());
        }
        if (this.xrefCOSStream.getKey(ASAtom.PREV).get() != null) {
            trailer.setPrev(((COSInteger)this.xrefCOSStream.getKey(ASAtom.PREV).get()).get());
        }
        if (this.xrefCOSStream.getKey(ASAtom.ROOT).get() != null) {
            trailer.setRoot(this.xrefCOSStream.getKey(ASAtom.ROOT));
        }
        if (this.xrefCOSStream.getKey(ASAtom.ENCRYPT).get() != null) {
            trailer.setEncrypt(this.xrefCOSStream.getKey(ASAtom.ENCRYPT));
        }
        if (this.xrefCOSStream.getKey(ASAtom.INFO).get() != null) {
            trailer.setInfo(this.xrefCOSStream.getKey(ASAtom.INFO));
        }
        if (this.xrefCOSStream.getKey(ASAtom.ID).get() != null) {
            trailer.setID(this.xrefCOSStream.getKey(ASAtom.ID));
        }
    }

    private long numberFromBytes(byte[] num) {
        long res = 0L;
        for (int i = 0; i < num.length; ++i) {
            res += (long)((num[i] & 0xFF) << (num.length - i - 1) * 8);
        }
        return res;
    }
}

