/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.pd.font;

import java.util.HashMap;
import java.util.Map;
import org.verapdf.as.ASAtom;
import org.verapdf.pd.font.truetype.TrueTypePredefined;

public class Encoding {
    private static final String NOTDEF = ".notdef";
    private String[] predefinedEncoding;
    private Map<Integer, String> differences;

    public Encoding(ASAtom predefinedEncoding) {
        this.predefinedEncoding = predefinedEncoding == ASAtom.MAC_ROMAN_ENCODING ? TrueTypePredefined.MAC_ROMAN_ENCODING : (predefinedEncoding == ASAtom.MAC_EXPERT_ENCODING ? TrueTypePredefined.MAC_EXPERT_ENCODING : (predefinedEncoding == ASAtom.WIN_ANSI_ENCODING ? TrueTypePredefined.WIN_ANSI_ENCODING : new String[0]));
    }

    public Encoding(ASAtom baseEncoding, Map<Integer, String> differences) {
        this(baseEncoding);
        this.differences = differences != null ? differences : new HashMap<Integer, String>();
    }

    public String getName(int code) {
        if (this.differences == null) {
            if (code < this.predefinedEncoding.length) {
                return this.predefinedEncoding[code];
            }
            return this.predefinedEncoding[0];
        }
        String diffRes = this.differences.get(code);
        if (diffRes == null) {
            diffRes = code < this.predefinedEncoding.length ? this.predefinedEncoding[code] : NOTDEF;
        }
        return diffRes;
    }
}

