/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.pd.font;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.verapdf.as.ASAtom;
import org.verapdf.cos.COSBase;
import org.verapdf.cos.COSObjType;
import org.verapdf.cos.COSObject;
import org.verapdf.cos.COSStream;
import org.verapdf.pd.PDObject;

public class PDFontDescriptor
extends PDObject {
    private static final Logger LOGGER = Logger.getLogger(PDFontDescriptor.class.getCanonicalName());
    private final Long flags = this.getFlags();
    private final String fontName;
    private static final int FIXED_PITCH_BIT = 1;
    private static final int SERIF_BIT = 2;
    private static final int SYMBOLIC_BIT = 3;
    private static final int SCRIPT_BIT = 4;
    private static final int NONSYMBOLIC_BIT = 6;
    private static final int ITALIC_BIT = 7;
    private static final int ALL_CAP_BIT = 17;
    private static final int SMALL_CAP_BIT = 18;
    private static final int FORCE_BOLD_BIT = 19;
    private static final Double DEFAULT_LEADING = new Double(0.0);
    private static final Double DEFAULT_XHEIGHT = new Double(0.0);
    private static final Double DEFAULT_STEM_H = new Double(0.0);
    private static final Double DEFAULT_WIDTH = new Double(0.0);

    public PDFontDescriptor(COSObject obj) {
        super(obj);
        String string = this.fontName = this.getFontName() == null ? "" : this.getFontName().getValue();
        if (this.flags == null) {
            LOGGER.log(Level.FINE, "Font descriptor for font " + this.fontName + " doesn't contain flags.");
        }
    }

    public Long getFlags() {
        return this.getIntegerKey(ASAtom.FLAGS);
    }

    public ASAtom getFontName() {
        return this.getNameKey(ASAtom.FONT_NAME);
    }

    public String getFontFamily() {
        return this.getStringKey(ASAtom.FONT_FAMILY);
    }

    public ASAtom getFontStretch() {
        return this.getNameKey(ASAtom.FONT_STRETCH);
    }

    public Double getFontWeight() {
        return this.getRealKey(ASAtom.FONT_WEIGHT);
    }

    public boolean isFixedPitch() {
        return this.isFlagBitOn(1);
    }

    public boolean isSerif() {
        return this.isFlagBitOn(2);
    }

    public boolean isSymbolic() {
        return this.isFlagBitOn(3);
    }

    public boolean isScript() {
        return this.isFlagBitOn(4);
    }

    public boolean isNonsymbolic() {
        return this.isFlagBitOn(6);
    }

    public boolean isItalic() {
        return this.isFlagBitOn(7);
    }

    public boolean isAllCap() {
        return this.isFlagBitOn(17);
    }

    public boolean isSmallCap() {
        return this.isFlagBitOn(18);
    }

    public boolean isForceBold() {
        return this.isFlagBitOn(19);
    }

    private boolean isFlagBitOn(int bit) {
        return this.flags != null && (this.flags.intValue() & 1 << bit - 1) != 0;
    }

    public double[] getFontBoundingBox() {
        COSBase bbox = this.getObject().getKey(ASAtom.FONT_BBOX).get();
        if (bbox.getType() == COSObjType.COS_ARRAY || bbox.size() == 4) {
            double[] res = new double[4];
            for (int i = 0; i < 4; ++i) {
                COSObject obj = bbox.at(i);
                if (!obj.getType().isNumber()) {
                    LOGGER.log(Level.FINE, "Font bounding box array for font " + this.fontName + " contains " + (Object)((Object)obj.getType()));
                    return null;
                }
                res[i] = obj.getReal();
            }
            return res;
        }
        LOGGER.log(Level.FINE, "Font bounding box array for font " + this.fontName + " is not an array of 4 elements");
        return null;
    }

    public Double getItalicAngle() {
        return this.getRealKey(ASAtom.ITALIC_ANGLE);
    }

    public Double getAscent() {
        return this.getRealKey(ASAtom.ASCENT);
    }

    public Double getDescent() {
        return this.getRealKey(ASAtom.DESCENT);
    }

    public Double getLeading() {
        Double res = this.getRealKey(ASAtom.LEADING);
        return res == null ? DEFAULT_LEADING : res;
    }

    public Double getCapHeight() {
        return this.getRealKey(ASAtom.CAP_HEIGHT);
    }

    public Double getXHeight() {
        Double res = this.getRealKey(ASAtom.XHEIGHT);
        return res == null ? DEFAULT_XHEIGHT : res;
    }

    public Double getStemV() {
        return this.getRealKey(ASAtom.STEM_V);
    }

    public Double getStemH() {
        Double res = this.getRealKey(ASAtom.STEM_H);
        return res == null ? DEFAULT_STEM_H : res;
    }

    public Double getAvgWidth() {
        Double res = this.getRealKey(ASAtom.AVG_WIDTH);
        return res == null ? DEFAULT_WIDTH : res;
    }

    public Double getMaxWidth() {
        Double res = this.getRealKey(ASAtom.MAX_WIDTH);
        return res == null ? DEFAULT_WIDTH : res;
    }

    public Double getMissingWidth() {
        Double res = this.getRealKey(ASAtom.MISSING_WIDTH);
        return res == null ? DEFAULT_WIDTH : res;
    }

    public String getCharSet() {
        return this.getStringKey(ASAtom.CHAR_SET);
    }

    public COSStream getFontFile() {
        return this.getCOSStreamWithCheck(ASAtom.FONT_FILE);
    }

    public COSStream getFontFile2() {
        return this.getCOSStreamWithCheck(ASAtom.FONT_FILE2);
    }

    public COSStream getFontFile3() {
        return this.getCOSStreamWithCheck(ASAtom.FONT_FILE3);
    }

    public boolean canParseFontFile(ASAtom key) {
        return this.knownKey(key) && this.getCOSStreamWithCheck(key) != null;
    }

    private COSStream getCOSStreamWithCheck(ASAtom key) {
        COSObject res = this.getKey(key);
        if (res.getType() == COSObjType.COS_STREAM) {
            return (COSStream)res.getDirectBase();
        }
        return null;
    }
}

