/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.pd.font.opentype;

import java.io.IOException;
import org.verapdf.as.io.ASInputStream;
import org.verapdf.cos.COSObject;
import org.verapdf.io.SeekableInputStream;
import org.verapdf.pd.font.FontProgram;
import org.verapdf.pd.font.PDFont;
import org.verapdf.pd.font.cff.CFFFontProgram;
import org.verapdf.pd.font.cmap.CMap;
import org.verapdf.pd.font.truetype.TrueTypeFontProgram;

public class OpenTypeFontProgram
implements FontProgram {
    private static final long CFF = 1128678944L;
    private boolean isCFF;
    private boolean isSymbolic;
    private boolean isSubset;
    private COSObject encoding;
    private ASInputStream source;
    private FontProgram font;
    private int numTables;
    private boolean attemptedParsing = false;
    private boolean successfullyParsed = false;
    private CMap externalCMap;

    public OpenTypeFontProgram(ASInputStream source, boolean isCFF, boolean isSymbolic, COSObject encoding, CMap externalCMap, boolean isSubset) {
        this.source = source;
        this.isCFF = isCFF;
        this.isSymbolic = isSymbolic;
        this.encoding = encoding;
        this.externalCMap = externalCMap;
        this.isSubset = isSubset;
    }

    @Override
    public float getWidth(int code) {
        return this.font.getWidth(code);
    }

    @Override
    public float getWidth(String glyphName) {
        return this.font.getWidth(glyphName);
    }

    @Override
    public boolean containsCode(int code) {
        return this.font.containsCode(code);
    }

    @Override
    public boolean isAttemptedParsing() {
        return this.attemptedParsing;
    }

    @Override
    public boolean isSuccessfulParsing() {
        return this.successfullyParsed;
    }

    @Override
    public void parseFont() throws IOException {
        if (!this.attemptedParsing) {
            this.attemptedParsing = true;
            if (!this.isCFF) {
                this.font = new TrueTypeFontProgram(this.source, this.isSymbolic, this.encoding);
                this.font.parseFont();
            } else {
                this.font = new CFFFontProgram(this.getCFFTable(), PDFont.getEncodingMappingFromCOSObject(this.encoding), this.externalCMap, this.isSubset);
                this.font.parseFont();
            }
            this.successfullyParsed = true;
        }
    }

    public FontProgram getFont() {
        return this.font;
    }

    private ASInputStream getCFFTable() throws IOException {
        this.source = SeekableInputStream.getSeekableStream(this.source);
        this.readHeader();
        for (int i = 0; i < this.numTables; ++i) {
            long tabName = this.readULong();
            this.readULong();
            long offset = this.readULong();
            long length = this.readULong();
            if (tabName != 1128678944L) continue;
            return ((SeekableInputStream)this.source).getStream(offset, length);
        }
        throw new IOException("Can't locate \"CFF \" table in CFF OpenType font program.");
    }

    private void readHeader() throws IOException {
        this.source.skip(4);
        this.numTables = this.readUShort();
        this.source.skip(6);
    }

    private int readUShort() throws IOException {
        int highOrder = (this.source.read() & 0xFF) << 8;
        return highOrder | this.source.read() & 0xFF;
    }

    private long readULong() throws IOException {
        long res = this.readUShort();
        return (res <<= 16) | (long)this.readUShort();
    }
}

