/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.pd.font.stdmetrics;

import java.io.IOException;
import org.verapdf.as.io.ASInputStream;
import org.verapdf.parser.BaseParser;
import org.verapdf.parser.Token;
import org.verapdf.pd.font.stdmetrics.StandardFontMetrics;

public class AFMParser
extends BaseParser {
    private static final String START_CHAR_METRICS_STRING = "StartCharMetrics";
    private String fontName;
    private int nGlyphs;

    public AFMParser(ASInputStream asInputStream, String fontName) throws IOException {
        super(asInputStream);
        this.fontName = fontName;
    }

    public StandardFontMetrics parse() throws IOException {
        StandardFontMetrics res = new StandardFontMetrics();
        this.initializeToken();
        this.findStartCharMetrics();
        this.nextToken();
        if (this.getToken().type == Token.Type.TT_INTEGER) {
            this.nGlyphs = (int)this.getToken().integer;
            for (int i = 0; i < this.nGlyphs; ++i) {
                this.readMetricsLine(res);
            }
        } else {
            throw new IOException("Can't parse font metrics for predefined font " + this.fontName);
        }
        return res;
    }

    private void findStartCharMetrics() throws IOException {
        do {
            this.nextToken();
        } while (this.getToken().type != Token.Type.TT_EOF && !this.getToken().getValue().equals(START_CHAR_METRICS_STRING));
        if (this.getToken().type == Token.Type.TT_EOF) {
            throw new IOException("Can't parse font metrics for predefined font " + this.fontName);
        }
    }

    private void readMetricsLine(StandardFontMetrics sfm) throws IOException {
        this.nextToken();
        this.nextToken();
        this.nextToken();
        this.nextToken();
        this.nextToken();
        int width = (int)this.getToken().integer;
        this.nextToken();
        this.nextToken();
        this.nextToken();
        sfm.putWidth(this.getToken().getValue(), width);
        for (int i = 0; i < 7; ++i) {
            this.nextToken();
        }
    }
}

