/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.pd.font.truetype;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.verapdf.as.ASAtom;
import org.verapdf.cos.COSDictionary;
import org.verapdf.cos.COSStream;
import org.verapdf.pd.font.FontProgram;
import org.verapdf.pd.font.PDSimpleFont;
import org.verapdf.pd.font.opentype.OpenTypeFontProgram;
import org.verapdf.pd.font.truetype.TrueTypeFontProgram;

public class PDTrueTypeFont
extends PDSimpleFont {
    private static final Logger LOGGER = Logger.getLogger(PDTrueTypeFont.class.getCanonicalName());

    public PDTrueTypeFont(COSDictionary dictionary) {
        super(dictionary);
    }

    @Override
    public FontProgram getFontProgram() {
        if (this.isFontParsed) {
            return this.fontProgram;
        }
        this.isFontParsed = true;
        try {
            COSStream trueTypeFontFile;
            ASAtom subtype;
            if (this.fontDescriptor.canParseFontFile(ASAtom.FONT_FILE2)) {
                COSStream trueTypeFontFile2 = this.fontDescriptor.getFontFile2();
                this.fontProgram = new TrueTypeFontProgram(trueTypeFontFile2.getData(COSStream.FilterFlags.DECODE), this.isSymbolic(), this.getEncoding());
                return this.fontProgram;
            }
            if (this.fontDescriptor.canParseFontFile(ASAtom.FONT_FILE3) && (subtype = (trueTypeFontFile = this.fontDescriptor.getFontFile3()).getNameKey(ASAtom.SUBTYPE)) == ASAtom.OPEN_TYPE) {
                this.fontProgram = new OpenTypeFontProgram(trueTypeFontFile.getData(COSStream.FilterFlags.DECODE), false, this.isSymbolic(), this.getEncoding(), null, this.isSubset());
                return this.fontProgram;
            }
        }
        catch (IOException e) {
            LOGGER.log(Level.FINE, "Can't read TrueType font program.", e);
        }
        this.fontProgram = null;
        return null;
    }
}

