/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.pd.font.truetype;

import java.io.IOException;
import org.verapdf.as.ASAtom;
import org.verapdf.as.io.ASInputStream;
import org.verapdf.cos.COSArray;
import org.verapdf.cos.COSDictionary;
import org.verapdf.cos.COSObjType;
import org.verapdf.cos.COSObject;
import org.verapdf.pd.font.FontProgram;
import org.verapdf.pd.font.truetype.AdobeGlyphList;
import org.verapdf.pd.font.truetype.BaseTrueTypeProgram;
import org.verapdf.pd.font.truetype.TrueTypeCmapSubtable;
import org.verapdf.pd.font.truetype.TrueTypePredefined;

public class TrueTypeFontProgram
extends BaseTrueTypeProgram
implements FontProgram {
    private COSObject encoding;
    protected boolean isSymbolic;

    public TrueTypeFontProgram(ASInputStream stream, boolean isSymbolic, COSObject encoding) throws IOException {
        super(stream);
        this.isSymbolic = isSymbolic;
        if (encoding != null) {
            this.encoding = encoding;
        }
    }

    @Override
    public void parseFont() throws IOException {
        super.parseFont();
        if (!this.isSymbolic) {
            this.createCIDToNameTable();
        }
    }

    @Override
    public boolean containsCode(int code) {
        if (!this.isSymbolic) {
            String glyph = this.encodingMappingArray != null && code < this.encodingMappingArray.length ? this.encodingMappingArray[code] : ".notdef";
            if (".notdef".equals(glyph)) {
                return false;
            }
            AdobeGlyphList.AGLUnicode unicode = AdobeGlyphList.get(glyph);
            TrueTypeCmapSubtable cmap31 = this.parser.getCmapTable(3, 1);
            if (cmap31 != null && cmap31.getGlyph(unicode.getSymbolCode()) != 0) {
                return true;
            }
            TrueTypeCmapSubtable cmap10 = this.parser.getCmapTable(1, 0);
            if (cmap10 != null) {
                int charCode = TrueTypePredefined.MAC_OS_ROMAN_ENCODING_MAP.get(glyph);
                return cmap10.getGlyph(charCode) != 0;
            }
        } else {
            int gid = this.getGIDFrom30(code);
            if (gid != 0) {
                return true;
            }
            TrueTypeCmapSubtable cmap10 = this.parser.getCmapTable(1, 0);
            if (cmap10 != null) {
                return cmap10.getGlyph(code) != 0;
            }
        }
        return false;
    }

    @Override
    public float getWidth(int code) {
        if (this.isSymbolic) {
            return this.getWidthSymbolic(code);
        }
        if (this.encodingMappingArray == null) {
            int gid = this.parser.getCmapParser().getGID(code);
            return this.getWidthWithCheck(gid);
        }
        if (code < 256) {
            String glyphName = this.encodingMappingArray[code];
            return this.getWidth(glyphName);
        }
        return this.getWidth(".notdef");
    }

    @Override
    public float getWidth(String glyphName) {
        AdobeGlyphList.AGLUnicode unicode;
        int gid;
        if (this.isSymbolic) {
            return -1.0f;
        }
        if (".notdef".equals(glyphName)) {
            int gid2 = this.parser.getPostParser().getGID(glyphName);
            return this.getWidthWithCheck(gid2);
        }
        TrueTypeCmapSubtable cmap31 = this.parser.getCmapTable(3, 1);
        if (cmap31 != null && (gid = cmap31.getGlyph((unicode = AdobeGlyphList.get(glyphName)).getSymbolCode())) != 0) {
            return this.getWidthWithCheck(gid);
        }
        TrueTypeCmapSubtable cmap10 = this.parser.getCmapTable(1, 0);
        if (cmap10 != null) {
            Integer charCode = TrueTypePredefined.MAC_OS_ROMAN_ENCODING_MAP.get(glyphName);
            int gid3 = charCode == null ? 0 : cmap10.getGlyph(charCode);
            return this.getWidthWithCheck(gid3);
        }
        return -1.0f;
    }

    public boolean isSymbolic() {
        return this.isSymbolic;
    }

    private float getWidthSymbolic(int code) {
        int gid = this.getGIDFrom30(code);
        if (gid != 0) {
            return this.getWidthWithCheck(gid);
        }
        TrueTypeCmapSubtable cmap10 = this.parser.getCmapTable(1, 0);
        if (cmap10 != null) {
            gid = cmap10.getGlyph(code);
            return this.getWidthWithCheck(gid);
        }
        return -1.0f;
    }

    private int getGIDFrom30(int code) {
        int sampleCode;
        int highByteMask;
        TrueTypeCmapSubtable cmap30 = this.parser.getCmapTable(3, 0);
        if (cmap30 != null && ((highByteMask = (sampleCode = cmap30.getSampleCharCode()) & 0xFF00) == 0 || highByteMask == 61440 || highByteMask == 61696 || highByteMask == 61952)) {
            int gid = cmap30.getGlyph(highByteMask & code);
            return gid;
        }
        return 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void createCIDToNameTable() throws IOException {
        this.encodingMappingArray = new String[256];
        if (this.encoding.getType() == COSObjType.COS_NAME) {
            if (ASAtom.MAC_ROMAN_ENCODING.getValue().equals(this.encoding.getString())) {
                System.arraycopy(TrueTypePredefined.MAC_ROMAN_ENCODING, 0, this.encodingMappingArray, 0, 256);
                return;
            } else {
                if (!ASAtom.WIN_ANSI_ENCODING.getValue().equals(this.encoding.getString())) throw new IOException("Error in reading /Encoding entry in font dictionary");
                System.arraycopy(TrueTypePredefined.WIN_ANSI_ENCODING, 0, this.encodingMappingArray, 0, 256);
            }
            return;
        } else {
            if (this.encoding.getType() != COSObjType.COS_DICT) throw new IOException("Error in reading /Encoding entry in font dictionary");
            this.createCIDToNameTableFromDict((COSDictionary)this.encoding.getDirectBase());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void createCIDToNameTableFromDict(COSDictionary encoding) throws IOException {
        if (encoding.knownKey(ASAtom.BASE_ENCODING).booleanValue()) {
            ASAtom baseEncoding = encoding.getNameKey(ASAtom.BASE_ENCODING);
            if (ASAtom.WIN_ANSI_ENCODING.equals(baseEncoding)) {
                System.arraycopy(TrueTypePredefined.WIN_ANSI_ENCODING, 0, this.encodingMappingArray, 0, 256);
            } else if (ASAtom.MAC_ROMAN_ENCODING.equals(baseEncoding)) {
                System.arraycopy(TrueTypePredefined.MAC_ROMAN_ENCODING, 0, this.encodingMappingArray, 0, 256);
            } else {
                if (!ASAtom.getASAtom("MacExpertEncoding").equals(baseEncoding)) throw new IOException("Error in reading /Encoding entry in font dictionary");
                System.arraycopy(TrueTypePredefined.MAC_EXPERT_ENCODING, 0, this.encodingMappingArray, 0, 256);
            }
        } else {
            System.arraycopy(TrueTypePredefined.STANDARD_ENCODING, 0, this.encodingMappingArray, 0, 256);
        }
        COSArray differences = (COSArray)encoding.getKey(ASAtom.DIFFERENCES).getDirectBase();
        if (differences != null) {
            this.applyDiffsToEncoding(differences);
        }
        for (int i = 0; i < 256; ++i) {
            if (!".notdef".equals(this.encodingMappingArray[i])) continue;
            this.encodingMappingArray[i] = TrueTypePredefined.STANDARD_ENCODING[i];
        }
    }

    private void applyDiffsToEncoding(COSArray differences) throws IOException {
        int diffIndex = -1;
        for (COSObject obj : differences) {
            if (obj.getType() == COSObjType.COS_INTEGER) {
                diffIndex = obj.getInteger().intValue();
                continue;
            }
            if (obj.getType() == COSObjType.COS_NAME && diffIndex != -1) {
                this.encodingMappingArray[diffIndex++] = obj.getString();
                continue;
            }
            throw new IOException("Error in reading /Encoding entry in font dictionary");
        }
    }
}

