/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.pd.font.type1;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.verapdf.as.io.ASInputStream;
import org.verapdf.cos.COSObject;
import org.verapdf.parser.COSParser;
import org.verapdf.parser.Token;
import org.verapdf.pd.font.Encoding;
import org.verapdf.pd.font.FontProgram;
import org.verapdf.pd.font.truetype.TrueTypePredefined;
import org.verapdf.pd.font.type1.EexecFilterDecode;
import org.verapdf.pd.font.type1.Type1PrivateParser;

public class Type1FontProgram
extends COSParser
implements FontProgram {
    public static final Logger LOGGER = Logger.getLogger(Type1FontProgram.class.getCanonicalName());
    static final double[] DEFAULT_FONT_MATRIX = new double[]{0.001, 0.0, 0.0, 0.001, 0.0, 0.0};
    private Encoding pdfEncoding;
    private double[] fontMatrix = DEFAULT_FONT_MATRIX;
    private String[] encoding = new String[256];
    private Map<String, Integer> glyphWidths;
    private static final byte[] CLEAR_TO_MARK_BYTES = "cleartomark".getBytes();
    private boolean attemptedParsing = false;
    private boolean successfullyParsed = false;

    public Type1FontProgram(String fileName) throws IOException {
        super(fileName);
    }

    public Type1FontProgram(InputStream fileStream, Encoding pdfEncoding) throws IOException {
        super(fileStream);
        this.pdfEncoding = pdfEncoding;
    }

    @Override
    public void parseFont() throws IOException {
        if (!this.attemptedParsing) {
            this.attemptedParsing = true;
            this.initializeToken();
            this.skipSpaces(true);
            while (this.getToken().type != Token.Type.TT_EOF) {
                this.nextToken();
                this.processToken();
            }
            if (this.glyphWidths == null) {
                throw new IOException("Type 1 font doesn't contain charstrings.");
            }
            this.successfullyParsed = true;
        }
    }

    private void processToken() throws IOException {
        block26: {
            block0 : switch (this.getToken().type) {
                case TT_NAME: {
                    block8 : switch (this.getToken().getValue()) {
                        case "FontMatrix": {
                            this.skipSpaces();
                            this.nextToken();
                            if (this.getToken().type == Token.Type.TT_OPENARRAY) {
                                this.source.unread();
                                COSObject cosFontMatrix = this.nextObject();
                                if (cosFontMatrix.size() != 6) break block0;
                                for (int i = 0; i < 6; ++i) {
                                    this.fontMatrix[i] = cosFontMatrix.at(i).getReal();
                                }
                                break block0;
                            }
                            break block26;
                        }
                        case "Encoding": {
                            if (this.isEncodingName()) break;
                            do {
                                this.nextToken();
                            } while (!this.getToken().getValue().equals("dup") && this.getToken().type != Token.Type.TT_EOF);
                            if (this.getToken().type == Token.Type.TT_EOF) {
                                throw new IOException("Can't parse Type 1 font program");
                            }
                            this.source.unread(3);
                            while (true) {
                                this.nextToken();
                                if (this.getToken().getValue().equals("readonly")) break block8;
                                if (this.getToken().type == Token.Type.TT_EOF) {
                                    throw new IOException("Can't parse Type 1 font program");
                                }
                                this.skipSpaces();
                                this.readNumber();
                                long key = this.getToken().integer;
                                this.nextToken();
                                if (key < 256L) {
                                    this.encoding[(int)key] = this.getToken().getValue();
                                } else {
                                    LOGGER.log(Level.FINE, "Found glyph with encoding " + key + " in Type 1 font, value less than 256 expected.");
                                }
                                this.nextToken();
                            }
                        }
                    }
                    break;
                }
                case TT_KEYWORD: {
                    switch (this.getToken().getValue()) {
                        case "eexec": {
                            this.skipSpaces();
                            long clearToMarkOffset = this.findOffsetCleartomark();
                            ASInputStream eexecEncoded = this.source.getStream(this.source.getOffset(), clearToMarkOffset - this.source.getOffset());
                            EexecFilterDecode eexecDecoded = new EexecFilterDecode(eexecEncoded, false);
                            Type1PrivateParser parser = new Type1PrivateParser(eexecDecoded, this.fontMatrix);
                            parser.parse();
                            this.glyphWidths = parser.getGlyphWidths();
                            this.source.seek(clearToMarkOffset);
                        }
                    }
                    break;
                }
            }
        }
    }

    private long findOffsetCleartomark() throws IOException {
        long startingOffset = this.source.getOffset();
        int length = CLEAR_TO_MARK_BYTES.length;
        this.source.seek(this.source.getStreamLength() - (long)length);
        byte[] buf = new byte[length];
        this.source.read(buf, length);
        while (!Arrays.equals(buf, CLEAR_TO_MARK_BYTES)) {
            this.source.unread(length + 1);
            this.source.read(buf, length);
        }
        long res = this.source.getOffset() - (long)length;
        this.source.seek(startingOffset);
        return res - 512L;
    }

    @Override
    public float getWidth(int charCode) {
        try {
            Integer res;
            if (this.glyphWidths != null && (res = this.glyphWidths.get(this.getGlyph(charCode))) != null) {
                return res.intValue();
            }
            return -1.0f;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return -1.0f;
        }
    }

    @Override
    public float getWidth(String glyphName) {
        Integer res = this.glyphWidths.get(glyphName);
        return res == null ? -1.0f : (float)res.intValue();
    }

    @Override
    public boolean containsCode(int code) {
        String glyphName = this.getGlyph(code);
        return this.glyphWidths != null && this.glyphWidths.keySet().contains(glyphName);
    }

    @Override
    public boolean isAttemptedParsing() {
        return this.attemptedParsing;
    }

    @Override
    public boolean isSuccessfulParsing() {
        return this.successfullyParsed;
    }

    public String[] getEncoding() {
        return this.encoding;
    }

    public String[] getCharSet() {
        Set<String> charSet = this.glyphWidths.keySet();
        return charSet.toArray(new String[charSet.size()]);
    }

    private boolean isEncodingName() throws IOException {
        long startOffset = this.source.getOffset();
        this.nextToken();
        String possibleEncodingName = this.getToken().getValue();
        this.nextToken();
        if ("def".equals(this.getToken().getValue())) {
            if ("StandardEncoding".equals(possibleEncodingName)) {
                this.encoding = TrueTypePredefined.STANDARD_ENCODING;
                this.source.seek(startOffset);
                return true;
            }
            throw new IOException("Can't get encoding " + possibleEncodingName + " as internal encoding of type 1 font program.");
        }
        this.source.seek(startOffset);
        return false;
    }

    private String getGlyph(int code) {
        if (this.pdfEncoding == null) {
            return this.encoding[code];
        }
        return this.pdfEncoding.getName(code);
    }
}

