/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.parser;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import org.verapdf.as.io.ASInputStream;
import org.verapdf.io.InternalInputStream;
import org.verapdf.io.SeekableInputStream;
import org.verapdf.parser.BaseParser;
import org.verapdf.parser.Token;

public class SeekableBaseParser
extends BaseParser {
    public SeekableBaseParser(SeekableInputStream stream) throws IOException {
        if (stream == null) {
            throw new IOException("Can't create SeekableStream, passed seekableStream is null");
        }
        this.source = stream;
    }

    public SeekableBaseParser(String fileName) throws IOException {
        if (fileName == null) {
            throw new FileNotFoundException("Can't create SeekableStream from file, filename is null");
        }
        this.source = new InternalInputStream(fileName);
    }

    public SeekableBaseParser(InputStream fileStream) throws IOException {
        if (fileStream == null) {
            throw new IOException("Can't create SeekableStream, fileStream is null");
        }
        if (fileStream instanceof SeekableInputStream) {
            this.source = (SeekableInputStream)fileStream;
        } else {
            try {
                this.source = SeekableInputStream.getSeekableStream(fileStream);
            }
            finally {
                fileStream.close();
            }
        }
    }

    public void closeInputStream() throws IOException {
        this.source.close();
    }

    protected String getLine(int offset) throws IOException {
        this.initializeToken();
        this.token.clearValue();
        this.getSource().seek(offset);
        byte ch = this.source.readByte();
        while (!this.source.isEOF() && ch != 10 && ch != 13) {
            this.appendToToken(ch);
            ch = this.source.readByte();
        }
        return this.token.getValue();
    }

    @Override
    protected boolean findKeyword(Token.Keyword keyword, int lookUpSize) throws IOException {
        long endOffset = Math.min(this.getSource().getOffset() + (long)lookUpSize, this.getSource().getStreamLength());
        this.nextToken();
        while (this.token.type != Token.Type.TT_EOF && (this.token.type != Token.Type.TT_KEYWORD || this.token.keyword != keyword) && this.getSource().getOffset() < endOffset) {
            this.nextToken();
        }
        return this.token.type == Token.Type.TT_KEYWORD && this.token.keyword == keyword;
    }

    public ASInputStream getRandomAccess(long length) throws IOException {
        ASInputStream result = this.getSource().getStream(this.getSource().getOffset(), length);
        this.getSource().seekFromCurrentPosition(length);
        return result;
    }

    protected boolean isNextByteEOL() throws IOException {
        byte c = (byte)this.source.peek();
        return SeekableBaseParser.isLF(c) || SeekableBaseParser.isCR(c);
    }

    protected void skipSingleEol() throws IOException {
        byte c = this.source.readByte();
        if (SeekableBaseParser.isCR(c)) {
            c = this.source.readByte();
            if (!SeekableBaseParser.isLF(c)) {
                this.source.unread();
            }
        } else if (!SeekableBaseParser.isLF(c)) {
            this.source.unread();
        }
    }

    protected void skipSingleSpace() throws IOException {
        this.skipSingleSpace(false);
    }

    protected static boolean isHexDigit(byte ch) {
        return SeekableBaseParser.isDigit(ch) || ch >= 97 && ch <= 102 || ch >= 65 && ch <= 70;
    }

    private void skipEOL() throws IOException {
        byte ch = this.source.readByte();
        if (SeekableBaseParser.isLF(ch)) {
            return;
        }
        if (SeekableBaseParser.isCR(ch) && SeekableBaseParser.isLF(ch = this.source.readByte())) {
            return;
        }
        this.source.unread();
    }

    @Override
    protected void skipComment() throws IOException {
        while (!this.source.isEOF()) {
            byte ch = this.source.readByte();
            if (!this.isEOL(ch)) continue;
            return;
        }
    }

    protected void nextLine() throws IOException {
        while (!this.source.isEOF()) {
            byte ch = this.source.readByte();
            if (!this.isEOL(ch)) continue;
            this.skipEOL();
            return;
        }
    }

    protected boolean isEOL(byte ch) throws IOException {
        if (SeekableBaseParser.isLF(ch)) {
            return true;
        }
        if (SeekableBaseParser.isCR(ch)) {
            ch = this.source.readByte();
            if (!SeekableBaseParser.isLF(ch)) {
                this.source.unread();
            }
            return true;
        }
        return false;
    }

    @Override
    protected void readASCII85() throws IOException {
        long ascii85Start = this.getSource().getOffset();
        long ascii85End = this.getSource().getStreamLength();
        byte b = this.source.readByte();
        while (!this.source.isEOF()) {
            if (b == 126 && this.source.peek() == 62) {
                ascii85End = this.getSource().getOffset() - 1L;
                this.source.readByte();
                break;
            }
            b = this.source.readByte();
        }
        try (ASInputStream ascii85 = this.getSource().getStream(ascii85Start, ascii85End - ascii85Start);){
            this.decodeASCII85(ascii85, (int)(ascii85End - ascii85Start));
        }
    }

    public static byte[] getRawBytes(String string) {
        byte[] res = new byte[string.length()];
        for (int i = 0; i < string.length(); ++i) {
            res[i] = (byte)string.charAt(i);
        }
        return res;
    }

    protected void skipExpectedCharacter(char exp) throws IOException {
        char c = (char)this.source.readByte();
        if (c != exp) {
            throw new IOException(this.getErrorMessage("Unexpected character: expected " + exp + " but got " + c, this.getSource().getCurrentOffset() - 1L));
        }
    }

    @Override
    protected String getErrorMessage(String message) {
        return this.getErrorMessage(message, this.getSource().getCurrentOffset());
    }

    protected String getErrorMessage(String message, long offset) {
        return message + "(offset = " + offset + ")";
    }

    @Override
    protected SeekableInputStream getSource() {
        return (SeekableInputStream)this.source;
    }
}

