/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.parser;

import java.io.Closeable;
import java.io.IOException;
import java.util.Arrays;
import java.util.logging.Logger;
import org.verapdf.as.filters.io.ASBufferedInFilter;
import org.verapdf.as.io.ASInputStream;
import org.verapdf.as.io.ASMemoryInStream;
import org.verapdf.parser.BaseParser;
import org.verapdf.parser.Token;

public class NotSeekableBaseParser
extends BaseParser
implements Closeable {
    private static final Logger LOGGER = Logger.getLogger(NotSeekableBaseParser.class.getCanonicalName());

    public NotSeekableBaseParser(ASInputStream stream) throws IOException {
        if (stream == null) {
            throw new IOException("Stream in NotSeekableBaseParser can't be null.");
        }
        this.source = new ASBufferedInFilter(stream);
        try {
            this.getSource().initialize();
        }
        catch (IOException e) {
            this.source.close();
            throw e;
        }
    }

    public NotSeekableBaseParser(ASInputStream fileStream, boolean isPSParser) throws IOException {
        this(fileStream);
        this.isPSParser = isPSParser;
    }

    @Override
    public void close() throws IOException {
        this.source.close();
    }

    @Override
    protected boolean findKeyword(Token.Keyword keyword, int lookUpSize) throws IOException {
        this.getSource().resetReadCounter();
        this.nextToken();
        while (this.token.type != Token.Type.TT_EOF && (this.token.type != Token.Type.TT_KEYWORD || this.token.keyword != keyword) && this.getSource().getReadCounter() < lookUpSize) {
            this.nextToken();
        }
        return this.token.type == Token.Type.TT_KEYWORD && this.token.keyword == keyword;
    }

    protected void skipStreamSpaces() throws IOException {
        byte space = this.source.readByte();
        while (space == 32) {
            space = this.source.readByte();
        }
        if (space == 13) {
            space = this.source.readByte();
            if (space != 10) {
                this.source.unread();
            }
        } else if (space != 10) {
            this.source.unread();
        }
    }

    @Override
    protected void skipComment() throws IOException {
        while (!this.source.isEOF()) {
            byte ch = this.source.readByte();
            if (NotSeekableBaseParser.isLF(ch)) {
                return;
            }
            if (!this.isEndOfComment(ch)) continue;
            ch = this.source.readByte();
            if (!NotSeekableBaseParser.isLF(ch)) {
                this.source.unread();
            }
            return;
        }
    }

    protected boolean isEndOfComment(byte ch) {
        return NotSeekableBaseParser.isCR(ch);
    }

    @Override
    protected void readASCII85() throws IOException {
        byte[] buf = new byte[10240];
        int pointer = 0;
        byte readByte = this.source.readByte();
        while (!(this.source.isEOF() || readByte == 126 && this.source.peek() == 62)) {
            buf[pointer++] = readByte;
            if (pointer == buf.length) {
                buf = NotSeekableBaseParser.extendArray(buf);
            }
            readByte = this.source.readByte();
        }
        this.source.readByte();
        try (ASMemoryInStream ascii85Data = new ASMemoryInStream(Arrays.copyOf(buf, pointer));){
            this.decodeASCII85(ascii85Data, buf.length);
        }
    }

    public static byte[] extendArray(byte[] array) {
        byte[] res = new byte[array.length * 2];
        System.arraycopy(array, 0, res, 0, array.length);
        return res;
    }

    @Override
    protected ASBufferedInFilter getSource() {
        return (ASBufferedInFilter)this.source;
    }
}

