/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.pd.structure;

import java.util.List;
import java.util.Map;
import org.verapdf.as.ASAtom;
import org.verapdf.cos.COSKey;
import org.verapdf.cos.COSName;
import org.verapdf.cos.COSObjType;
import org.verapdf.cos.COSObject;
import org.verapdf.cos.COSString;
import org.verapdf.parser.PDFFlavour;
import org.verapdf.pd.structure.PDStructTreeNode;
import org.verapdf.pd.structure.PDStructureNameSpace;
import org.verapdf.pd.structure.StructureType;
import org.verapdf.tools.StaticResources;
import org.verapdf.tools.TaggedPDFHelper;

public class PDStructElem
extends PDStructTreeNode {
    private Map<ASAtom, ASAtom> rootRoleMap;

    public PDStructElem(COSObject obj, Map<ASAtom, ASAtom> rootRoleMap) {
        super(obj);
        this.rootRoleMap = rootRoleMap;
    }

    public ASAtom getType() {
        return this.getObject().getNameKey(ASAtom.TYPE);
    }

    public COSName getCOSStructureType() {
        COSObject object = this.getKey(ASAtom.S);
        if (object != null && object.getType() == COSObjType.COS_NAME) {
            return (COSName)object.getDirectBase();
        }
        return null;
    }

    public COSString getLang() {
        COSObject object = this.getKey(ASAtom.LANG);
        if (object != null && object.getType() == COSObjType.COS_STRING) {
            return (COSString)object.getDirectBase();
        }
        return null;
    }

    public PDStructureNameSpace getNameSpace() {
        COSObject object = this.getKey(ASAtom.NS);
        if (object != null && object.getType() == COSObjType.COS_DICT) {
            return PDStructureNameSpace.createNameSpace(object);
        }
        return null;
    }

    public StructureType getStructureType() {
        return StructureType.createStructureType(this.getKey(ASAtom.S), this.getKey(ASAtom.NS));
    }

    public COSObject getActualText() {
        return this.getKey(ASAtom.ACTUAL_TEXT);
    }

    public COSObject getRef() {
        return this.getKey(ASAtom.REF);
    }

    public boolean containsRef() {
        return this.knownKey(ASAtom.REF);
    }

    public String getAlternateDescription() {
        return this.getStringKey(ASAtom.ALT);
    }

    public String getExpandedAbbreviation() {
        return this.getStringKey(ASAtom.E);
    }

    public PDStructElem getParent() {
        COSObject parentObject = this.getKey(ASAtom.P);
        if (parentObject != null) {
            return new PDStructElem(parentObject, this.rootRoleMap);
        }
        return null;
    }

    public COSKey getPageObjectNumber() {
        COSObject object = this.getObject().getKey(ASAtom.PG);
        if (object != null) {
            return object.getKey();
        }
        return null;
    }

    public StructureType getDefaultStructureType() {
        return TaggedPDFHelper.getDefaultStructureType(this.getStructureType(), this.rootRoleMap);
    }

    @Override
    public List<PDStructElem> getStructChildren() {
        return TaggedPDFHelper.getStructElemStructChildren(this.getObject(), this.rootRoleMap);
    }

    public String getRoleMapToSameNamespaceTag() {
        return TaggedPDFHelper.getRoleMapToSameNamespaceTag(this.getStructureType(), this.rootRoleMap);
    }

    @Override
    public List<Object> getChildren() {
        return TaggedPDFHelper.getStructElemChildren(this.getObject(), this.rootRoleMap);
    }

    public static StructureType getStructureElementStandardStructureType(PDStructElem pdStructElem) {
        StructureType type;
        StructureType defaultStructureType;
        PDFFlavour flavour = StaticResources.getFlavour();
        if ((flavour.getSpecification() == PDFFlavour.Specification.ISO_19005_4 || flavour == PDFFlavour.PDFUA_2 || flavour == PDFFlavour.WCAG2_1) && (defaultStructureType = pdStructElem.getDefaultStructureType()) != null) {
            return defaultStructureType;
        }
        if (flavour.getSpecification() != PDFFlavour.Specification.ISO_19005_4 && flavour != PDFFlavour.PDFUA_2 && (type = pdStructElem.getStructureType()) != null) {
            return StructureType.createStructureType(ASAtom.getASAtom(StaticResources.getRoleMapHelper().getStandardType(type.getType())));
        }
        return null;
    }

    public static String getStructureElementStandardType(PDStructElem pdStructElem) {
        StructureType type = PDStructElem.getStructureElementStandardStructureType(pdStructElem);
        return type != null ? type.getType().getValue() : null;
    }

    public static boolean isMathStandardType(StructureType standardStructureType) {
        return StaticResources.getFlavour() == PDFFlavour.PDFUA_2 && standardStructureType != null && "http://www.w3.org/1998/Math/MathML".equals(standardStructureType.getNameSpaceURI());
    }
}

