/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.tools;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.verapdf.as.ASAtom;
import org.verapdf.parser.PDFFlavour;
import org.verapdf.tools.StaticResources;
import org.verapdf.tools.TaggedPDFHelper;

public class TaggedPDFRoleMapHelper {
    private final Map<ASAtom, ASAtom> roleMap;

    public TaggedPDFRoleMapHelper(Map<ASAtom, ASAtom> roleMap) {
        this.roleMap = roleMap == null ? Collections.emptyMap() : new HashMap<ASAtom, ASAtom>(roleMap);
    }

    public String getStandardType(ASAtom type) {
        boolean isFastStop;
        Set<String> currentStandardTypes;
        if (type == null) {
            return null;
        }
        if (StaticResources.getFlavour().getSpecification() == PDFFlavour.Specification.ISO_19005_1) {
            currentStandardTypes = TaggedPDFHelper.getPdf14StandardRoleTypes();
            isFastStop = true;
        } else {
            currentStandardTypes = StaticResources.getFlavour() == PDFFlavour.WCAG2_1 ? TaggedPDFHelper.getWcagStandardRoleTypes() : TaggedPDFHelper.getPdf17StandardRoleTypes();
            isFastStop = false;
        }
        return this.getStandardType(type, currentStandardTypes, isFastStop);
    }

    private String getStandardType(ASAtom type, Set<String> currentStandardTypes, boolean isFastStop) {
        HashSet<ASAtom> visitedTypes = new HashSet<ASAtom>();
        visitedTypes.add(type);
        ASAtom res = this.roleMap.get(type);
        String typeValue = type.getValue();
        if ((isFastStop || res == null || visitedTypes.contains(res)) && currentStandardTypes.contains(typeValue)) {
            return typeValue;
        }
        while (res != null && !visitedTypes.contains(res)) {
            String resValue = res.getValue();
            if (currentStandardTypes.contains(resValue)) {
                return resValue;
            }
            visitedTypes.add(res);
            res = this.roleMap.get(res);
        }
        return null;
    }

    public Boolean circularMappingExist(ASAtom type) {
        if (type == null) {
            return null;
        }
        HashSet<ASAtom> visitedTypes = new HashSet<ASAtom>();
        visitedTypes.add(type);
        ASAtom res = this.roleMap.get(type);
        while (res != null) {
            if (visitedTypes.contains(res)) {
                return true;
            }
            visitedTypes.add(res);
            res = this.roleMap.get(res);
        }
        return false;
    }

    public Map<ASAtom, ASAtom> getRoleMap() {
        return this.roleMap;
    }
}

