/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.pd.structure;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.verapdf.as.ASAtom;
import org.verapdf.cos.COSObjType;
import org.verapdf.cos.COSObject;
import org.verapdf.pd.structure.PDNumberTreeNode;
import org.verapdf.pd.structure.PDStructElem;
import org.verapdf.pd.structure.PDStructTreeNode;
import org.verapdf.tools.StaticResources;
import org.verapdf.tools.TaggedPDFHelper;

public class PDStructTreeRoot
extends PDStructTreeNode {
    public PDStructTreeRoot(COSObject obj) {
        super(obj);
        StaticResources.setRoleMapHelper(this.getRoleMap());
    }

    @Override
    public List<PDStructElem> getStructChildren() {
        return TaggedPDFHelper.getStructTreeRootStructChildren(this.getObject(), this.getRoleMap());
    }

    @Override
    public List<Object> getChildren() {
        return TaggedPDFHelper.getStructTreeRootChildren(this.getObject(), this.getRoleMap());
    }

    public Map<ASAtom, ASAtom> getRoleMap() {
        COSObject roleMap = this.getKey(ASAtom.ROLE_MAP);
        if (roleMap != null && roleMap.getType() == COSObjType.COS_DICT && roleMap.size() > 0) {
            HashMap<ASAtom, ASAtom> res = new HashMap<ASAtom, ASAtom>();
            Set<ASAtom> keys = roleMap.getKeySet();
            for (ASAtom key : keys) {
                ASAtom value = roleMap.getNameKey(key);
                if (value == null) continue;
                res.put(key, value);
            }
            return Collections.unmodifiableMap(res);
        }
        return Collections.emptyMap();
    }

    public COSObject getClassMap() {
        return this.getKey(ASAtom.CLASS_MAP);
    }

    public PDNumberTreeNode getParentTree() {
        COSObject parentTree = this.getKey(ASAtom.PARENT_TREE);
        if (parentTree != null && parentTree.getType().isDictionaryBased()) {
            return new PDNumberTreeNode(parentTree);
        }
        return null;
    }
}

