/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.pd.structure;

import java.util.List;
import org.verapdf.as.ASAtom;
import org.verapdf.cos.COSKey;
import org.verapdf.cos.COSName;
import org.verapdf.cos.COSObjType;
import org.verapdf.cos.COSObject;
import org.verapdf.cos.COSString;
import org.verapdf.parser.PDFFlavour;
import org.verapdf.pd.structure.PDStructTreeNode;
import org.verapdf.pd.structure.PDStructureNameSpace;
import org.verapdf.pd.structure.StructureType;
import org.verapdf.tools.StaticResources;
import org.verapdf.tools.TaggedPDFHelper;
import org.verapdf.tools.TaggedPDFRoleMapHelper;

public class PDStructElem
extends PDStructTreeNode {
    public PDStructElem(COSObject obj) {
        super(obj);
    }

    public ASAtom getType() {
        return this.getObject().getNameKey(ASAtom.TYPE);
    }

    public COSName getCOSStructureType() {
        COSObject object = this.getKey(ASAtom.S);
        if (object != null && object.getType() == COSObjType.COS_NAME) {
            return (COSName)object.getDirectBase();
        }
        return null;
    }

    public COSString getLang() {
        COSObject object = this.getKey(ASAtom.LANG);
        if (object != null && object.getType() == COSObjType.COS_STRING) {
            return (COSString)object.getDirectBase();
        }
        return null;
    }

    public PDStructureNameSpace getNameSpace() {
        COSObject object = this.getKey(ASAtom.NS);
        if (object != null && object.getType() == COSObjType.COS_DICT) {
            return PDStructureNameSpace.createNameSpace(object);
        }
        return null;
    }

    public StructureType getStructureType() {
        return StructureType.createStructureType(this.getKey(ASAtom.S), this.getKey(ASAtom.NS));
    }

    public COSObject getActualText() {
        return this.getKey(ASAtom.ACTUAL_TEXT);
    }

    public COSObject getRef() {
        return this.getKey(ASAtom.REF);
    }

    public boolean containsRef() {
        return this.knownKey(ASAtom.REF);
    }

    public String getAlternateDescription() {
        return this.getStringKey(ASAtom.ALT);
    }

    public String getExpandedAbbreviation() {
        return this.getStringKey(ASAtom.E);
    }

    public PDStructElem getParent() {
        COSObject parentObject = this.getKey(ASAtom.P);
        if (parentObject != null) {
            return new PDStructElem(parentObject);
        }
        return null;
    }

    public COSKey getPageObjectNumber() {
        COSObject object = this.getObject().getKey(ASAtom.PG);
        if (object != null) {
            return object.getKey();
        }
        return null;
    }

    public StructureType getDefaultStructureType() {
        return PDStructElem.getDefaultStructureType(this.getStructureType());
    }

    public static StructureType getDefaultStructureType(StructureType structureType) {
        return TaggedPDFHelper.getDefaultStructureType(structureType);
    }

    public String getRoleMapToSameNamespaceTag() {
        return TaggedPDFHelper.getRoleMapToSameNamespaceTag(this.getStructureType());
    }

    public static StructureType getStructureElementStandardStructureType(PDStructElem pdStructElem) {
        return PDStructElem.getStructureTypeStandardStructureType(pdStructElem.getStructureType());
    }

    public static StructureType getStructureTypeStandardStructureType(StructureType type) {
        StructureType defaultStructureType;
        List<PDFFlavour> flavour = StaticResources.getFlavour();
        if (PDFFlavour.isFlavourPDFSpecification(flavour, PDFFlavour.PDFSpecification.ISO_32000_2_0) && (defaultStructureType = PDStructElem.getDefaultStructureType(type)) != null) {
            return defaultStructureType;
        }
        if (!PDFFlavour.isFlavourPDFSpecification(flavour, PDFFlavour.PDFSpecification.ISO_32000_2_0) && type != null) {
            return StructureType.createStructureType(ASAtom.getASAtom(StaticResources.getRoleMapHelper().getStandardType(type.getType())), type.getNameSpace());
        }
        return null;
    }

    public static String getStructureTypeStandardType(StructureType structureType) {
        StructureType type = PDStructElem.getStructureTypeStandardStructureType(structureType);
        return type != null ? type.getType().getValue() : null;
    }

    public static String getStructureElementStandardType(PDStructElem pdStructElem) {
        StructureType type = PDStructElem.getStructureElementStandardStructureType(pdStructElem);
        return type != null ? type.getType().getValue() : null;
    }

    public static boolean isStandardStructureType(StructureType type) {
        List<PDFFlavour> flavour = StaticResources.getFlavour();
        boolean isStandard = false;
        if (PDFFlavour.isFlavourPDFSpecification(flavour, PDFFlavour.PDFSpecification.ISO_32000_2_0)) {
            isStandard = TaggedPDFHelper.isStandardType(type);
        } else if (type != null) {
            isStandard |= TaggedPDFRoleMapHelper.isStandardType(type);
        }
        return isStandard;
    }

    public static boolean isMathStandardType(StructureType standardStructureType) {
        return PDFFlavour.isPDFUA2RelatedFlavour(StaticResources.getFlavour()) && standardStructureType != null && "http://www.w3.org/1998/Math/MathML".equals(standardStructureType.getNameSpaceURI());
    }

    public static boolean isPassThroughTag(String structureType) {
        return "NonStruct".equals(structureType) || "Div".equals(structureType) || "Part".equals(structureType);
    }
}

