/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.pd.font.truetype;

import java.io.IOException;
import org.verapdf.as.io.ASInputStream;
import org.verapdf.as.io.ASMemoryInStream;
import org.verapdf.pd.font.FontProgram;
import org.verapdf.pd.font.truetype.TrueTypeCmapSubtable;
import org.verapdf.pd.font.truetype.TrueTypeFontParser;
import org.verapdf.tools.resource.ASFileStreamCloser;

public abstract class BaseTrueTypeProgram
implements FontProgram {
    protected float[] widths;
    protected TrueTypeFontParser parser;
    protected String[] encodingMappingArray;
    private boolean attemptedParsing = false;
    private boolean successfullyParsed = false;

    public BaseTrueTypeProgram(ASInputStream stream) throws IOException {
        this.parser = new TrueTypeFontParser(stream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void parseFont() throws IOException {
        if (!this.attemptedParsing) {
            try {
                this.attemptedParsing = true;
                this.parser.readHeader();
                this.parser.readTableDirectory();
                this.parser.readTables();
                float quotient = 1000.0f / (float)this.parser.getHeadParser().getUnitsPerEm();
                int[] unconvertedWidths = this.parser.getHmtxParser().getLongHorMetrics();
                this.widths = new float[unconvertedWidths.length];
                for (int i = 0; i < unconvertedWidths.length; ++i) {
                    this.widths[i] = (float)unconvertedWidths[i] * quotient;
                }
                this.successfullyParsed = true;
            }
            finally {
                this.parser.source.close();
            }
        }
    }

    public TrueTypeCmapSubtable[] getCmapEncodingPlatform() {
        if (this.parser.getCmapParser() != null) {
            return this.parser.getCmapParser().getCmapInfos();
        }
        return new TrueTypeCmapSubtable[0];
    }

    public int getNGlyphs() {
        return this.parser.getMaxpParser().getNumGlyphs();
    }

    public boolean isCmapPresent(int platformID, int encodingID) {
        return this.parser.getCmapTable(platformID, encodingID) != null;
    }

    protected float getWidthWithCheck(int gid) {
        if (gid < this.widths.length) {
            return this.widths[gid];
        }
        if (gid < this.parser.getMaxpParser().getNumGlyphs()) {
            return this.widths[this.widths.length - 1];
        }
        return this.widths[0];
    }

    @Override
    public boolean isAttemptedParsing() {
        return this.attemptedParsing;
    }

    @Override
    public boolean isSuccessfulParsing() {
        return this.successfullyParsed;
    }

    @Override
    public ASFileStreamCloser getFontProgramResource() {
        if (this.parser.source instanceof ASMemoryInStream) {
            return null;
        }
        return new ASFileStreamCloser(this.parser.source);
    }
}

