/**
 * This file is part of veraPDF Validation Model API, a module of the veraPDF project.
 * Copyright (c) 2015, veraPDF Consortium <info@verapdf.org>
 * All rights reserved.
 *
 * veraPDF Validation Model API is free software: you can redistribute it and/or modify
 * it under the terms of either:
 *
 * The GNU General public license GPLv3+.
 * You should have received a copy of the GNU General Public License
 * along with veraPDF Validation Model API as the LICENSE.GPL file in the root of the source
 * tree.  If not, see http://www.gnu.org/licenses/ or
 * https://www.gnu.org/licenses/gpl-3.0.en.html.
 *
 * The Mozilla Public License MPLv2+.
 * You should have received a copy of the Mozilla Public License along with
 * veraPDF Validation Model API as the LICENSE.MPL file in the root of the source tree.
 * If a copy of the MPL was not distributed with this file, you can obtain one at
 * http://mozilla.org/MPL/2.0/.
 */
package org.verapdf.model.alayer;
		
import org.verapdf.model.baselayer.Object;

		
/**
*/
public interface AProjection extends AObject {
	

	/**
	*/
	public Boolean getcontainsCS();

	/**
	*/
	public String getCSType();

	/**
	*/
	public Boolean getCSHasTypeName();

	/**
	*/
	public String getCSNameValue();

	/**
	*/
	public Boolean getcontainsF();

	/**
	*/
	public String getFType();

	/**
	*/
	public Boolean getFHasTypeNumber();

	/**
	*/
	public Boolean getcontainsFOV();

	/**
	*/
	public String getFOVType();

	/**
	*/
	public Boolean getFOVHasTypeNumber();

	/**
	*/
	public Double getFOVNumberValue();

	/**
	*/
	public Boolean getcontainsN();

	/**
	*/
	public String getNType();

	/**
	*/
	public Boolean getNHasTypeNumber();

	/**
	*/
	public Double getNNumberValue();

	/**
	*/
	public Boolean getcontainsOB();

	/**
	*/
	public String getOBType();

	/**
	*/
	public Boolean getOBHasTypeName();

	/**
	*/
	public String getOBNameValue();

	/**
	*/
	public Boolean getcontainsOS();

	/**
	*/
	public String getOSType();

	/**
	*/
	public Boolean getOSHasTypeNumber();

	/**
	*/
	public Double getOSNumberValue();

	/**
	*/
	public Boolean getcontainsPS();

	/**
	*/
	public String getPSType();

	/**
	*/
	public Boolean getPSHasTypeName();

	/**
	*/
	public Boolean getPSHasTypeNumber();

	/**
	*/
	public Double getPSNumberValue();

	/**
	*/
	public Boolean getcontainsSubtype();

	/**
	*/
	public String getSubtypeType();

	/**
	*/
	public Boolean getSubtypeHasTypeName();

	/**
	*/
	public String getSubtypeNameValue();
}
