/**
 * This file is part of VeraPDF Validation Model API for Arlington PDF Model, a module of the veraPDF project.
 * Copyright (c) 2015-2025, veraPDF Consortium <info@verapdf.org>
 * All rights reserved.
 *
 * VeraPDF Validation Model API for Arlington PDF Model is free software: you can redistribute it and/or modify
 * it under the terms of either:
 *
 * The GNU General public license GPLv3+.
 * You should have received a copy of the GNU General Public License
 * along with VeraPDF Validation Model API for Arlington PDF Model as the LICENSE.GPL file in the root of the source
 * tree.  If not, see http://www.gnu.org/licenses/ or
 * https://www.gnu.org/licenses/gpl-3.0.en.html.
 *
 * The Mozilla Public License MPLv2+.
 * You should have received a copy of the Mozilla Public License along with
 * VeraPDF Validation Model API for Arlington PDF Model as the LICENSE.MPL file in the root of the source tree.
 * If a copy of the MPL was not distributed with this file, you can obtain one at
 * http://mozilla.org/MPL/2.0/.
 */
package org.verapdf.model.external;
		
import org.verapdf.model.baselayer.Object;
import java.util.List;

		
/**
* TrueType font program embedded into PDF document 
*/
public interface TrueTypeFontProgram extends FontProgram {
	

	/**
	* true / false if the corresponding PDF Font is marked as symbolic / non-symbolic in its font dictionary
	*/
	public Boolean getisSymbolic();

	/**
	* number of cmap subtables in the font program
	*/
	public Long getnrCmaps();

	/**
	* true if the font program contains the Microsoft Symbol (3,0 – Platform ID=3, Encoding ID=0) cmap subtable
	*/
	public Boolean getcmap30Present();

	/**
	* true if the font program contains the Microsoft Unicode (3,1 – Platform ID=3, Encoding ID=1) cmap subtable
	*/
	public Boolean getcmap31Present();

	/**
	* true if the font program contains the Macintosh Roman (1,0 – Platform ID=1, Encoding ID=0) cmap subtable
	*/
	public Boolean getcmap10Present();
}
