/**
 * This file is part of VeraPDF Validation Model API for Arlington PDF Model, a module of the veraPDF project.
 * Copyright (c) 2015-2025, veraPDF Consortium <info@verapdf.org>
 * All rights reserved.
 *
 * VeraPDF Validation Model API for Arlington PDF Model is free software: you can redistribute it and/or modify
 * it under the terms of either:
 *
 * The GNU General public license GPLv3+.
 * You should have received a copy of the GNU General Public License
 * along with VeraPDF Validation Model API for Arlington PDF Model as the LICENSE.GPL file in the root of the source
 * tree.  If not, see http://www.gnu.org/licenses/ or
 * https://www.gnu.org/licenses/gpl-3.0.en.html.
 *
 * The Mozilla Public License MPLv2+.
 * You should have received a copy of the Mozilla Public License along with
 * VeraPDF Validation Model API for Arlington PDF Model as the LICENSE.MPL file in the root of the source tree.
 * If a copy of the MPL was not distributed with this file, you can obtain one at
 * http://mozilla.org/MPL/2.0/.
 */
package org.verapdf.model.pdlayer;
		
import org.verapdf.model.baselayer.Object;
import org.verapdf.model.coslayer.CosObject;
import org.verapdf.model.coslayer.CosDict;
import org.verapdf.model.coslayer.CosStream;
import org.verapdf.model.coslayer.CosReal;
import org.verapdf.model.coslayer.CosNumber;
import org.verapdf.model.coslayer.CosRenderingIntent;
import org.verapdf.model.coslayer.CosUnicodeName;
import org.verapdf.model.coslayer.CosIIFilter;
import org.verapdf.model.coslayer.CosBBox;
import org.verapdf.model.coslayer.CosBM;
import org.verapdf.model.coslayer.CosLang;
import org.verapdf.model.coslayer.CosTextString;
import org.verapdf.model.coslayer.CosActualText;
import org.verapdf.model.coslayer.CosAlt;
import org.verapdf.model.operator.Operator;
import org.verapdf.model.external.ICCOutputProfile;
import org.verapdf.model.external.ICCInputProfile;
import org.verapdf.model.external.FontProgram;
import org.verapdf.model.external.CMapFile;
import org.verapdf.model.external.JPEG2000;
import org.verapdf.model.external.PKCSDataObject;
import org.verapdf.model.xmplayer.XMPPackage;
import org.verapdf.model.selayer.SEContentItem;

		
/**
* Form XObject
*/
public interface PDXForm extends PDXObject {
	

	/**
	* value of the Subtype2 key
	*/
	public String getSubtype2();

	/**
	* true if the form XObject dictionary contains PS entry
	*/
	public Boolean getcontainsPS();

	/**
	* true if the form XObject dictionary contains Ref key
	*/
	public Boolean getcontainsRef();





	/**
	* false, if Form XObject contains MCIDs and is referenced more than once
	*/
	public Boolean getisUniqueSemanticParent();
}
