/**
 * This file is part of VeraPDF Validation Model API for Arlington PDF Model, a module of the veraPDF project.
 * Copyright (c) 2015-2025, veraPDF Consortium <info@verapdf.org>
 * All rights reserved.
 *
 * VeraPDF Validation Model API for Arlington PDF Model is free software: you can redistribute it and/or modify
 * it under the terms of either:
 *
 * The GNU General public license GPLv3+.
 * You should have received a copy of the GNU General Public License
 * along with VeraPDF Validation Model API for Arlington PDF Model as the LICENSE.GPL file in the root of the source
 * tree.  If not, see http://www.gnu.org/licenses/ or
 * https://www.gnu.org/licenses/gpl-3.0.en.html.
 *
 * The Mozilla Public License MPLv2+.
 * You should have received a copy of the Mozilla Public License along with
 * VeraPDF Validation Model API for Arlington PDF Model as the LICENSE.MPL file in the root of the source tree.
 * If a copy of the MPL was not distributed with this file, you can obtain one at
 * http://mozilla.org/MPL/2.0/.
 */
package org.verapdf.model.alayer;
		
import org.verapdf.model.baselayer.Object;

		
/**
*/
public interface AObject extends Object {
	

	/**
	*/
	public Long getsize();

	/**
	*/
	public String getkeyName();

	/**
	*/
	public String getkeysString();

	/**
	*/
	public Long getnumberOfPages();

	/**
	*/
	public Long getfileSize();

	/**
	*/
	public Boolean getisPDFTagged();

	/**
	*/
	public Boolean getnotStandard14Font();

	/**
	*/
	public Boolean getisEncryptedWrapper();

	/**
	*/
	public Boolean getisAssociatedFile();

	/**
	*/
	public Boolean gethasExtensionAAPL();

	/**
	*/
	public Boolean gethasExtensionADBE_Extn3();

	/**
	*/
	public Boolean gethasExtensionC2PA();

	/**
	*/
	public Boolean gethasExtensionETSI_PAdES();

	/**
	*/
	public Boolean gethasExtensionISO_19005_3();

	/**
	*/
	public Boolean gethasExtensionISO_19593();

	/**
	*/
	public Boolean gethasExtensionISO_21812();

	/**
	*/
	public Boolean gethasExtensionISO_TS_24064();

	/**
	*/
	public Boolean gethasExtensionISO_TS_24654();

	/**
	*/
	public Boolean gethasExtensionISO_TS_32001();

	/**
	*/
	public Boolean gethasExtensionISO_TS_32003();

	/**
	*/
	public Boolean gethasExtensionISO_TS_32004();

	/**
	*/
	public Boolean gethasExtensionISO_TS_32007();

	/**
	*/
	public Boolean gethasExtensionMalforms();

	/**
	*/
	public Boolean gethasExtensionOpenOffice();

	/**
	*/
	public Boolean gethasExtensionPDF_VT2();

	/**
	*/
	public Boolean gethasExtensionWTPDF();
}
