/**
 * This file is part of veraPDF Validation Model API, a module of the veraPDF project.
 * Copyright (c) 2015-2024, veraPDF Consortium <info@verapdf.org>
 * All rights reserved.
 *
 * veraPDF Validation Model API is free software: you can redistribute it and/or modify
 * it under the terms of either:
 *
 * The GNU General public license GPLv3+.
 * You should have received a copy of the GNU General Public License
 * along with veraPDF Validation Model API as the LICENSE.GPL file in the root of the source
 * tree.  If not, see http://www.gnu.org/licenses/ or
 * https://www.gnu.org/licenses/gpl-3.0.en.html.
 *
 * The Mozilla Public License MPLv2+.
 * You should have received a copy of the Mozilla Public License along with
 * veraPDF Validation Model API as the LICENSE.MPL file in the root of the source tree.
 * If a copy of the MPL was not distributed with this file, you can obtain one at
 * http://mozilla.org/MPL/2.0/.
 */
package org.verapdf.model.pdlayer;
		
import org.verapdf.model.baselayer.Object;
import org.verapdf.model.coslayer.CosObject;
import org.verapdf.model.coslayer.CosDict;
import org.verapdf.model.coslayer.CosStream;
import org.verapdf.model.coslayer.CosReal;
import org.verapdf.model.coslayer.CosNumber;
import org.verapdf.model.coslayer.CosRenderingIntent;
import org.verapdf.model.coslayer.CosUnicodeName;
import org.verapdf.model.coslayer.CosIIFilter;
import org.verapdf.model.coslayer.CosBBox;
import org.verapdf.model.coslayer.CosBM;
import org.verapdf.model.coslayer.CosLang;
import org.verapdf.model.coslayer.CosTextString;
import org.verapdf.model.coslayer.CosActualText;
import org.verapdf.model.coslayer.CosAlt;
import org.verapdf.model.operator.Operator;
import org.verapdf.model.external.ICCOutputProfile;
import org.verapdf.model.external.ICCInputProfile;
import org.verapdf.model.external.FontProgram;
import org.verapdf.model.external.CMapFile;
import org.verapdf.model.external.JPEG2000;
import org.verapdf.model.external.PKCSDataObject;
import org.verapdf.model.xmplayer.XMPPackage;
import org.verapdf.model.selayer.SEContentItem;

		
/**
* One of the simple font types (Type 1, TrueType, Type 3)
*/
public interface PDSimpleFont extends PDFont {
	

	/**
	* true if the font is one of the 14 standard fonts defined in PDF 1.4 Reference
	*/
	public Boolean getisStandard();

	/**
	* FirstChar entry; null if LastChar entry is not present or has invalid type
	*/
	public Long getFirstChar();

	/**
	* LastChar entry; null if LastChar entry is not present or has invalid type
	*/
	public Long getLastChar();

	/**
	* The size of the Widths array; null if the Widths array is not present or has invalid type
	*/
	public Long getWidths_size();

	/**
	* String representation of the font encoding:
	* - null if the /Encoding entry is not present in the font dictionary
	* - if /Encoding entry in the font dictionary if of Name type, then the value of this entry;
	* - if /Encoding entry is a dictionary, which does not contain /Differences array, then the value of /BaseEncoding entry in this dictionary (or null, if /BaseEncoding is also not present)
	*/
	public String getEncoding();

	/**
	* true if an Encoding dictionary contains a Differences entry
	*/
	public Boolean getcontainsDifferences();
}
