/**
 * This file is part of veraPDF Validation Model API, a module of the veraPDF project.
 * Copyright (c) 2015-2024, veraPDF Consortium <info@verapdf.org>
 * All rights reserved.
 *
 * veraPDF Validation Model API is free software: you can redistribute it and/or modify
 * it under the terms of either:
 *
 * The GNU General public license GPLv3+.
 * You should have received a copy of the GNU General Public License
 * along with veraPDF Validation Model API as the LICENSE.GPL file in the root of the source
 * tree.  If not, see http://www.gnu.org/licenses/ or
 * https://www.gnu.org/licenses/gpl-3.0.en.html.
 *
 * The Mozilla Public License MPLv2+.
 * You should have received a copy of the Mozilla Public License along with
 * veraPDF Validation Model API as the LICENSE.MPL file in the root of the source tree.
 * If a copy of the MPL was not distributed with this file, you can obtain one at
 * http://mozilla.org/MPL/2.0/.
 */
package org.verapdf.model.xmplayer;
		
import org.verapdf.model.baselayer.Object;
import java.util.Set;

		
/**
* XMP package
*/
public interface XMPPackage extends XMPObject {
	



	/**
	* true if package serialization is valid:
	* - package starts with one of the expected byte arrays representing package beginning in a supported encoding
	* - package represents a well-formed XML that is serialized using the encoding of the matched byte array
	*/
	public Boolean getisSerializationValid();

	/**
	* the actual encoding used for XMP package serialization
	* it is different from the encoding property, which is declared encoding (deprecated)
	*/
	public String getactualEncoding();

	/**
	* value of ‘bytes’ attribute of XMP package header (null if the attribute is missing)
	*/
	public String getbytes();

	/**
	* value of ‘encoding’ attribute of XMP package header (null if the attribute is missing)
	*/
	public String getencoding();
}
