/*
 * This file is part of veraPDF Validation Model API, a module of the veraPDF project.
 * Copyright (c) 2015-2025, veraPDF Consortium <info@verapdf.org>
 * All rights reserved.
 *
 * veraPDF Validation Model API is free software: you can redistribute it and/or modify
 * it under the terms of either:
 *
 * The GNU General public license GPLv3+.
 * You should have received a copy of the GNU General Public License
 * along with veraPDF Validation Model API as the LICENSE.GPL file in the root of the source
 * tree.  If not, see http://www.gnu.org/licenses/ or
 * https://www.gnu.org/licenses/gpl-3.0.en.html.
 *
 * The Mozilla Public License MPLv2+.
 * You should have received a copy of the Mozilla Public License along with
 * veraPDF Validation Model API as the LICENSE.MPL file in the root of the source tree.
 * If a copy of the MPL was not distributed with this file, you can obtain one at
 * http://mozilla.org/MPL/2.0/.
 */
package org.verapdf.model.salayer;
		
import org.verapdf.model.baselayer.Object;
import java.util.List;

		
/**
* the structure element dictionary
*/
public interface SAStructElem extends SAObject {
	


	/**
	* structure type
	*/
	public String getvalueS();

	/**
	* number ranging from 0 to 1 indicating the probability that the correct type is right defined
	*/
	public Double getcorrectSemanticScore();

	/**
	* supposed correct element type
	*/
	public String getcorrectType();

	/**
	* standard type of struct element
	*/
	public String getstandardType();

	/**
	* true, if this is table struct element
	*/
	public Boolean getisTableElem();

	/**
	* true, if this is table child element
	*/
	public Boolean getisTableChild();

	/**
	* true, if this is list struct element
	*/
	public Boolean getisListElem();

	/**
	* true, if this is list child element
	*/
	public Boolean getisListChild();

	/**
	* false, if structure element contains other structure elements
	*/
	public Boolean getisLeafElem();

	/**
	* ampersand separated list of all standard types of parents element of this structure element in the structure hierarchy
	*/
	public String getparentsStandardTypes();

	/**
	* ampersand separated list of child element types, role mapped to the standard types
	*/
	public String getkidsStandardTypes();

	/**
	* parent element type, role mapped to the standard type
	*/
	public String getparentStandardType();

	/**
	* true, if this element has wrong type and all parents of this element have right types
	*/
	public Boolean gethasLowestDepthError();

	/**
	* number of the first page that contains the structure element
	*/
	public Long getpage();

	/**
	* number of the last page that contains the structure element
	*/
	public Long getlastPage();
}
