/**
 * This file is part of veraPDF Validation Model API, a module of the veraPDF project.
 * Copyright (c) 2015-2025, veraPDF Consortium <info@verapdf.org>
 * All rights reserved.
 *
 * veraPDF Validation Model API is free software: you can redistribute it and/or modify
 * it under the terms of either:
 *
 * The GNU General public license GPLv3+.
 * You should have received a copy of the GNU General Public License
 * along with veraPDF Validation Model API as the LICENSE.GPL file in the root of the source
 * tree.  If not, see http://www.gnu.org/licenses/ or
 * https://www.gnu.org/licenses/gpl-3.0.en.html.
 *
 * The Mozilla Public License MPLv2+.
 * You should have received a copy of the Mozilla Public License along with
 * veraPDF Validation Model API as the LICENSE.MPL file in the root of the source tree.
 * If a copy of the MPL was not distributed with this file, you can obtain one at
 * http://mozilla.org/MPL/2.0/.
 */
package org.verapdf.model.xmplayer;
		
import org.verapdf.model.baselayer.Object;
import java.util.Set;

		
/**
* Extension schema field definition
*/
public interface ExtensionSchemaField extends ExtensionSchemaObject {
	

	/**
	* true if field description (’pdfaField:description’ property) is of type Text
	*/
	public Boolean getisDescriptionValidText();

	/**
	* true if field name (’pdfaField:name’ property) is of type Text
	*/
	public Boolean getisNameValidText();

	/**
	* true if field value type (’pdfaField:valueType’ property) is of type Text
	*/
	public Boolean getisValueTypeValidText();

	/**
	* true if field value type (’pdfaField:valueType’ property) is defined
	*/
	public Boolean getisValueTypeDefined();

	/**
	* namespace prefix for the description field
	*/
	public String getdescriptionPrefix();

	/**
	* namespace prefix for the name field
	*/
	public String getnamePrefix();

	/**
	* namespace prefix for the value type field
	*/
	public String getvalueTypePrefix();
}
