/**
 * This file is part of veraPDF Validation Model API, a module of the veraPDF project.
 * Copyright (c) 2015-2025, veraPDF Consortium <info@verapdf.org>
 * All rights reserved.
 *
 * veraPDF Validation Model API is free software: you can redistribute it and/or modify
 * it under the terms of either:
 *
 * The GNU General public license GPLv3+.
 * You should have received a copy of the GNU General Public License
 * along with veraPDF Validation Model API as the LICENSE.GPL file in the root of the source
 * tree.  If not, see http://www.gnu.org/licenses/ or
 * https://www.gnu.org/licenses/gpl-3.0.en.html.
 *
 * The Mozilla Public License MPLv2+.
 * You should have received a copy of the Mozilla Public License along with
 * veraPDF Validation Model API as the LICENSE.MPL file in the root of the source tree.
 * If a copy of the MPL was not distributed with this file, you can obtain one at
 * http://mozilla.org/MPL/2.0/.
 */
package org.verapdf.model.coslayer;
		
import org.verapdf.model.baselayer.Object;
import org.verapdf.model.pdlayer.PDMetadata;
import org.verapdf.model.pdlayer.PDDocument;
import org.verapdf.model.salayer.SAPDFDocument;
import org.verapdf.model.pdlayer.PDEncryption;
import org.verapdf.model.external.EmbeddedFile;

		
/**
* PDF String type
*/
public interface CosString extends CosObject {
	

	/**
	* internal byte presentation of the string after decoding from hex format (for strings in hexadecimal format) or after decoding all escape sequences (for strings in standard format)
	*/
	public String getvalue();

	/**
	* true if the string is stored in Hex format
	*/
	public Boolean getisHex();

	/**
	* true if the all non-white-space characters if the hexadecimal string belong to the range 0-9, a-f, A-F
	*/
	public Boolean getcontainsOnlyHex();

	/**
	* for hexadecimal strings the number of Hex digits (non-white-space characters in the range 0-9, a-f, A-F); 0 for strings in standard format
	*/
	public Long gethexCount();

	/**
	* true if string value contains codes from Unicode Private Use Area
	*/
	public Boolean getcontainsPUA();
}
