package org.verapdf.model.pdlayer;
		
import org.verapdf.model.baselayer.Object;
import org.verapdf.model.coslayer.CosObject;
import org.verapdf.model.coslayer.CosDict;
import org.verapdf.model.coslayer.CosStream;
import org.verapdf.model.coslayer.CosReal;
import org.verapdf.model.coslayer.CosNumber;
import org.verapdf.model.coslayer.CosRenderingIntent;
import org.verapdf.model.coslayer.CosUnicodeName;
import org.verapdf.model.coslayer.CosIIFilter;
import org.verapdf.model.coslayer.CosBBox;
import org.verapdf.model.coslayer.CosLang;
import org.verapdf.model.operator.Operator;
import org.verapdf.model.external.ICCOutputProfile;
import org.verapdf.model.external.ICCInputProfile;
import org.verapdf.model.external.FontProgram;
import org.verapdf.model.external.CMapFile;
import org.verapdf.model.external.JPEG2000;
import org.verapdf.model.external.PKCSDataObject;
import org.verapdf.model.xmplayer.XMPPackage;

		
/**  PDF font dictionary
 */
public interface PDFont extends PDResource {
	

	/**  font type (Type entry)
	 */
	public String getType();

	/**  font subtype (Subtype entry)
	 */
	public String getSubtype();

	/**  font name defined by BaseFont entry in the font dictionary and FontName key in the font descriptor
	 */
	public String getfontName();


	/**  true if the font flags in the font descriptor dictionary mark indicate that the font is symbolic (the entry /Flags has bit 3 set to 1 and bit 6 set to 0)
	 */
	public Boolean getisSymbolic();

	/**  rendering mode value
	 */
	public Long getrenderingMode();

}
