package org.verapdf.model.xmplayer;
		
import org.verapdf.model.baselayer.Object;
import java.util.List;

		
/**  Extension schema definition from the XMP package
 */
public interface ExtensionSchemaDefinition extends ExtensionSchemaObject {
	



	/**  true if extension schema namespace URI (’pdfaSchema:namespaceURI’ property) is of type URI
	 */
	public Boolean getisNamespaceURIValidURI();

	/**  true if extension schema preferred prefix (’pdfaSchema:prefix’ property) is of type Text
	 */
	public Boolean getisPrefixValidText();

	/**  true if extension schema properties list (’pdfaSchema:property’ property) is of type Seq
	 */
	public Boolean getisPropertyValidSeq();

	/**  true if extension schema description (’pdfaSchema:schema’ property) is of type Text
	 */
	public Boolean getisSchemaValidText();

	/**  true if extension schema value types list (’pdfaSchema:valueType’ property) is of type Seq
	 */
	public Boolean getisValueTypeValidSeq();

	/**  namespace prefix for the extension schema namespace URI property
	 */
	public String getnamespaceURIPrefix();

	/**  namespace prefix for the extension schema prefix property
	 */
	public String getprefixPrefix();

	/**  namespace prefix for the extension schema properties list property
	 */
	public String getpropertyPrefix();

	/**  namespace prefix for the extension schema schema description property
	 */
	public String getschemaPrefix();

	/**  namespace prefix for the extension schema value type list property
	 */
	public String getvalueTypePrefix();
}
