package org.verapdf.model.xmplayer;
		
import org.verapdf.model.baselayer.Object;
import java.util.List;

		
/**  XMP property
 */
public interface XMPProperty extends XMPObject {
	

	/**  true if this property is predefined (available in predefined schema) for PDF/A-1
	 */
	public Boolean getisPredefinedInXMP2004();

	/**  true if this property is predefined (available in predefined schema) for PDF/A-2 or for PDF/A-3
	 */
	public Boolean getisPredefinedInXMP2005();

	/**  true if this property defined in extension schema in current XMP package
	 */
	public Boolean getisDefinedInCurrentPackage();

	/**  true if this property defined in extension schema in main XMP package
	 */
	public Boolean getisDefinedInMainPackage();

	/**  true if the property value type corresponds to the type defined by XMP specification or extension schema
	 */
	public Boolean getisValueTypeCorrect();
}
