/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.features.pb.objects;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.List;
import org.apache.log4j.Logger;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSStream;
import org.apache.pdfbox.cos.COSString;
import org.apache.pdfbox.pdmodel.common.filespecification.PDComplexFileSpecification;
import org.apache.pdfbox.pdmodel.common.filespecification.PDEmbeddedFile;
import org.verapdf.features.objects.EmbeddedFileFeaturesObjectAdapter;

public class PBEmbeddedFileFeaturesObjectAdapter
implements EmbeddedFileFeaturesObjectAdapter {
    private static final Logger LOGGER = Logger.getLogger(PBEmbeddedFileFeaturesObjectAdapter.class);
    private PDComplexFileSpecification embFile;
    private PDEmbeddedFile ef;
    private int index;
    private Calendar creationDate;
    private Calendar modDate;
    private String checkSum;
    private List<String> errors;

    public PBEmbeddedFileFeaturesObjectAdapter(PDComplexFileSpecification embFile, int index) {
        this.embFile = embFile;
        if (this.embFile != null) {
            this.ef = this.embFile.getEmbeddedFile();
            this.init();
        }
        this.index = index;
    }

    public int getIndex() {
        return this.index;
    }

    public String getFileName() {
        if (this.embFile != null) {
            return this.embFile.getFilename();
        }
        return null;
    }

    public String getDescription() {
        if (this.embFile != null) {
            return this.embFile.getFileDescription();
        }
        return null;
    }

    public String getAFRelationship() {
        COSDictionary dict;
        if (this.embFile != null && (dict = this.embFile.getCOSObject()) != null) {
            return dict.getNameAsString(COSName.getPDFName((String)"AFRelationship"));
        }
        return null;
    }

    public String getSubtype() {
        if (this.ef != null) {
            return this.ef.getSubtype();
        }
        return null;
    }

    public String getFilter() {
        if (this.ef != null) {
            return PBEmbeddedFileFeaturesObjectAdapter.getFilters(this.ef.getFilters());
        }
        return null;
    }

    public Calendar getCreationDate() {
        return this.creationDate;
    }

    public Calendar getModDate() {
        return this.modDate;
    }

    public String getCheckSum() {
        return this.checkSum;
    }

    public Long getSize() {
        if (this.ef != null) {
            return this.ef.getSize();
        }
        return null;
    }

    public boolean isPDFObjectPresent() {
        return this.embFile != null;
    }

    public List<String> getErrors() {
        return this.errors == null ? Collections.emptyList() : Collections.unmodifiableList(this.errors);
    }

    private void init() {
        if (this.ef != null) {
            COSBase baseChecksum;
            this.errors = new ArrayList<String>();
            try {
                this.creationDate = this.ef.getCreationDate();
            }
            catch (IOException e) {
                LOGGER.debug((Object)"PDFBox error obtaining creation date", (Throwable)e);
                this.errors.add(e.getMessage());
            }
            try {
                this.modDate = this.ef.getModDate();
            }
            catch (IOException e) {
                LOGGER.debug((Object)"PDFBox error obtaining modification date", (Throwable)e);
                this.errors.add(e.getMessage());
            }
            COSBase baseParams = this.ef.getStream().getDictionaryObject(COSName.PARAMS);
            if (baseParams instanceof COSDictionary && (baseChecksum = ((COSDictionary)baseParams).getDictionaryObject(COSName.getPDFName((String)"CheckSum"))) instanceof COSString) {
                COSString str = (COSString)baseChecksum;
                this.checkSum = str.isHex() ? str.toHexString() : str.getString();
            }
        }
    }

    public InputStream getData() {
        try {
            if (this.ef == null) {
                LOGGER.debug((Object)"Missed embedded file in PDComplexFileSpecification");
                return null;
            }
            COSStream stream = this.ef.getStream();
            if (stream != null) {
                return stream.getUnfilteredStream();
            }
        }
        catch (IOException e) {
            LOGGER.debug((Object)"Can not get embedded file stream", (Throwable)e);
        }
        return null;
    }

    private static String getFilters(List<COSName> list) {
        if (list != null) {
            StringBuilder builder = new StringBuilder();
            for (COSName filter : list) {
                if (filter == null || filter.getName() == null) continue;
                builder.append(filter.getName());
                builder.append(" ");
            }
            return builder.toString().trim();
        }
        return null;
    }
}

