/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.model.impl.pb.pd;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSString;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDDocumentCatalog;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageTree;
import org.apache.pdfbox.pdmodel.common.COSObjectable;
import org.apache.pdfbox.pdmodel.common.PDDestinationOrAction;
import org.apache.pdfbox.pdmodel.documentinterchange.logicalstructure.PDStructureTreeRoot;
import org.apache.pdfbox.pdmodel.graphics.optionalcontent.PDOptionalContentProperties;
import org.apache.pdfbox.pdmodel.interactive.action.PDDocumentCatalogAdditionalActions;
import org.verapdf.model.coslayer.CosLang;
import org.verapdf.model.impl.pb.cos.PBCosLang;
import org.verapdf.model.impl.pb.pd.PBoxOutputIntents;
import org.verapdf.model.impl.pb.pd.PBoxPDAcroForm;
import org.verapdf.model.impl.pb.pd.PBoxPDMetadata;
import org.verapdf.model.impl.pb.pd.PBoxPDOCProperties;
import org.verapdf.model.impl.pb.pd.PBoxPDObject;
import org.verapdf.model.impl.pb.pd.PBoxPDPage;
import org.verapdf.model.impl.pb.pd.PBoxPDStructTreeRoot;
import org.verapdf.model.impl.pb.pd.actions.PBoxPDAction;
import org.verapdf.model.impl.pb.pd.actions.PBoxPDCatalogAdditionalActions;
import org.verapdf.model.impl.pb.pd.signatures.PBoxPDPerms;
import org.verapdf.model.pdlayer.OutputIntents;
import org.verapdf.model.pdlayer.PDAcroForm;
import org.verapdf.model.pdlayer.PDAction;
import org.verapdf.model.pdlayer.PDAdditionalActions;
import org.verapdf.model.pdlayer.PDMetadata;
import org.verapdf.model.pdlayer.PDOCProperties;
import org.verapdf.model.pdlayer.PDOutline;
import org.verapdf.model.pdlayer.PDPerms;
import org.verapdf.model.pdlayer.PDStructTreeRoot;
import org.verapdf.model.tools.OutlinesHelper;
import org.verapdf.pdfa.flavours.PDFAFlavour;

public class PBoxPDDocument
extends PBoxPDObject
implements org.verapdf.model.pdlayer.PDDocument {
    private static final Logger LOGGER = Logger.getLogger(PBoxPDDocument.class.getCanonicalName());
    public static final String PD_DOCUMENT_TYPE = "PDDocument";
    public static final String PAGES = "pages";
    public static final String METADATA = "metadata";
    public static final String OUTPUT_INTENTS = "outputIntents";
    public static final String ACRO_FORMS = "AcroForm";
    public static final String ACTIONS = "AA";
    public static final String OPEN_ACTION = "OpenAction";
    public static final String OUTLINES = "Outlines";
    public static final String STRUCTURE_TREE_ROOT = "StructTreeRoot";
    public static final String ALTERNATE_PRESENTATIONS = "AlternatePresentations";
    public static final String OC_PROPERTIES = "OCProperties";
    public static final String LANG = "Lang";
    public static final String PERMS = "Perms";
    private final PDDocumentCatalog catalog = this.document.getDocumentCatalog();
    private final PDFAFlavour flavour;
    private OutputIntents outputIntents = null;

    public PBoxPDDocument(PDDocument document, PDFAFlavour flavour) {
        super(document, PD_DOCUMENT_TYPE);
        this.flavour = flavour;
    }

    public Boolean getcontainsAA() {
        return this.catalog != null && this.catalog.getCOSObject().containsKey(COSName.AA);
    }

    public String getVersion() {
        return this.catalog.getVersion();
    }

    public String getmostCommonOrientation() {
        List twoTheMostFrequent = this.getPages().stream().map(org.verapdf.model.pdlayer.PDPage::getorientation).collect(Collectors.groupingBy(a -> a, Collectors.counting())).entrySet().stream().sorted(Map.Entry.comparingByValue().reversed()).limit(2L).map(Map.Entry::getKey).collect(Collectors.toList());
        return "Square".equals(twoTheMostFrequent.get(0)) && twoTheMostFrequent.size() == 2 ? (String)twoTheMostFrequent.get(1) : (String)twoTheMostFrequent.get(0);
    }

    public Boolean getcontainsXRefStream() {
        return false;
    }

    public List<? extends org.verapdf.model.baselayer.Object> getLinkedObjects(String link) {
        switch (link) {
            case "Outlines": {
                return this.getOutlines();
            }
            case "OpenAction": {
                return this.getOpenAction();
            }
            case "AA": {
                return this.getActions();
            }
            case "pages": {
                return this.getPages();
            }
            case "metadata": {
                return this.getMetadata();
            }
            case "outputIntents": {
                return this.getOutputIntents();
            }
            case "AcroForm": {
                return this.getAcroForms();
            }
            case "StructTreeRoot": {
                return this.getStructureTreeRoot();
            }
            case "OCProperties": {
                return this.getOCProperties();
            }
            case "Lang": {
                return this.getLang();
            }
            case "Perms": {
                return this.getPerms();
            }
        }
        return super.getLinkedObjects(link);
    }

    private List<OutputIntents> getOutputIntents() {
        if (this.outputIntents == null) {
            this.outputIntents = this.parseOutputIntents();
        }
        if (this.outputIntents != null) {
            ArrayList<OutputIntents> array = new ArrayList<OutputIntents>(1);
            array.add(this.outputIntents);
            return array;
        }
        return Collections.emptyList();
    }

    public String getoutputColorSpace() {
        if (this.outputIntents == null) {
            this.outputIntents = this.parseOutputIntents();
        }
        return this.outputIntents != null ? ((PBoxOutputIntents)this.outputIntents).getColorSpace() : null;
    }

    private OutputIntents parseOutputIntents() {
        List outInts;
        if (this.catalog != null && (outInts = this.catalog.getOutputIntents()).size() > 0) {
            return new PBoxOutputIntents(outInts, this.document, this.flavour);
        }
        return null;
    }

    private List<PDOutline> getOutlines() {
        return OutlinesHelper.getOutlines(this.catalog);
    }

    private List<PDAction> getOpenAction() {
        if (this.catalog != null) {
            try {
                PDDestinationOrAction openAction = this.catalog.getOpenAction();
                if (openAction instanceof org.apache.pdfbox.pdmodel.interactive.action.PDAction) {
                    ArrayList<PDAction> actions = new ArrayList<PDAction>(1);
                    PDAction action = PBoxPDAction.getAction((org.apache.pdfbox.pdmodel.interactive.action.PDAction)openAction);
                    if (action != null) {
                        actions.add(action);
                        return Collections.unmodifiableList(actions);
                    }
                }
            }
            catch (IOException e) {
                LOGGER.log(Level.INFO, "Problems with open action obtaining. " + e.getMessage());
            }
        }
        return Collections.emptyList();
    }

    private List<PDAdditionalActions> getActions() {
        PDDocumentCatalogAdditionalActions pbActions = this.getAdditionalAction();
        if (pbActions != null && pbActions.getCOSObject().size() != 0) {
            ArrayList<PBoxPDCatalogAdditionalActions> actions = new ArrayList<PBoxPDCatalogAdditionalActions>(1);
            actions.add(new PBoxPDCatalogAdditionalActions((COSObjectable)pbActions));
            return Collections.unmodifiableList(actions);
        }
        return Collections.emptyList();
    }

    private PDDocumentCatalogAdditionalActions getAdditionalAction() {
        COSDictionary catalogLocal;
        COSBase aaDictionary;
        if (this.catalog != null && (aaDictionary = (catalogLocal = this.catalog.getCOSObject()).getDictionaryObject(COSName.AA)) instanceof COSDictionary) {
            return new PDDocumentCatalogAdditionalActions((COSDictionary)aaDictionary);
        }
        return null;
    }

    private List<org.verapdf.model.pdlayer.PDPage> getPages() {
        PDPageTree pageTree = this.document.getPages();
        ArrayList<PBoxPDPage> pages = new ArrayList<PBoxPDPage>(pageTree.getCount());
        for (PDPage page : pageTree) {
            pages.add(new PBoxPDPage(page, this.document, this.flavour));
        }
        return Collections.unmodifiableList(pages);
    }

    private List<PDMetadata> getMetadata() {
        org.apache.pdfbox.pdmodel.common.PDMetadata meta;
        if (this.catalog != null && (meta = this.catalog.getMetadata()) != null && PBoxPDMetadata.isMetadataObject(meta.getCOSObject())) {
            ArrayList<PBoxPDMetadata> metadata = new ArrayList<PBoxPDMetadata>(1);
            metadata.add(new PBoxPDMetadata(meta, Boolean.TRUE, this.document, this.flavour));
            return Collections.unmodifiableList(metadata);
        }
        return Collections.emptyList();
    }

    private List<PDAcroForm> getAcroForms() {
        org.apache.pdfbox.pdmodel.interactive.form.PDAcroForm form;
        if (this.catalog != null && (form = this.catalog.getAcroForm()) != null) {
            ArrayList<PBoxPDAcroForm> forms = new ArrayList<PBoxPDAcroForm>(1);
            forms.add(new PBoxPDAcroForm(form, this.document, this.flavour));
            return Collections.unmodifiableList(forms);
        }
        return Collections.emptyList();
    }

    private List<PDStructTreeRoot> getStructureTreeRoot() {
        PDStructureTreeRoot root;
        if (this.catalog != null && (root = this.catalog.getStructureTreeRoot()) != null) {
            ArrayList<PBoxPDStructTreeRoot> treeRoot = new ArrayList<PBoxPDStructTreeRoot>(1);
            treeRoot.add(new PBoxPDStructTreeRoot(root, this.flavour));
            return Collections.unmodifiableList(treeRoot);
        }
        return Collections.emptyList();
    }

    private List<PDPerms> getPerms() {
        COSDictionary perms;
        if (this.catalog != null && (perms = (COSDictionary)this.catalog.getCOSObject().getDictionaryObject(COSName.PERMS)) != null) {
            ArrayList<PBoxPDPerms> list = new ArrayList<PBoxPDPerms>(1);
            list.add(new PBoxPDPerms(perms));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    public Boolean getcontainsAlternatePresentations() {
        COSBase alternatePresentations;
        COSDictionary rawCatalog;
        COSDictionary namesDictionary;
        if (this.catalog != null && (namesDictionary = (COSDictionary)(rawCatalog = this.catalog.getCOSObject()).getDictionaryObject(COSName.NAMES)) != null && (alternatePresentations = namesDictionary.getDictionaryObject(COSName.getPDFName((String)ALTERNATE_PRESENTATIONS))) != null) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public Boolean getvalidPDF() {
        return Boolean.TRUE;
    }

    private List<PDOCProperties> getOCProperties() {
        PDOptionalContentProperties pBoxOCProperties;
        if (this.catalog != null && (pBoxOCProperties = this.catalog.getOCProperties()) != null) {
            ArrayList<PDOCProperties> result = new ArrayList<PDOCProperties>();
            PBoxPDOCProperties ocProperties = new PBoxPDOCProperties((COSObjectable)pBoxOCProperties);
            result.add(ocProperties);
            return result;
        }
        return Collections.emptyList();
    }

    private List<CosLang> getLang() {
        COSBase baseLang;
        if (this.catalog != null && (baseLang = this.catalog.getCOSObject().getDictionaryObject(COSName.LANG)) instanceof COSString) {
            ArrayList<PBCosLang> list = new ArrayList<PBCosLang>(1);
            list.add(new PBCosLang((COSString)baseLang));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }
}

