/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.model.tools;

import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.pdmodel.font.PDCIDFont;
import org.apache.pdfbox.pdmodel.font.PDCIDFontType0;
import org.apache.pdfbox.pdmodel.font.PDCIDFontType2;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.font.PDSimpleFont;
import org.apache.pdfbox.pdmodel.font.PDTrueTypeFont;
import org.apache.pdfbox.pdmodel.font.PDType0Font;
import org.apache.pdfbox.pdmodel.font.PDType3Font;
import org.apache.pdfbox.preflight.font.container.CIDType0Container;
import org.apache.pdfbox.preflight.font.container.CIDType2Container;
import org.apache.pdfbox.preflight.font.container.FontContainer;
import org.apache.pdfbox.preflight.font.container.TrueTypeContainer;
import org.apache.pdfbox.preflight.font.container.Type0Container;
import org.apache.pdfbox.preflight.font.container.Type1Container;
import org.apache.pdfbox.preflight.font.container.Type3Container;

public class FontHelper {
    public static final String CID_FONT_TYPE_0 = "CIDFontType0";
    public static final String CID_FONT_TYPE_2 = "CIDFontType2";

    public static FontContainer getFontContainer(PDFont font) {
        if (font == null) {
            return null;
        }
        switch (font.getSubType()) {
            case "Type1": 
            case "MMType1": {
                return new Type1Container((PDSimpleFont)font);
            }
            case "TrueType": {
                return new TrueTypeContainer((PDTrueTypeFont)font);
            }
            case "Type3": {
                return new Type3Container((PDType3Font)font);
            }
            case "Type0": {
                Type0Container container = new Type0Container(font);
                PDCIDFont pdcidFont = ((PDType0Font)font).getDescendantFont();
                String cidType = pdcidFont.getCOSObject().getNameAsString(COSName.SUBTYPE);
                if (CID_FONT_TYPE_0.equals(cidType)) {
                    CIDType0Container type0Container = new CIDType0Container((PDCIDFontType0)pdcidFont);
                    container.setDelegateFontContainer((FontContainer)type0Container);
                } else if (CID_FONT_TYPE_2.equals(cidType)) {
                    CIDType2Container type2Container = new CIDType2Container((PDCIDFontType2)pdcidFont);
                    container.setDelegateFontContainer((FontContainer)type2Container);
                }
                return container;
            }
        }
        return null;
    }
}

