/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.model.factory.operator;

import java.io.IOException;
import org.apache.log4j.Logger;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSNumber;
import org.apache.pdfbox.pdmodel.graphics.color.PDColorSpace;
import org.apache.pdfbox.pdmodel.graphics.color.PDDeviceGray;
import org.apache.pdfbox.pdmodel.graphics.pattern.PDAbstractPattern;
import org.apache.pdfbox.pdmodel.graphics.state.PDExtendedGraphicsState;
import org.apache.pdfbox.pdmodel.graphics.state.RenderingMode;
import org.bouncycastle.util.Arrays;
import org.verapdf.model.impl.pb.pd.colors.PBoxPDColorSpace;
import org.verapdf.model.impl.pb.pd.font.PBoxPDFont;
import org.verapdf.model.impl.pb.pd.images.PBoxPDXObject;

public class GraphicState
implements Cloneable {
    private static final Logger LOGGER = Logger.getLogger(GraphicState.class);
    private PDColorSpace fillColorSpace = PDDeviceGray.INSTANCE;
    private PDColorSpace strokeColorSpace = PDDeviceGray.INSTANCE;
    private PDAbstractPattern fillPattern = null;
    private PDAbstractPattern strokePattern = null;
    private RenderingMode renderingMode = RenderingMode.FILL;
    private COSName fontName;
    private boolean overprintingFlagStroke = false;
    private boolean overprintingFlagNonStroke = false;
    private int opm = 0;
    private COSBase sMask = null;
    private float ca = 1.0f;
    private float ca_ns = 1.0f;
    private COSBase bm = null;
    private PBoxPDXObject veraXObject = null;
    private PBoxPDColorSpace veraFillColorSpace = null;
    private PBoxPDColorSpace veraStrokeColorSpace = null;
    private PBoxPDFont veraFont = null;
    private byte[] charCodes = null;

    public PDColorSpace getFillColorSpace() {
        return this.fillColorSpace;
    }

    public void setFillColorSpace(PDColorSpace fillColorSpace) {
        this.fillColorSpace = fillColorSpace;
    }

    public PDColorSpace getStrokeColorSpace() {
        return this.strokeColorSpace;
    }

    public void setStrokeColorSpace(PDColorSpace strokeColorSpace) {
        this.strokeColorSpace = strokeColorSpace;
    }

    public PDAbstractPattern getFillPattern() {
        return this.fillPattern;
    }

    public void setFillPattern(PDAbstractPattern fillPattern) {
        this.fillPattern = fillPattern;
    }

    public PDAbstractPattern getStrokePattern() {
        return this.strokePattern;
    }

    public void setStrokePattern(PDAbstractPattern strokePattern) {
        this.strokePattern = strokePattern;
    }

    public PBoxPDColorSpace getVeraFillColorSpace() {
        return this.veraFillColorSpace;
    }

    public void setVeraFillColorSpace(PBoxPDColorSpace veraFillColorSpace) {
        this.veraFillColorSpace = veraFillColorSpace;
    }

    public PBoxPDColorSpace getVeraStrokeColorSpace() {
        return this.veraStrokeColorSpace;
    }

    public void setVeraStrokeColorSpace(PBoxPDColorSpace veraStrokeColorSpace) {
        this.veraStrokeColorSpace = veraStrokeColorSpace;
    }

    public PBoxPDFont getVeraFont() {
        return this.veraFont;
    }

    public void setVeraFont(PBoxPDFont veraFont) {
        this.veraFont = veraFont;
    }

    public RenderingMode getRenderingMode() {
        return this.renderingMode;
    }

    public void setRenderingMode(RenderingMode renderingMode) {
        this.renderingMode = renderingMode;
    }

    public COSName getFontName() {
        return this.fontName;
    }

    public void setFontName(COSName fontName) {
        this.fontName = fontName;
    }

    public COSBase getSMask() {
        return this.sMask;
    }

    public void setSMask(COSBase sMask) {
        this.sMask = sMask;
    }

    public float getCa() {
        return this.ca;
    }

    public void setCa(float ca) {
        this.ca = ca;
    }

    public float getCa_ns() {
        return this.ca_ns;
    }

    public void setCa_ns(float ca_ns) {
        this.ca_ns = ca_ns;
    }

    public COSBase getBm() {
        return this.bm;
    }

    public void setBm(COSBase bm) {
        this.bm = bm;
    }

    public PBoxPDXObject getVeraXObject() {
        return this.veraXObject;
    }

    public void setVeraXObject(PBoxPDXObject veraXObject) {
        this.veraXObject = veraXObject;
    }

    public byte[] getCharCodes() {
        return this.charCodes;
    }

    public void setCharCodes(byte[] charCodes) {
        this.charCodes = Arrays.clone((byte[])charCodes);
    }

    public boolean isOverprintingFlagStroke() {
        return this.overprintingFlagStroke;
    }

    public void setOverprintingFlagStroke(boolean overprintingFlagStroke) {
        this.overprintingFlagStroke = overprintingFlagStroke;
    }

    public boolean isOverprintingFlagNonStroke() {
        return this.overprintingFlagNonStroke;
    }

    public void setOverprintingFlagNonStroke(boolean overprintingFlagNonStroke) {
        this.overprintingFlagNonStroke = overprintingFlagNonStroke;
    }

    public int getOpm() {
        return this.opm;
    }

    public void setOpm(int opm) {
        this.opm = opm;
    }

    public void copyProperties(GraphicState graphicState) {
        this.fillColorSpace = graphicState.getFillColorSpace();
        this.strokeColorSpace = graphicState.getStrokeColorSpace();
        this.fillPattern = graphicState.getFillPattern();
        this.strokePattern = graphicState.getStrokePattern();
        this.renderingMode = graphicState.getRenderingMode();
        this.fontName = graphicState.getFontName();
        this.sMask = graphicState.getSMask();
        this.ca_ns = graphicState.getCa_ns();
        this.ca = graphicState.getCa();
        this.bm = graphicState.getBm();
        this.veraXObject = graphicState.getVeraXObject();
        this.veraFillColorSpace = graphicState.getVeraFillColorSpace();
        this.veraStrokeColorSpace = graphicState.getVeraStrokeColorSpace();
        this.veraFont = graphicState.getVeraFont();
        this.charCodes = graphicState.getCharCodes();
        this.overprintingFlagStroke = graphicState.isOverprintingFlagStroke();
        this.overprintingFlagNonStroke = graphicState.isOverprintingFlagNonStroke();
        this.opm = graphicState.getOpm();
    }

    public void copyPropertiesFromExtGState(PDExtendedGraphicsState extGState) {
        if (extGState != null) {
            try {
                Float overprintMode;
                COSBase ca_base;
                COSBase ca_ns_base;
                COSBase bm;
                COSDictionary cosObject;
                COSBase smask;
                if (extGState.getFontSetting() != null) {
                    this.fontName = COSName.getPDFName((String)extGState.getFontSetting().getFont().getName());
                }
                if ((smask = (cosObject = extGState.getCOSObject()).getDictionaryObject(COSName.SMASK)) != null) {
                    this.sMask = smask;
                }
                if ((bm = cosObject.getDictionaryObject(COSName.BM)) != null) {
                    this.bm = bm;
                }
                if ((ca_ns_base = cosObject.getDictionaryObject(COSName.CA_NS)) instanceof COSNumber) {
                    this.ca_ns = ((COSNumber)ca_ns_base).floatValue();
                }
                if ((ca_base = cosObject.getDictionaryObject(COSName.CA)) instanceof COSNumber) {
                    this.ca = ((COSNumber)ca_base).floatValue();
                }
                if ((overprintMode = extGState.getOverprintMode()) != null) {
                    this.opm = overprintMode.intValue();
                }
                this.overprintingFlagStroke = extGState.getStrokingOverprintControl();
                this.overprintingFlagNonStroke = extGState.getNonStrokingOverprintControl();
            }
            catch (IOException e) {
                LOGGER.error((Object)e);
            }
        }
    }

    public GraphicState clone() throws CloneNotSupportedException {
        GraphicState graphicState = (GraphicState)super.clone();
        graphicState.fillColorSpace = this.fillColorSpace;
        graphicState.strokeColorSpace = this.strokeColorSpace;
        graphicState.fillPattern = this.fillPattern;
        graphicState.strokePattern = this.strokePattern;
        graphicState.renderingMode = this.renderingMode;
        graphicState.fontName = this.fontName;
        graphicState.sMask = this.sMask;
        graphicState.ca_ns = this.ca_ns;
        graphicState.ca = this.ca;
        graphicState.bm = this.bm;
        graphicState.veraXObject = this.veraXObject;
        graphicState.veraFillColorSpace = this.veraFillColorSpace;
        graphicState.veraStrokeColorSpace = this.veraStrokeColorSpace;
        graphicState.veraFont = this.veraFont;
        graphicState.charCodes = this.charCodes;
        graphicState.opm = this.opm;
        graphicState.overprintingFlagStroke = this.overprintingFlagStroke;
        graphicState.overprintingFlagNonStroke = this.overprintingFlagNonStroke;
        return graphicState;
    }
}

