/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.model.impl.pb.pd;

import java.util.List;
import org.apache.log4j.Logger;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSString;
import org.apache.pdfbox.pdmodel.common.COSObjectable;
import org.verapdf.model.impl.pb.pd.PBoxPDObject;
import org.verapdf.model.pdlayer.PDOCConfig;

public class PBoxPDOCConfig
extends PBoxPDObject
implements PDOCConfig {
    public static final Logger LOGGER = Logger.getLogger(PBoxPDOCConfig.class);
    public static final String OC_CONFIG_TYPE = "PDOCConfig";
    public static final String EVENT_KEY = "Event";
    private final List<String> groupNames;
    private final boolean duplicateName;

    public PBoxPDOCConfig(COSObjectable simplePDObject) {
        super(simplePDObject, OC_CONFIG_TYPE);
        this.groupNames = null;
        this.duplicateName = false;
    }

    public PBoxPDOCConfig(COSObjectable simplePDObject, List<String> groupNames, boolean duplicateName) {
        super(simplePDObject, OC_CONFIG_TYPE);
        this.groupNames = groupNames;
        this.duplicateName = duplicateName;
    }

    public Boolean getdoesOrderContainAllOCGs() {
        COSBase order = ((COSDictionary)this.simplePDObject).getDictionaryObject(COSName.ORDER);
        if (order != null) {
            if (order instanceof COSArray) {
                int groupsInOrder = 0;
                for (int i = 0; i < ((COSArray)order).size(); ++i) {
                    COSBase element = ((COSArray)order).getObject(i);
                    if (element instanceof COSArray) {
                        groupsInOrder += ((COSArray)element).size();
                        if (this.checkCOSArrayInOrder((COSArray)element).booleanValue()) continue;
                        return Boolean.FALSE;
                    }
                    if (element instanceof COSString) {
                        ++groupsInOrder;
                        if (this.checkCOSStringInOrder((COSString)element).booleanValue()) continue;
                        return Boolean.FALSE;
                    }
                    if (element instanceof COSDictionary) {
                        ++groupsInOrder;
                        if (this.checkCOSDictionaryInOrder((COSDictionary)element).booleanValue()) continue;
                        return Boolean.FALSE;
                    }
                    LOGGER.warn((Object)"Invalid object type in order array. Ignoring the object.");
                }
                if (groupsInOrder < this.groupNames.size()) {
                    return Boolean.FALSE;
                }
            } else {
                LOGGER.warn((Object)"Invalid object type of Order entry. Ignoring the Order entry.");
            }
        }
        return Boolean.TRUE;
    }

    public String getAS() {
        COSBase asArray = ((COSDictionary)this.simplePDObject).getDictionaryObject(COSName.AS);
        if (asArray != null) {
            String result = "";
            if (asArray instanceof COSArray) {
                for (int i = 0; i < ((COSArray)asArray).size(); ++i) {
                    COSBase element = ((COSArray)asArray).getObject(i);
                    if (element instanceof COSDictionary) {
                        String event = ((COSDictionary)element).getString(EVENT_KEY);
                        if (event == null || event.isEmpty()) continue;
                        result = result.concat(event);
                        continue;
                    }
                    LOGGER.warn((Object)"Invalid object type in the AS array. Ignoring the object.");
                }
                return result;
            }
            LOGGER.warn((Object)"Invalid object type of AS entry. Ignoring the entry.");
            return result;
        }
        return null;
    }

    public Boolean gethasDuplicateName() {
        return this.duplicateName;
    }

    public String getName() {
        return ((COSDictionary)this.simplePDObject).getString(COSName.NAME);
    }

    private Boolean checkCOSArrayInOrder(COSArray array) {
        for (int i = 0; i < array.size(); ++i) {
            COSBase element = array.getObject(i);
            if (!(element instanceof COSString ? this.checkCOSStringInOrder((COSString)element) == false : element instanceof COSDictionary && this.checkCOSDictionaryInOrder((COSDictionary)element) == false)) continue;
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    private Boolean checkCOSStringInOrder(COSString element) {
        if (!this.groupNames.contains(element.getString())) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    private Boolean checkCOSDictionaryInOrder(COSDictionary element) {
        if (!this.groupNames.contains(element.getString(COSName.NAME))) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }
}

