/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.model.impl.pb.pd;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.log4j.Logger;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.pdmodel.common.COSObjectable;
import org.apache.pdfbox.pdmodel.graphics.optionalcontent.PDOptionalContentProperties;
import org.verapdf.model.baselayer.Object;
import org.verapdf.model.impl.pb.pd.PBoxPDOCConfig;
import org.verapdf.model.impl.pb.pd.PBoxPDObject;
import org.verapdf.model.pdlayer.PDOCConfig;
import org.verapdf.model.pdlayer.PDOCProperties;

public class PBoxPDOCProperties
extends PBoxPDObject
implements PDOCProperties {
    private static final Logger LOGGER = Logger.getLogger(PBoxPDOCProperties.class);
    public static final String OC_PROPERTIES_TYPE = "PDOCProperties";
    public static final String D = "D";
    public static final String CONFIGS = "Configs";

    public PBoxPDOCProperties(COSObjectable simplePDObject) {
        super(simplePDObject, OC_PROPERTIES_TYPE);
    }

    public List<? extends Object> getLinkedObjects(String link) {
        switch (link) {
            case "D": {
                return this.getD();
            }
            case "Configs": {
                return this.getConfigs();
            }
        }
        return super.getLinkedObjects(link);
    }

    private List<PDOCConfig> getD() {
        ArrayList<PDOCConfig> result = new ArrayList<PDOCConfig>();
        COSBase contentProperties = this.simplePDObject.getCOSObject();
        if (contentProperties instanceof COSDictionary) {
            COSDictionary defaultConfig = (COSDictionary)((COSDictionary)contentProperties).getDictionaryObject(COSName.D);
            String[] groupNames = ((PDOptionalContentProperties)this.simplePDObject).getGroupNames();
            List<String> groupNamesList = Arrays.asList(groupNames);
            PBoxPDOCConfig pdConfig = new PBoxPDOCConfig((COSObjectable)defaultConfig, groupNamesList, false);
            result.add(pdConfig);
            return result;
        }
        LOGGER.warn((java.lang.Object)"Invalid object type of the default optional configuration dictionary. Returning empty config.");
        PBoxPDOCConfig config = new PBoxPDOCConfig((COSObjectable)new COSDictionary());
        result.add(config);
        return result;
    }

    private List<PDOCConfig> getConfigs() {
        COSDictionary contentProperties = (COSDictionary)this.simplePDObject.getCOSObject();
        List<String> names = this.getAllNames(contentProperties);
        String[] groupNames = ((PDOptionalContentProperties)this.simplePDObject).getGroupNames();
        List<String> groupNamesList = Arrays.asList(groupNames);
        COSArray configs = (COSArray)contentProperties.getDictionaryObject(CONFIGS);
        if (configs != null) {
            ArrayList<PDOCConfig> result = new ArrayList<PDOCConfig>();
            for (int i = 0; i < configs.size(); ++i) {
                COSBase config = configs.get(i);
                if (config instanceof COSDictionary) {
                    PBoxPDOCConfig pdConfig = new PBoxPDOCConfig((COSObjectable)config, groupNamesList, names.contains(((COSDictionary)config).getString(COSName.NAME)));
                    result.add(pdConfig);
                    continue;
                }
                LOGGER.warn((java.lang.Object)"Invalid object type of the configuration dictionary. Ignoring config.");
            }
            return result;
        }
        return Collections.emptyList();
    }

    private List<String> getAllNames(COSDictionary contentProperties) {
        COSArray configs;
        String name;
        ArrayList<String> result = new ArrayList<String>();
        COSBase defaultConfig = contentProperties.getDictionaryObject(COSName.D);
        if (defaultConfig instanceof COSDictionary && (name = ((COSDictionary)defaultConfig).getString(COSName.NAME)) != null) {
            result.add(name);
        }
        if ((configs = (COSArray)contentProperties.getDictionaryObject(CONFIGS)) != null) {
            for (int i = 0; i < configs.size(); ++i) {
                String name2;
                COSBase config = configs.get(i);
                if (!(config instanceof COSDictionary) || (name2 = ((COSDictionary)config).getString(COSName.NAME)) == null) continue;
                result.add(name2);
            }
        }
        return result;
    }
}

