/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.model.impl.pb.cos;

import java.io.IOException;
import java.io.InputStream;
import java.util.Calendar;
import java.util.List;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSDocument;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSNull;
import org.apache.pdfbox.cos.COSStream;
import org.apache.pdfbox.cos.COSString;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.verapdf.model.coslayer.CosInfo;
import org.verapdf.model.impl.pb.cos.PBCosDict;
import org.verapdf.model.tools.XMPChecker;
import org.verapdf.pdfa.flavours.PDFAFlavour;
import org.verapdf.xmp.XMPException;
import org.verapdf.xmp.impl.VeraPDFMeta;

public class PBCosInfo
extends PBCosDict
implements CosInfo {
    public static final String INFORMATION_TYPE = "CosInfo";
    private static final String timeRegex = "(D:)?(\\d\\d){2,7}((([+-](\\d\\d[']))(\\d\\d['])?)?|[Z])";
    private VeraPDFMeta meta;

    public PBCosInfo(COSDictionary dictionary, PDDocument document, PDFAFlavour flavour) {
        super(dictionary, INFORMATION_TYPE, document, flavour);
        this.meta = this.parseMetadata(document.getDocument());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private VeraPDFMeta parseMetadata(COSDocument document) {
        try (COSStream metadataStream = XMPChecker.getMetadataDictionary(document);){
            if (metadataStream == null) return null;
            VeraPDFMeta veraPDFMeta = VeraPDFMeta.parse((InputStream)metadataStream.getUnfilteredStream());
            return veraPDFMeta;
        }
        catch (IOException | XMPException throwable) {
            // empty catch block
        }
        return null;
    }

    public String getModDate() {
        return ((COSDictionary)this.baseObject).getString(COSName.MOD_DATE);
    }

    public String getCreationDate() {
        return ((COSDictionary)this.baseObject).getString(COSName.CREATION_DATE);
    }

    public String getTitle() {
        return this.getStringProperty(COSName.TITLE);
    }

    public String getXMPTitle() {
        if (this.meta != null) {
            try {
                return this.meta.getTitle();
            }
            catch (XMPException xMPException) {
                // empty catch block
            }
        }
        return null;
    }

    public String getAuthor() {
        return this.getStringProperty(COSName.AUTHOR);
    }

    public String getXMPCreator() {
        if (this.meta != null) {
            try {
                List creator = this.meta.getCreator();
                if (creator != null) {
                    return String.join((CharSequence)",", creator);
                }
            }
            catch (XMPException xMPException) {
                // empty catch block
            }
        }
        return null;
    }

    public String getSubject() {
        return this.getStringProperty(COSName.SUBJECT);
    }

    public String getProducer() {
        return this.getStringProperty(COSName.PRODUCER);
    }

    public String getCreator() {
        return this.getStringProperty(COSName.CREATOR);
    }

    public String getKeywords() {
        return this.getStringProperty(COSName.KEYWORDS);
    }

    public String getXMPProducer() {
        if (this.meta != null) {
            try {
                return this.meta.getProducer();
            }
            catch (XMPException xMPException) {
                // empty catch block
            }
        }
        return null;
    }

    public String getXMPCreatorTool() {
        if (this.meta != null) {
            try {
                return this.meta.getCreatorTool();
            }
            catch (XMPException xMPException) {
                // empty catch block
            }
        }
        return null;
    }

    public String getXMPKeywords() {
        if (this.meta != null) {
            try {
                return this.meta.getKeywords();
            }
            catch (XMPException xMPException) {
                // empty catch block
            }
        }
        return null;
    }

    public String getXMPDescription() {
        if (this.meta != null) {
            try {
                return this.meta.getDescription();
            }
            catch (XMPException xMPException) {
                // empty catch block
            }
        }
        return null;
    }

    public Boolean getdoCreationDatesMatch() {
        Calendar xmpCreateDate = null;
        if (this.meta != null) {
            try {
                xmpCreateDate = this.meta.getCreateDate();
            }
            catch (XMPException xMPException) {
                // empty catch block
            }
        }
        COSBase creationDate = ((COSDictionary)this.baseObject).getItem(COSName.CREATION_DATE);
        if (xmpCreateDate != null && creationDate != null) {
            Calendar creationDateCalendar = this.getCalendar(creationDate);
            return creationDateCalendar != null && xmpCreateDate.compareTo(creationDateCalendar) == 0;
        }
        return null;
    }

    public Boolean getdoModDatesMatch() {
        Calendar xmpModifyDate = null;
        if (this.meta != null) {
            try {
                xmpModifyDate = this.meta.getModifyDate();
            }
            catch (XMPException xMPException) {
                // empty catch block
            }
        }
        COSBase modDate = ((COSDictionary)this.baseObject).getItem(COSName.MOD_DATE);
        if (xmpModifyDate != null && modDate != null) {
            Calendar modDateCalendar = this.getCalendar(modDate);
            return modDateCalendar != null && xmpModifyDate.compareTo(modDateCalendar) == 0;
        }
        return null;
    }

    private Calendar getCalendar(COSBase object) {
        String ascii;
        if (object instanceof COSString && (ascii = ((COSString)object).getASCII()).matches(timeRegex)) {
            return XMPChecker.getCalendar(ascii);
        }
        return null;
    }

    public String getXMPCreateDate() {
        return null;
    }

    public String getXMPModifyDate() {
        return null;
    }

    private String getStringProperty(COSName name) {
        COSBase value = ((COSDictionary)this.baseObject).getItem(name);
        if (value != null && !(value instanceof COSNull)) {
            if (value instanceof COSString) {
                return XMPChecker.getStringWithoutTrailingZero(((COSString)value).getString());
            }
            return value.toString();
        }
        return null;
    }
}

