/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.model.visitor.cos.pb;

import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBoolean;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSDocument;
import org.apache.pdfbox.cos.COSFloat;
import org.apache.pdfbox.cos.COSInteger;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSNull;
import org.apache.pdfbox.cos.COSNumber;
import org.apache.pdfbox.cos.COSObject;
import org.apache.pdfbox.cos.COSStream;
import org.apache.pdfbox.cos.COSString;
import org.apache.pdfbox.cos.ICOSVisitor;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.verapdf.model.impl.pb.cos.PBCosArray;
import org.verapdf.model.impl.pb.cos.PBCosBool;
import org.verapdf.model.impl.pb.cos.PBCosDict;
import org.verapdf.model.impl.pb.cos.PBCosDocument;
import org.verapdf.model.impl.pb.cos.PBCosFileSpecification;
import org.verapdf.model.impl.pb.cos.PBCosIndirect;
import org.verapdf.model.impl.pb.cos.PBCosInteger;
import org.verapdf.model.impl.pb.cos.PBCosName;
import org.verapdf.model.impl.pb.cos.PBCosNull;
import org.verapdf.model.impl.pb.cos.PBCosReal;
import org.verapdf.model.impl.pb.cos.PBCosStream;
import org.verapdf.model.impl.pb.cos.PBCosString;
import org.verapdf.pdfa.flavours.PDFAFlavour;

public final class PBCosVisitor
implements ICOSVisitor {
    private final PDDocument document;
    private final PDFAFlavour flavour;

    private PBCosVisitor(PDDocument document, PDFAFlavour flavour) {
        this.document = document;
        this.flavour = flavour;
    }

    public static PBCosVisitor getInstance(PDDocument document, PDFAFlavour flavour) {
        return new PBCosVisitor(document, flavour);
    }

    public Object visitFromArray(COSArray obj) {
        return new PBCosArray(obj, this.document, this.flavour);
    }

    public Object visitFromBoolean(COSBoolean obj) {
        return PBCosBool.valueOf(obj);
    }

    public Object visitFromDictionary(COSDictionary obj) {
        COSName type = obj.getCOSName(COSName.TYPE);
        boolean isFileSpec = type != null && COSName.FILESPEC.equals((Object)type);
        return isFileSpec ? new PBCosFileSpecification(obj, this.document, this.flavour) : new PBCosDict(obj, this.document, this.flavour);
    }

    public Object visitFromDocument(COSDocument obj) {
        return new PBCosDocument(obj, this.flavour);
    }

    public Object visitFromFloat(COSFloat obj) {
        return new PBCosReal((COSNumber)obj);
    }

    public Object visitFromInt(COSInteger obj) {
        return new PBCosInteger(obj);
    }

    public Object visitFromName(COSName obj) {
        return new PBCosName(obj);
    }

    public Object visitFromNull(COSNull obj) {
        return PBCosNull.getInstance();
    }

    public Object visitFromStream(COSStream obj) {
        return new PBCosStream(obj, this.document, this.flavour);
    }

    public Object visitFromString(COSString obj) {
        return new PBCosString(obj);
    }

    public static Object visitFromObject(COSObject obj, PDDocument document, PDFAFlavour flavour) {
        return new PBCosIndirect(obj, document, flavour);
    }
}

