/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.model.impl.pb.pd.images;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSStream;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.common.COSObjectable;
import org.apache.pdfbox.pdmodel.graphics.form.PDFormXObject;
import org.verapdf.model.coslayer.CosDict;
import org.verapdf.model.coslayer.CosStream;
import org.verapdf.model.impl.pb.cos.PBCosStream;
import org.verapdf.model.impl.pb.pd.PBoxPDContentStream;
import org.verapdf.model.impl.pb.pd.PBoxPDGroup;
import org.verapdf.model.impl.pb.pd.images.PBoxPDXObject;
import org.verapdf.model.pdlayer.PDContentStream;
import org.verapdf.model.pdlayer.PDGroup;
import org.verapdf.model.pdlayer.PDXForm;
import org.verapdf.model.tools.resources.PDInheritableResources;
import org.verapdf.pdfa.flavours.PDFAFlavour;

public class PBoxPDXForm
extends PBoxPDXObject
implements PDXForm {
    public static final String X_FORM_TYPE = "PDXForm";
    public static final String GROUP = "Group";
    public static final String PS = "PS";
    public static final String REF = "Ref";
    public static final String CONTENT_STREAM = "contentStream";
    private List<PDContentStream> contentStreams = null;
    private List<PDGroup> groups = null;
    private boolean groupContainsTransparency = false;
    private boolean contentStreamContainsTransparency = false;

    public PBoxPDXForm(PDFormXObject simplePDObject, PDInheritableResources resources, PDDocument document, PDFAFlavour flavour) {
        super((COSObjectable)simplePDObject, resources, X_FORM_TYPE, document, flavour);
    }

    public String getSubtype2() {
        String subType = null;
        try (COSStream subtype2 = ((PDFormXObject)this.simplePDObject).getCOSStream();){
            COSBase item = subtype2.getDictionaryObject(COSName.getPDFName((String)"Subtype2"));
            if (item instanceof COSName) {
                subType = ((COSName)item).getName();
            }
        }
        catch (IOException excep) {
            excep.printStackTrace();
        }
        return subType;
    }

    @Override
    public List<? extends org.verapdf.model.baselayer.Object> getLinkedObjects(String link) {
        switch (link) {
            case "Group": {
                return this.getGroup();
            }
            case "PS": {
                return this.getPS();
            }
            case "Ref": {
                return this.getREF();
            }
            case "contentStream": {
                return this.getContentStream();
            }
        }
        return super.getLinkedObjects(link);
    }

    private List<PDGroup> getGroup() {
        if (this.groups == null) {
            this.initializeGroups();
        }
        return this.groups;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List<CosStream> getPS() {
        try (COSStream cosStream = ((PDFormXObject)this.simplePDObject).getCOSStream();
             COSStream ps = (COSStream)cosStream.getDictionaryObject(COSName.PS);){
            if (ps == null) return Collections.emptyList();
            ArrayList<PBCosStream> postScript = new ArrayList<PBCosStream>(1);
            postScript.add(new PBCosStream(ps, this.document, this.flavour));
            List<CosStream> list = Collections.unmodifiableList(postScript);
            return list;
        }
        catch (IOException excep) {
            excep.printStackTrace();
        }
        return Collections.emptyList();
    }

    private List<CosDict> getREF() {
        return this.getLinkToDictionary(REF);
    }

    private List<PDContentStream> getContentStream() {
        if (this.contentStreams == null) {
            this.parseContentStream();
        }
        return this.contentStreams;
    }

    private void initializeGroups() {
        org.apache.pdfbox.pdmodel.graphics.form.PDGroup group = ((PDFormXObject)this.simplePDObject).getGroup();
        if (group != null) {
            this.groupContainsTransparency = COSName.TRANSPARENCY.equals((Object)group.getSubType());
            ArrayList<PBoxPDGroup> groupsToAdd = new ArrayList<PBoxPDGroup>(1);
            groupsToAdd.add(new PBoxPDGroup(group, this.document, this.flavour));
            this.groups = Collections.unmodifiableList(groupsToAdd);
        } else {
            this.groups = Collections.emptyList();
        }
    }

    private void parseContentStream() {
        ArrayList<PDContentStream> streams = new ArrayList<PDContentStream>(1);
        PBoxPDContentStream pdContentStream = new PBoxPDContentStream((org.apache.pdfbox.contentstream.PDContentStream)((PDFormXObject)this.simplePDObject), this.resources, this.document, this.flavour);
        this.contentStreamContainsTransparency = pdContentStream.isContainsTransparency();
        streams.add(pdContentStream);
        this.contentStreams = streams;
    }

    public boolean containsTransparency() {
        if (this.groups == null) {
            this.initializeGroups();
        }
        if (this.contentStreams == null) {
            this.parseContentStream();
        }
        return this.groupContainsTransparency || this.contentStreamContainsTransparency;
    }
}

