/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement(namespace="http://www.verapdf.org/JpylyzerConfig", name="jpylyzerConfig")
final class JpylyzerConfig {
    @XmlElement
    private final String cliPath;
    @XmlElement
    private final String outFolder;
    @XmlElement
    private final boolean isVerbose;

    private JpylyzerConfig() {
        this("", "", false);
    }

    private JpylyzerConfig(String outFolder, String cliPath, boolean isVerbose) {
        this.cliPath = cliPath;
        this.outFolder = outFolder;
        this.isVerbose = isVerbose;
    }

    public String getOutFolder() {
        return this.outFolder;
    }

    public boolean isVerbose() {
        return this.isVerbose;
    }

    public String getCliPath() {
        return this.cliPath;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JpylyzerConfig config = (JpylyzerConfig)o;
        if (this.isVerbose != config.isVerbose) {
            return false;
        }
        if (this.cliPath != null ? !this.cliPath.equals(config.cliPath) : config.cliPath != null) {
            return false;
        }
        return this.outFolder != null ? this.outFolder.equals(config.outFolder) : config.outFolder == null;
    }

    public int hashCode() {
        int result = this.cliPath != null ? this.cliPath.hashCode() : 0;
        result = 31 * result + (this.outFolder != null ? this.outFolder.hashCode() : 0);
        result = 31 * result + (this.isVerbose ? 1 : 0);
        return result;
    }

    static JpylyzerConfig defaultInstance() {
        return new JpylyzerConfig(null, null, false);
    }

    static JpylyzerConfig fromValues(String cliPath, String outFolder, boolean isVerbose) {
        return new JpylyzerConfig(cliPath, outFolder, isVerbose);
    }

    static String toXml(JpylyzerConfig toConvert, Boolean prettyXml) throws JAXBException, IOException {
        String retVal = "";
        try (StringWriter writer = new StringWriter();){
            JpylyzerConfig.toXml(toConvert, writer, prettyXml);
            String string = retVal = writer.toString();
            return string;
        }
    }

    static JpylyzerConfig fromXml(String toConvert) throws JAXBException {
        try (StringReader reader = new StringReader(toConvert);){
            JpylyzerConfig jpylyzerConfig = JpylyzerConfig.fromXml(reader);
            return jpylyzerConfig;
        }
    }

    static void toXml(JpylyzerConfig toConvert, OutputStream stream, Boolean prettyXml) throws JAXBException {
        Marshaller varMarshaller = JpylyzerConfig.getMarshaller(prettyXml);
        varMarshaller.marshal((Object)toConvert, stream);
    }

    static JpylyzerConfig fromXml(InputStream toConvert) throws JAXBException {
        Unmarshaller stringUnmarshaller = JpylyzerConfig.getUnmarshaller();
        return (JpylyzerConfig)stringUnmarshaller.unmarshal(toConvert);
    }

    static void toXml(JpylyzerConfig toConvert, Writer writer, Boolean prettyXml) throws JAXBException {
        Marshaller varMarshaller = JpylyzerConfig.getMarshaller(prettyXml);
        varMarshaller.marshal((Object)toConvert, writer);
    }

    static JpylyzerConfig fromXml(Reader toConvert) throws JAXBException {
        Unmarshaller stringUnmarshaller = JpylyzerConfig.getUnmarshaller();
        return (JpylyzerConfig)stringUnmarshaller.unmarshal(toConvert);
    }

    private static Unmarshaller getUnmarshaller() throws JAXBException {
        JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{JpylyzerConfig.class});
        return context.createUnmarshaller();
    }

    private static Marshaller getMarshaller(Boolean setPretty) throws JAXBException {
        JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{JpylyzerConfig.class});
        Marshaller marshaller = context.createMarshaller();
        marshaller.setProperty("jaxb.formatted.output", (Object)setPretty);
        return marshaller;
    }
}

