/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf;

import au.edu.apsr.mtk.base.AmdSec;
import au.edu.apsr.mtk.base.DigiprovMD;
import au.edu.apsr.mtk.base.DmdSec;
import au.edu.apsr.mtk.base.METS;
import au.edu.apsr.mtk.base.METSException;
import au.edu.apsr.mtk.base.METSWrapper;
import au.edu.apsr.mtk.base.MdWrap;
import au.edu.apsr.mtk.base.RightsMD;
import au.edu.apsr.mtk.base.SourceMD;
import au.edu.apsr.mtk.base.TechMD;
import com.adobe.xmp.XMPException;
import com.adobe.xmp.XMPMeta;
import com.adobe.xmp.XMPMetaFactory;
import com.adobe.xmp.impl.VeraPDFMeta;
import com.adobe.xmp.impl.VeraPDFXMPNode;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.verapdf.METSTypeRegistry;
import org.verapdf.core.FeatureParsingException;
import org.verapdf.features.AbstractMetadataFeaturesExtractor;
import org.verapdf.features.MetadataFeaturesData;
import org.verapdf.features.tools.FeatureTreeNode;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class METSMetadataExtractor
extends AbstractMetadataFeaturesExtractor {
    private XMPMeta dmdMeta = null;
    private XMPMeta rightsMeta = null;
    private XMPMeta techMeta = null;
    private XMPMeta sourceMeta = null;
    private XMPMeta digiprovMeta = null;

    public List<FeatureTreeNode> getMetadataFeatures(MetadataFeaturesData metadataFeaturesData) {
        ArrayList<FeatureTreeNode> result = new ArrayList<FeatureTreeNode>(1);
        try {
            File outFile = this.getOutFile(result);
            byte[] bytes = metadataFeaturesData.getStream();
            this.convertXMPToMETS(new ByteArrayInputStream(bytes), new FileOutputStream(outFile));
            FeatureTreeNode node = FeatureTreeNode.createRootNode((String)"resultFile");
            node.setValue(outFile.getCanonicalPath());
            result.add(node);
        }
        catch (METSException | XMPException | IOException | ParserConfigurationException | FeatureParsingException | SAXException e) {
            try {
                result.clear();
                FeatureTreeNode node = FeatureTreeNode.createRootNode((String)"error");
                node.setValue(e.getMessage());
                result.add(node);
            }
            catch (FeatureParsingException e1) {
                throw new IllegalStateException(e1);
            }
        }
        return result;
    }

    private void convertXMPToMETS(InputStream toConvert, OutputStream out) throws XMPException, METSException, IOException, SAXException, ParserConfigurationException {
        VeraPDFMeta meta = VeraPDFMeta.parse((InputStream)toConvert);
        this.divideMetas(meta);
        METSWrapper metsWrapper = new METSWrapper();
        this.createMETS(metsWrapper);
        metsWrapper.write(out);
    }

    private void createMETS(METSWrapper metsWrapper) throws METSException, SAXException, ParserConfigurationException, XMPException, IOException {
        METS mets = metsWrapper.getMETSObject();
        if (this.dmdMeta != null) {
            DmdSec dmd = mets.newDmdSec();
            dmd.setID("DMD_ID_1");
            MdWrap dmdWrap = dmd.newMdWrap();
            this.addXMPTreeToMdWrap(dmdWrap, this.dmdMeta);
            dmd.setMdWrap(dmdWrap);
            mets.addDmdSec(dmd);
        }
        if (this.rightsMeta != null || this.techMeta != null || this.sourceMeta != null || this.digiprovMeta != null) {
            AmdSec amd = mets.newAmdSec();
            if (this.rightsMeta != null) {
                RightsMD rightsMD = amd.newRightsMD();
                rightsMD.setID("RIGHTSMD_ID_1");
                MdWrap rightsWrap = rightsMD.newMdWrap();
                this.addXMPTreeToMdWrap(rightsWrap, this.rightsMeta);
                rightsMD.setMdWrap(rightsWrap);
                amd.addRightsMD(rightsMD);
            }
            if (this.techMeta != null) {
                TechMD techMD = amd.newTechMD();
                techMD.setID("TECHMD_ID_1");
                MdWrap techWrap = techMD.newMdWrap();
                this.addXMPTreeToMdWrap(techWrap, this.techMeta);
                techMD.setMdWrap(techWrap);
                amd.addTechMD(techMD);
            }
            if (this.sourceMeta != null) {
                SourceMD sourceMD = amd.newSourceMD();
                sourceMD.setID("SOURCEMD_ID_1");
                MdWrap sourceWrap = sourceMD.newMdWrap();
                this.addXMPTreeToMdWrap(sourceWrap, this.sourceMeta);
                sourceMD.setMdWrap(sourceWrap);
                amd.addSourceMD(sourceMD);
            }
            if (this.digiprovMeta != null) {
                DigiprovMD digiprovMD = amd.newDigiprovMD();
                digiprovMD.setID("DIGIPROVMD_ID_1");
                MdWrap digiprovWrap = digiprovMD.newMdWrap();
                this.addXMPTreeToMdWrap(digiprovWrap, this.digiprovMeta);
                digiprovMD.setMdWrap(digiprovWrap);
                amd.addDigiprovMD(digiprovMD);
            }
            mets.addAmdSec(amd);
        }
    }

    private void addXMPTreeToMdWrap(MdWrap wrap, XMPMeta meta) throws XMPException, ParserConfigurationException, IOException, SAXException {
        ByteArrayOutputStream bstream = new ByteArrayOutputStream();
        XMPMetaFactory.serialize((XMPMeta)meta, (OutputStream)bstream);
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document doc = builder.parse(new ByteArrayInputStream(bstream.toByteArray()));
        wrap.setXmlData((Node)doc.getDocumentElement());
        wrap.setMDType("OTHER");
        wrap.setOtherMDType("XMP");
    }

    private void divideMetas(VeraPDFMeta meta) {
        ArrayList<String[]> properties;
        List xmpProps = meta.getProperties();
        if (meta.getExtensionSchemasNode() != null) {
            properties = new ArrayList(xmpProps.size() + 1);
            properties.add(new String[]{"http://www.aiim.org/pdfa/ns/extension/", "schemas"});
        } else {
            properties = new ArrayList<String[]>(xmpProps.size());
        }
        for (VeraPDFXMPNode node : xmpProps) {
            properties.add(new String[]{node.getNamespaceURI(), node.getName()});
        }
        this.dmdMeta = meta.getCloneOfInitialMeta();
        this.rightsMeta = meta.getCloneOfInitialMeta();
        this.techMeta = meta.getCloneOfInitialMeta();
        this.sourceMeta = meta.getCloneOfInitialMeta();
        this.digiprovMeta = meta.getCloneOfInitialMeta();
        boolean isDMDEmpty = true;
        boolean isRightsEmpty = true;
        boolean isTechEmpty = true;
        boolean isSourceEmpty = true;
        boolean isDIGIPROVEmpty = true;
        for (String[] el : properties) {
            switch (METSTypeRegistry.getTypeForProperty(el[0], el[1])) {
                case DMD_SEC: {
                    isDMDEmpty = false;
                    this.rightsMeta.deleteProperty(el[0], el[1]);
                    this.techMeta.deleteProperty(el[0], el[1]);
                    this.sourceMeta.deleteProperty(el[0], el[1]);
                    this.digiprovMeta.deleteProperty(el[0], el[1]);
                    break;
                }
                case RIGHTS_MD: {
                    isRightsEmpty = false;
                    this.dmdMeta.deleteProperty(el[0], el[1]);
                    this.techMeta.deleteProperty(el[0], el[1]);
                    this.sourceMeta.deleteProperty(el[0], el[1]);
                    this.digiprovMeta.deleteProperty(el[0], el[1]);
                    break;
                }
                case TECH_MD: {
                    isTechEmpty = false;
                    this.dmdMeta.deleteProperty(el[0], el[1]);
                    this.rightsMeta.deleteProperty(el[0], el[1]);
                    this.sourceMeta.deleteProperty(el[0], el[1]);
                    this.digiprovMeta.deleteProperty(el[0], el[1]);
                    break;
                }
                case SOURCE_MD: {
                    isSourceEmpty = false;
                    this.dmdMeta.deleteProperty(el[0], el[1]);
                    this.rightsMeta.deleteProperty(el[0], el[1]);
                    this.techMeta.deleteProperty(el[0], el[1]);
                    this.digiprovMeta.deleteProperty(el[0], el[1]);
                    break;
                }
                case DIGIPROV_MD: {
                    isDIGIPROVEmpty = false;
                    this.dmdMeta.deleteProperty(el[0], el[1]);
                    this.rightsMeta.deleteProperty(el[0], el[1]);
                    this.techMeta.deleteProperty(el[0], el[1]);
                    this.sourceMeta.deleteProperty(el[0], el[1]);
                }
            }
        }
        if (isDMDEmpty) {
            this.dmdMeta = null;
        }
        if (isRightsEmpty) {
            this.rightsMeta = null;
        }
        if (isTechEmpty) {
            this.techMeta = null;
        }
        if (isSourceEmpty) {
            this.sourceMeta = null;
        }
        if (isDIGIPROVEmpty) {
            this.digiprovMeta = null;
        }
    }

    private File getOutFile(List<FeatureTreeNode> nodes) throws FeatureParsingException, IOException {
        String out = (String)this.getAttributes().get("outFolder");
        if (out == null) {
            return this.getOutFileInFolder(this.getTempFolder());
        }
        File outFolder = new File(out);
        if (outFolder.isDirectory()) {
            return this.getOutFileInFolder(outFolder);
        }
        FeatureTreeNode node = FeatureTreeNode.createRootNode((String)"error");
        node.setValue("Config file contains out folder path but it doesn't link a directory.");
        nodes.add(node);
        return this.getOutFileInFolder(this.getTempFolder());
    }

    private File getTempFolder() {
        File tempDir = new File(System.getProperty("java.io.tmpdir"));
        File tempFolder = new File(tempDir, "veraPDFMETSPluginTemp");
        if (!tempFolder.exists()) {
            tempFolder.mkdir();
        }
        return tempFolder;
    }

    private File getOutFileInFolder(File folder) throws IOException {
        return File.createTempFile("veraPDF_METS_Plugin_out", ".xml", folder);
    }
}

