/*
 * Decompiled with CFR 0.152.
 */
package au.edu.apsr.mtk.base;

import au.edu.apsr.mtk.base.File;
import au.edu.apsr.mtk.base.METSElement;
import au.edu.apsr.mtk.base.METSException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileGrp
extends METSElement {
    private List<FileGrp> fileGrps = null;
    private List<File> files = null;

    public FileGrp(Node n) throws METSException {
        super(n, "fileGrp");
        this.init();
    }

    public File newFile() throws METSException {
        return new File(this.newElement("file"));
    }

    public FileGrp newFileGrp() throws METSException {
        return new FileGrp(this.newElement("fileGrp"));
    }

    public String getID() {
        return super.getAttributeValue("ID");
    }

    public void setID(String id) {
        super.setAttributeValue("ID", id);
    }

    public void removeID() {
        super.removeAttribute("ID");
    }

    public String getUse() {
        return super.getAttributeValue("USE");
    }

    public void setUse(String use) {
        super.setAttributeValue("USE", use);
    }

    public void removeUse() {
        super.removeAttribute("USE");
    }

    public String getVersDate() {
        return super.getAttributeValue("VERSDATE");
    }

    public void setVersDate(String versDate) {
        super.setAttributeValue("VERSDATE", versDate);
    }

    public void removeVersDate() {
        super.removeAttribute("VERSDATE");
    }

    public String getAdmID() {
        return super.getAttributeValue("ADMID");
    }

    public void setAdmID(String admID) {
        super.setAttributeValue("ADMID", admID);
    }

    public String[] getAdmIDs() {
        return super.getAttributeValue("ADMID").split("\\s+");
    }

    public void removeAdmID() {
        super.removeAttribute("ADMID");
    }

    public List<File> getFiles() throws METSException {
        return this.files;
    }

    public File getFile(String id) throws METSException {
        if (this.files == null) {
            this.initChildFiles();
        }
        File file = null;
        for (File f : this.files) {
            if (!f.getID().equals(id)) continue;
            file = f;
            break;
        }
        return file;
    }

    public File addFile(File file) {
        for (File f : this.files) {
            if (!f.getID().equals(file.getID())) continue;
            this.getElement().replaceChild(file.getElement(), f.getElement());
            this.files.add(file);
            return f;
        }
        this.getElement().appendChild(file.getElement());
        this.files.add(file);
        return null;
    }

    public File removeFile(String id) {
        Iterator<File> i = this.files.iterator();
        while (i.hasNext()) {
            File f = i.next();
            if (!f.getID().equals(id)) continue;
            this.getElement().removeChild(f.getElement());
            i.remove();
            return f;
        }
        return null;
    }

    public List<FileGrp> getFileGrps() throws METSException {
        return this.fileGrps;
    }

    public List<FileGrp> getFileGrpByUse(String use) throws METSException {
        if (this.fileGrps == null) {
            this.initChildFileGrps();
        }
        ArrayList<FileGrp> al = new ArrayList<FileGrp>();
        for (FileGrp fileGrp : this.fileGrps) {
            if (!fileGrp.getUse().equals(use)) continue;
            al.add(fileGrp);
        }
        return al;
    }

    public FileGrp addFileGrp(FileGrp fileGrp) {
        if (fileGrp.getID().equals("")) {
            this.getElement().appendChild(fileGrp.getElement());
            this.fileGrps.add(fileGrp);
            return null;
        }
        for (FileGrp fg : this.fileGrps) {
            if (!fg.getID().equals(fileGrp.getID())) continue;
            this.getElement().replaceChild(fileGrp.getElement(), fg.getElement());
            this.fileGrps.add(fileGrp);
            return fg;
        }
        this.getElement().appendChild(fileGrp.getElement());
        this.fileGrps.add(fileGrp);
        return null;
    }

    public FileGrp removeFileGrp(String id) {
        Iterator<FileGrp> i = this.fileGrps.iterator();
        while (i.hasNext()) {
            FileGrp fg = i.next();
            if (!fg.getID().equals(id)) continue;
            this.getElement().removeChild(fg.getElement());
            i.remove();
            return fg;
        }
        return null;
    }

    public FileGrp removeFileGrp(int pos) {
        for (int i = 0; i < this.fileGrps.size(); ++i) {
            if (i != pos) continue;
            this.getElement().removeChild(this.fileGrps.get(i).getElement());
            return this.fileGrps.remove(i);
        }
        return null;
    }

    private void init() throws METSException {
        this.initChildFiles();
        this.initChildFileGrps();
    }

    private void initChildFiles() throws METSException {
        this.files = new ArrayList<File>();
        List<Node> l = super.getChildElements("file");
        for (Node n : l) {
            this.files.add(new File(n));
        }
    }

    private void initChildFileGrps() throws METSException {
        this.fileGrps = new ArrayList<FileGrp>();
        List<Node> l = super.getChildElements("fileGrp");
        for (Node n : l) {
            this.fileGrps.add(new FileGrp(n));
        }
    }
}

