/*
 * Decompiled with CFR 0.152.
 */
package au.edu.apsr.mtk.base;

import au.edu.apsr.mtk.base.Fptr;
import au.edu.apsr.mtk.base.METSElement;
import au.edu.apsr.mtk.base.METSException;
import au.edu.apsr.mtk.base.Mptr;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Div
extends METSElement {
    private List<Div> divs = null;
    private List<Fptr> fptrs = null;
    private List<Mptr> mptrs = null;

    public Div(Node n) throws METSException {
        super(n, "div");
        this.init();
    }

    public Div newDiv() throws METSException {
        return new Div(this.newElement("div"));
    }

    public Mptr newMptr() throws METSException {
        return new Mptr(this.newElement("mptr"));
    }

    public Fptr newFptr() throws METSException {
        return new Fptr(this.newElement("fptr"));
    }

    public String getID() {
        return super.getAttributeValue("ID");
    }

    public void setID(String id) {
        super.setAttributeValue("ID", id);
    }

    public void removeID() {
        super.removeAttribute("ID");
    }

    public String getType() {
        return super.getAttributeValue("TYPE");
    }

    public void setType(String type) {
        super.setAttributeValue("TYPE", type);
    }

    public void removeType() {
        super.removeAttribute("TYPE");
    }

    public String getOrder() {
        return super.getAttributeValue("ORDER");
    }

    public void setOrder(String order) {
        super.setAttributeValue("ORDER", order);
    }

    public void removeOrder() {
        super.removeAttribute("ORDER");
    }

    public String getOrderLabel() {
        return super.getAttributeValue("ORDERLABEL");
    }

    public void setOrderLabel(String orderLabel) {
        super.setAttributeValue("ORDERLABEL", orderLabel);
    }

    public void removeOrderLabel() {
        super.removeAttribute("ORDERLABEL");
    }

    public String getLabel() {
        return super.getAttributeValue("LABEL");
    }

    public void setLabel(String label) {
        super.setAttributeValue("LABEL", label);
    }

    public void removeLabel() {
        super.removeAttribute("LABEL");
    }

    public String getDmdID() {
        return super.getAttributeValue("DMDID");
    }

    public String[] getDmdIDs() {
        return super.getAttributeValue("DMDID").split("\\s+");
    }

    public void setDmdID(String dmdID) {
        super.setAttributeValue("DMDID", dmdID);
    }

    public void removeDmdID() {
        super.removeAttribute("DMDID");
    }

    public String getAdmID() {
        return super.getAttributeValue("ADMID");
    }

    public String[] getAdmIDs() {
        return super.getAttributeValue("ADMID").split("\\s+");
    }

    public void setAdmID(String admID) {
        super.setAttributeValue("ADMID", admID);
    }

    public void removeAdmID() {
        super.removeAttribute("ADMID");
    }

    public String getContentIDs() {
        return super.getAttributeValue("CONTENTIDS");
    }

    public void setContentIDs(String contentIDs) {
        super.setAttributeValue("CONTENTIDS", contentIDs);
    }

    public void removeContentIDs() {
        super.removeAttribute("CONTENTIDS");
    }

    public String getXLinkLabel() {
        return super.getAttributeValue("xlink:label");
    }

    public void setXLinkLabel(String label) {
        super.setAttributeValueNS("http://www.w3.org/1999/xlink", "xlink:label", label);
    }

    public void removeXLinkLabel() {
        super.removeAttributeNS("http://www.w3.org/1999/xlink", "xlink:label");
    }

    public List<Div> getDivs(String type) throws METSException {
        ArrayList<Div> al = new ArrayList<Div>();
        for (Div div : this.divs) {
            if (!div.getType().equals(type)) continue;
            al.add(div);
        }
        return al;
    }

    public List<Div> getDivs() throws METSException {
        return this.divs;
    }

    public Div addDiv(Div div) {
        if (div.getID().equals("")) {
            this.getElement().appendChild(div.getElement());
            this.divs.add(div);
            return null;
        }
        for (Div d : this.divs) {
            if (!d.getID().equals(div.getID())) continue;
            this.getElement().replaceChild(div.getElement(), d.getElement());
            this.divs.add(div);
            return d;
        }
        this.getElement().appendChild(div.getElement());
        this.divs.add(div);
        return null;
    }

    public Div removeDiv(String id) {
        Iterator<Div> i = this.divs.iterator();
        while (i.hasNext()) {
            Div div = i.next();
            if (!div.getID().equals(id)) continue;
            this.getElement().removeChild(div.getElement());
            i.remove();
            return div;
        }
        return null;
    }

    public void removeDivByType(String type, boolean all) {
        Iterator<Div> i = this.divs.iterator();
        while (i.hasNext()) {
            Div div = i.next();
            if (!div.getType().equals(type)) continue;
            this.getElement().removeChild(div.getElement());
            i.remove();
            if (all) continue;
            break;
        }
    }

    public Div removeDiv(int pos) {
        for (int i = 0; i < this.divs.size(); ++i) {
            if (i != pos) continue;
            this.getElement().removeChild(this.divs.get(i).getElement());
            return this.divs.remove(i);
        }
        return null;
    }

    public List<Fptr> getFptrs() throws METSException {
        return this.fptrs;
    }

    public Fptr addFptr(Fptr fptr) {
        if (fptr.getID().equals("")) {
            this.getElement().appendChild(fptr.getElement());
            this.fptrs.add(fptr);
            return null;
        }
        for (Fptr f : this.fptrs) {
            if (!f.getID().equals(fptr.getID())) continue;
            this.getElement().replaceChild(fptr.getElement(), f.getElement());
            this.fptrs.add(fptr);
            return f;
        }
        this.getElement().appendChild(fptr.getElement());
        this.fptrs.add(fptr);
        return null;
    }

    public Fptr removeFptr(String id) {
        Iterator<Fptr> i = this.fptrs.iterator();
        while (i.hasNext()) {
            Fptr fptr = i.next();
            if (!fptr.getID().equals(id)) continue;
            this.getElement().removeChild(fptr.getElement());
            i.remove();
            return fptr;
        }
        return null;
    }

    public Fptr removeFptr(int pos) {
        for (int i = 0; i < this.fptrs.size(); ++i) {
            if (i != pos) continue;
            this.getElement().removeChild(this.fptrs.get(i).getElement());
            return this.fptrs.remove(i);
        }
        return null;
    }

    public List<Mptr> getMptrs() throws METSException {
        return this.mptrs;
    }

    public Mptr addMptr(Mptr mptr) {
        if (mptr.getID().equals("")) {
            this.getElement().appendChild(mptr.getElement());
            this.mptrs.add(mptr);
            return null;
        }
        for (Mptr m : this.mptrs) {
            if (!m.getID().equals(mptr.getID())) continue;
            this.getElement().replaceChild(mptr.getElement(), m.getElement());
            this.mptrs.add(mptr);
            return m;
        }
        this.getElement().appendChild(mptr.getElement());
        this.mptrs.add(mptr);
        return null;
    }

    public Mptr removeMptr(String id) {
        Iterator<Mptr> i = this.mptrs.iterator();
        while (i.hasNext()) {
            Mptr mptr = i.next();
            if (!mptr.getID().equals(id)) continue;
            this.getElement().removeChild(mptr.getElement());
            i.remove();
            return mptr;
        }
        return null;
    }

    public Mptr removeMptr(int pos) {
        for (int i = 0; i < this.mptrs.size(); ++i) {
            if (i != pos) continue;
            this.getElement().removeChild(this.mptrs.get(i).getElement());
            return this.mptrs.remove(i);
        }
        return null;
    }

    private void init() throws METSException {
        this.initDivs();
        this.initFptrs();
        this.initMptrs();
    }

    private void initDivs() throws METSException {
        if (this.divs == null) {
            this.divs = new ArrayList<Div>();
            List<Node> l = super.getChildElements("div");
            for (Node n : l) {
                this.divs.add(new Div(n));
            }
        }
    }

    private void initFptrs() throws METSException {
        if (this.fptrs == null) {
            this.fptrs = new ArrayList<Fptr>();
            List<Node> l = super.getChildElements("fptr");
            for (Node n : l) {
                this.fptrs.add(new Fptr(n));
            }
        }
    }

    private void initMptrs() throws METSException {
        if (this.mptrs == null) {
            this.mptrs = new ArrayList<Mptr>();
            List<Node> l = super.getChildElements("mptr");
            for (Node n : l) {
                this.mptrs.add(new Mptr(n));
            }
        }
    }
}

