/*
 * Decompiled with CFR 0.152.
 */
package au.edu.apsr.mtk.base;

import au.edu.apsr.mtk.base.METSException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class METSElement {
    private Element e = null;

    protected METSElement(Node n, String name) throws METSException {
        if (n == null) {
            throw new METSException("Null Node passed to constructor");
        }
        if (n instanceof Element) {
            if (!n.getNodeName().endsWith(name)) {
                throw new METSException("Mismatch tag name. Node tag is: " + n.getNodeName() + ", expected: " + name);
            }
        } else {
            throw new METSException("Node of type Element required in constructor");
        }
        this.e = (Element)n;
    }

    protected METSElement(Node n) throws METSException {
        if (n == null) {
            throw new METSException("Null Node passed to constructor");
        }
        if (n instanceof Document) {
            if (!n.getFirstChild().getNodeName().endsWith("mets")) {
                throw new METSException("Mismatch tag name. Node tag is: " + n.getFirstChild().getNodeName() + ", expected: " + "mets");
            }
        } else {
            throw new METSException("Node of type Document required in constructor");
        }
        this.e = ((Document)n).getDocumentElement();
    }

    protected METSElement() throws ParserConfigurationException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document doc = builder.newDocument();
        this.e = doc.createElementNS("http://www.loc.gov/METS/", "mets");
        doc.appendChild(this.e);
    }

    protected String getAttributeValue(String name) {
        return this.e.getAttribute(name);
    }

    protected void setAttributeValue(String name, String value) {
        this.e.setAttribute(name, value);
    }

    protected void setAttributeValueNS(String ns, String name, String value) {
        this.e.setAttributeNS(ns, name, value);
    }

    protected void removeAttribute(String name) {
        this.e.removeAttribute(name);
    }

    protected void removeAttributeNS(String ns, String name) {
        this.e.removeAttributeNS(ns, name);
    }

    protected String getAttributeValue(String ns, String localName) {
        return this.e.getAttributeNS(ns, localName);
    }

    protected String getText() {
        return this.e.getTextContent();
    }

    protected void setText(String value) {
        this.e.setTextContent(value);
    }

    protected NodeList getElements(String localName) {
        return this.e.getElementsByTagNameNS("http://www.loc.gov/METS/", localName);
    }

    protected List<Node> getChildElements(String localName) {
        NodeList nl = this.e.getChildNodes();
        ArrayList<Node> l = new ArrayList<Node>();
        for (int i = 0; i < nl.getLength(); ++i) {
            if (nl.item(i).getNodeType() != 1 || !nl.item(i).getLocalName().equals(localName)) continue;
            l.add(nl.item(i));
        }
        return l;
    }

    protected List<Node> getChildNodes() {
        NodeList nl = this.e.getChildNodes();
        ArrayList<Node> l = new ArrayList<Node>();
        for (int i = 0; i < nl.getLength(); ++i) {
            if (nl.item(i).getNodeType() == 2) continue;
            l.add(nl.item(i));
        }
        return l;
    }

    protected Element getElement() {
        return this.e;
    }

    protected Element newElement(String elementName) {
        return this.getElement().getOwnerDocument().createElementNS("http://www.loc.gov/METS/", elementName);
    }
}

