/*
 * Decompiled with CFR 0.152.
 */
package au.edu.apsr.mtk.base;

import au.edu.apsr.mtk.base.METS;
import au.edu.apsr.mtk.base.METSException;
import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSOutput;
import org.w3c.dom.ls.LSSerializer;
import org.xml.sax.SAXException;

public class METSWrapper {
    private Document doc = null;
    private METS mets = null;

    public METSWrapper() throws METSException {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            this.doc = builder.newDocument();
            Element root = this.doc.createElementNS("http://www.loc.gov/METS/", "mets");
            this.doc.appendChild(root);
            this.mets = new METS(this.doc);
        }
        catch (ParserConfigurationException pce) {
            throw new METSException(pce);
        }
    }

    public METSWrapper(Document d) throws METSException {
        this.doc = d;
        this.mets = new METS(d);
    }

    public Document getMETSDocument() {
        return this.doc;
    }

    public METS getMETSObject() {
        return this.mets;
    }

    public void write(OutputStream os) {
        DOMImplementation impl = this.doc.getImplementation();
        DOMImplementationLS implLS = (DOMImplementationLS)impl.getFeature("LS", "3.0");
        LSOutput lso = implLS.createLSOutput();
        lso.setByteStream(os);
        LSSerializer writer = implLS.createLSSerializer();
        writer.write(this.doc, lso);
    }

    public String toString() {
        DOMImplementation impl = this.doc.getImplementation();
        DOMImplementationLS implLS = (DOMImplementationLS)impl.getFeature("LS", "3.0");
        LSSerializer writer = implLS.createLSSerializer();
        return writer.writeToString(this.doc);
    }

    public void validate() throws SAXException, MalformedURLException, IOException {
        SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        URL metsSchema = new URL("http://www.loc.gov/standards/mets/mets.xsd");
        StreamSource schemaFile = new StreamSource(metsSchema.openStream());
        Schema schema = factory.newSchema(schemaFile);
        Validator validator = schema.newValidator();
        validator.validate(new DOMSource(this.doc));
    }

    public void validate(String schemaUrl) throws SAXException, MalformedURLException, IOException {
        SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        URL metsSchema = new URL(schemaUrl);
        StreamSource schemaFile = new StreamSource(metsSchema.openStream());
        Schema schema = factory.newSchema(schemaFile);
        Validator validator = schema.newValidator();
        validator.validate(new DOMSource(this.doc));
    }
}

